<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    use HasFactory;
    protected $guarded = [
        'id'
    ];

    public function head()
    {
        return $this->belongsTo(ExpenseHead::class, 'expenseHead', 'id');
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id', 'id');
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

    public function bankAccount()
    {
        return $this->belongsTo(Banking::class, 'bank_account_id');
    }
}
