<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTableToEmployeeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->string("email")->nullable()->uniqid();
            $table->string("employee_id")->nullable()->uniqid();
            $table->string('blode_group')->nullable();
            $table->integer('house_allowance')->nullable();
            $table->integer('transport_allowance')->nullable();
            $table->integer('other_allowance')->nullable();
            $table->integer('bonous')->nullable();
            $table->integer('advance_salary')->nullable();
            $table->integer('working_day')->nullable();
            $table->integer('absent_day')->nullable();
            $table->tinyInteger('salary_generate')->default(0);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            $dropColumn = [
                'email',
                'employee_id',
                'blode_group',
                'house_allowance',
                'transport_allowance',
                'other_allowance',
                'bonous',
                'advance_salary',
                'working_day',
                'absent_day',
                'salary_generate',
            ];
            $table->dropColumn($dropColumn);
        });
    }
}
