<?php

namespace App\Classes\SMS;

use App\Http\Controllers\CompanyInfoController;
use App\Jobs\SendSmsJob;
use App\Models\Client;
use App\Models\CompanyInformation;


class DisableCustomerSms
{
    public function sendSms($client_id)
    {
        $company_info = CompanyInformation::latest()->first();
        $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'disable_customer_sms')->first()->tamplate_body, true);
        $sms_send = $sms_setting["sendsms"];
        $message = $sms_setting["sms_body"];
        $client = Client::with('clientsinfo', 'pop', 'customerAccount')->where('id', $client_id)->first();
        $link = new  CompanyInfoController();

        if ($sms_send == "Yes" && $client->pop->bill_generate == 'yes') {
            $message = str_replace(
                [
                    '{c_id}',
                    '{c_code}',
                    '{c_password}',
                    '{c_username}',
                    '{c_name}',
                    '{c_deadline}',
                    '{TotalDue}',
                    '{payment_url}',
                    '{company_name}',
                    '{company_cell}',
                ],
                [
                    $client->id,
                    $client->customer_code,
                    $client->password,
                    $client->userid,
                    $client->clientsinfo->clients_name,
                    $client->expire_date,
                    $client->customerAccount->dueAmount ?? 0,
                    $link->baseUrl() . $client->slug,
                    $company_info->name,
                    $company_info->mobile,
                ],
                $message
            );

            $data = [
                'message' => $message,
                'contact_no' => $client->clientsinfo->contact_no,
                'type' => 'disable_customer'
            ];

            SendSmsJob::dispatch($data);
        }
    }
}
