<?php

namespace App\Jobs;

use App\Services\ClientDisableService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MakeClientDisableJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $client;
    private $details;
    private $authUserId;
    public function __construct($client, $details, $authUserId)
    {
        $this->client = $client;
        $this->details = $details;
        $this->authUserId = $authUserId;
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        (new ClientDisableService)->disable($this->client, $this->details, $this->authUserId);
    }
}
