<script>
    $(function() {
        $('.select2').select2({
            placeholder: "Select an option",
            allowClear: true
        });


        //Initialize Select2 Elements
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        });

        //Datemask dd/mm/yyyy
        $('#datemask').inputmask('dd/mm/yyyy', {
            'placeholder': 'dd/mm/yyyy'
        })
        //Datemask2 mm/dd/yyyy
        $('#datemask2').inputmask('mm/dd/yyyy', {
            'placeholder': 'mm/dd/yyyy'
        })
        //Money Euro
        $('[data-mask]').inputmask()

        //Date picker
        $('#searchFrom').datetimepicker({
            format: 'L'
            // format: 'DD/MM/YYYY'
        });
        $('#searchFrom2').datetimepicker({
            format: 'L'
        });

        $('#searchTo').datetimepicker({
            format: 'L'
        });
        $('#invoice_month').datetimepicker({
            format: 'L'
        });
        $('#payment_due_date').datetimepicker({
            format: 'L'
        });

        $('#paymentDatePicker').datetimepicker({
            format: 'L'
        });

        $('.datepicker').datetimepicker({
            format: 'L'
        });


        //Date and time picker
        $('#reservationdatetime').datetimepicker({
            icons: {
                time: 'far fa-clock'
            }
        });

        //Date range picker
        $('#reservation').daterangepicker();
        //Date range picker with time picker
        $('#reservationtime').daterangepicker({
            timePicker: true,
            timePickerIncrement: 30,
            locale: {
                format: 'MM/DD/YYYY hh:mm A'
            }
        });
        //Date range as a button
        $('#daterange-btn').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
            },
            function(start, end) {
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format(
                    'MMMM D, YYYY'))
            }
        );




    });




    $(document).ready(function() {


        $('#dataTable').DataTable({
            responsive: true,
            "bProcessing": true,
            "iDisplayLength": 100,
            'order': [
                [0, "desc"]
            ]
        });
        $("#loader").hide();
    });

    $(document).ready(function() {
        $('#descDatatable').DataTable({
            "order": [
                [3, "desc"]
            ]
        });
        $("#loader").hide();
    });


    $('#dataTable').show();

    // $(".dataTableLoader").show();

    function startProcessing() {
        $('body').prepend('<div id="loading">Processing.....</div>');
    }

    function stopProcessing() {
        $('#loading').remove();
    }

    $(function() {

        $('#userSearch').on('keyup', function(e) {
            e.preventDefault();
            // $('body').append('<div class="hidden" id="processing">processing.....</div>');
            // $('.userSearchClose').html("<span class='btn btn-danger rounded userSearchClear'>X</span>");
            $.ajax({
                type: 'get',
                url: '<?php echo e(route('clientSearchResult')); ?>',
                data: {
                    id: $(this).val()
                },

                success: function(result) {
                    $('#list').show();
                    $('#list').html(result);
                    $('#processing').remove();
                }
            });
        });

    });

    $(document).on('click', '.changeExpireDate', function() {
        let client_id = $(this).data('id');
        $('#client_id').val(client_id);
    });

    $(document).on('click', '#processExpireDate', function() {
        let client_id = $('#client_id').val();
        let expire_date = $('#expireDate').val();
        $.ajax({
            type: 'post',
            url: '<?php echo e(route('changeExpireDate')); ?>',
            data: {
                client_id: client_id,
                expire_date: expire_date
            },

            success: function(result) {
                console.log(result.cstatus);
                if (result.status == 'success') {
                    toastr.success(result.message);
                    $('.bdate_exp' + client_id).text(result.expire_date);
                    if (result.cstatus == 'expired') {
                        $('.cStatus' + client_id).removeClass('bg-success').addClass('bg-danger');
                        $('.cExpireDate' + client_id).removeClass('bg-success').addClass(
                            'bg-danger');
                    }
                    if (result.cstatus == 'active') {
                        $('.cStatus' + client_id).removeClass('bg-danger').addClass('bg-success');
                        $('.cExpireDate' + client_id).removeClass('bg-danger').addClass(
                            'bg-success');
                    }

                } else {
                    $('#expire_date').val('');
                    $('#client_id').val('');
                    toastr.error(result.message);
                }
                $('#expire_date').val('');
                $('#client_id').val('');
                $('#changeExpireDate').modal('hide');


            }
        });
    });



    $(document).on('click', '.viewInvoice', function() {
        $('#processing').show();
        $('.invoiceModal').show();
        var id = $(this).data('id');
        $.ajax({
            type: 'get',
            url: '/admin/invoice/' + id,
            data: {
                id: id
            },
            success: function(result) {
                $('#processing').hide();
                $('.invoiceModal').html('<div class="customermodal">' + result + '</div>');
            }
        });

    });

    $(document).on('click', '.invoiceClose', function() {
        $('.customermodal').remove();
        $('.invoiceModal').hide();
    });

    $(document).on('click', '.sendInvoice', function() {
        var id = $(this).data('id');
        $('#processing').show();

        $.ajax({
            type: 'get',
            url: '/admin/sendInvoice/' + id,
            data: {
                id: id
            },

            success: function(result) {
                $('.customermodal').remove();
                $('#processing').hide();
                if (result.status == 'success') {
                    toastr.success(result.message);
                } else {
                    toastr.error(result.message);
                }
            }
        });
    });



    $('#reseller').on('change', function(e) {
        e.preventDefault();
        $('#processing').show();

        $.ajax({
            type: 'get',
            url: '<?php echo e(route('getResellerPopList')); ?>',
            data: {
                id: $(this).val()
            },
            success: function(result) {
                $('#pop').html(result);
                $('#processing').hide();
            }
        });
    });

    $(function() {

        $(document).on('change', '#checkAmount', function() {
            var checkStatus = document.getElementById("checkAmount").checked;




            if (checkStatus) {
                $('#paymentAmount').show();
                $('.day_to_day_enable').hide();
                $('#paymentDay').val('');
            } else {
                $('#paymentAmount').val('');
                $('#paymentAmount').hide();
                $('.day_to_day_enable').show();
            }
        });

        $(document).on('click', '.goToBillPayment', function() {
            var id = $(this).data('id');
            window.location.href = '/admin/getPaymentHistory/' + id;
        });
        $(document).on('click', '.viewLog', function() {
            var id = $(this).data('id');
            window.open('/admin/getCustomerLogHistory/' + id, '_blank');
        });
        $(document).on('click', '.viewDetails', function() {
            var id = $(this).data('id');
            window.open('/admin/clients/' + id, '_blank');
        });
        $(document).on('click', '.viewDetailsClose', function() {
            var id = $(this).data('id');
            window.open('/admin/close-customer-details/' + id, '_blank');
        });
        $(document).on('click', '.viewMap', function() {
            var id = $(this).data('id');
            window.open('http://maps.google.com/?q=' + id, '_blank');
        });

        var payment_month_show_in_remark = '<?php echo e(checkSettings('payment_month_show_in_remark')); ?>';
        var payment_month_short_in_remark = '<?php echo e(checkSettings('payment_month_short_in_remark')); ?>';

        $(document).on('change', '#ajaxPaymentMonth', function() {

            var month = $('#ajaxPaymentMonth').val();

            if (payment_month_show_in_remark == 'enable') {
                if (payment_month_short_in_remark == 'enable') {
                    $('#paymentDescription').val(month.substring(0, 3));
                } else {
                    $('#paymentDescription').val(month);
                }
            } else {
                $('#paymentDescription').val('Payment of month : ' + month + '. Bill Month : ' + month);
            }
        });

        var token = '';

        $(document).on('click', '.ajaxPayment', function() {

            // $('.select2').val('').trigger('change');
            var amount = $(this).data('amount');
            var id = $(this).data('id');
            var userName = $(this).data('userid');
            $('#cid').val(id);
            $('#clientName').text('CID: ' + id);
            $('#clientNameHead').text('CID: ' + id + '(' + userName + ')');
            $('#paymentAmount').val(amount);


            $.get('/admin/csrf', function(data) {
                $('#csrf').val(data);
            });

            $.get('/admin/due-history-in-payment/' + id, function(data) {
                $('#due-history-in-payment').html(data);
            });
        });

        paymentpage = window.location.href.split('/').includes('getPaymentHistory');

        $(document).on('click', '#ajaxPaymentProcess', function(e) {

            e.preventDefault();
            $('#processing').show();
            var id = $('#cid').val();

            if ($('#print').prop('checked') === true) {
                var posPrint = 1;
            } else {
                var posPrint = 0;
            }
            // console.log('print value', posPrint);

            // jQuery.ajaxSetup({
            //     async: false
            // });
            $.get("<?php echo e(route('csrf')); ?>", function(data) {
                window.token = data;
            });


            data = $('#ajaxPaymentForm').serialize();



            $.ajax({
                type: 'post',
                url: '/admin/payment/' + id,
                dataTye: 'json',
                data: {
                    _token: window.token,
                    client_id: id,
                    details: $('#paymentDetails').val(),
                    month: $('#ajaxPaymentMonth').val(),

                    created_at: $('#created_at').val(), //created at for global ICT

                    description: $('#paymentDescription').val(),
                    collected_by: $('#paymentCollectedBy').val(),
                    payment_type: $('#paymentType').val(),
                    discount: $('#paymentDiscount').val(),
                    amount: $('#paymentAmount').val(),
                    money_receipt_number: $('#moneyReceiptNumber').val(),
                    sms: $('#sms').is(':checked'),
                    payment_day: $('#paymentDay').val(),
                    bill_ids: $('#billIds').val(),
                    bank_account_id: $('#bank_account_id').val(),
                },
                success: function(result) {
                    $('#ajaxPaymentForm').trigger('reset');
                    $('#ajaxPaymentModalClose').trigger('click');

                    if (result.status == 'success') {

                        if (window.paymentpage == true) {

                            $.get('/admin/clientAccount/' + id, function(data) {
                                console.log(data);
                                $('#totalPaidAmount').text(data.totalPaidAmount);
                                $('#totalCurrentAmount').text(data
                                    .totalCurrentAmount);
                                $('#totalOtcAmount').text(data.totalOtcAmount);
                                $('#TotalDueAmount').text(data.totalDueAmount);
                                $('#cExpDate').text(data.cExpireDate);
                            });

                            $.get('/admin/paymentLog/' + id, function(data) {
                                $('#paymentHistoryTable').html(data);
                            });
                        } else {
                            $.get('/admin/clientAccount/' + id, function(data) {
                                console.log(data);
                                $('.listOtcDue' + id).text(data.totalOtcAmount);
                                $('.listDue' + id).text(data.listDue);
                                $('.cStatus' + id).text(data.cStatus);
                                $('.cExpireDate' + id).text('BD: ' + data
                                    .cExpireDate);
                                $('.cStatus' + id).removeClass(
                                    'bg-success bg-warning bg-danger bg-secondary'
                                );
                                $('.cStatus' + id).addClass(data.class);
                                $('.cExpireDate' + id).removeClass(
                                    'bg-success bg-warning bg-danger bg-secondary'
                                );
                                $('.cExpireDate' + id).addClass(data.class);
                            });
                        }

                        if (posPrint == 1) {
                            // window.location.href = '/admin/invoice-print/' + result.payment_id;
                            window.open('/admin/invoice-print/' + result.payment_id,
                                '_blank');
                        }

                        $('#processing').hide();
                        toastr.success(result.message);

                    } else {
                        $('#processing').hide();
                        toastr.error(result.message);
                    }
                }
            });

            // jQuery.ajaxSetup({
            //     async: true
            // });
            console.log('clicked');
        });

        $(document).on('change', '#paymentType', function() {
            let type = $(this).val();
            var id = $('#cid').val();
            console.log(type);

            if (type == 2) {
                let otc_due = $('.listOtcDue' + id).text();
                console.log(otc_due);
                $('#paymentAmount').attr({
                    "max": otc_due
                });
                $('#paymentAmount').val(otc_due);
            } else {
                $('#paymentAmount').removeAttr("max");
                // $('#paymentAmount').val(0);
            }
        });

        $(document).on('click', '.billingCycleChange', function() {
            $(this).hide();
        })
        $(document).on('click', '.packageChange', function() {
            $(this).hide();
        })


        $(document).on('click', '.ajaxRecharge', function() {
            if (!confirm('Are you sure you want to proceed with the Recharge?')) {
                return;
            } else {
                $('#processing').show();

                // $(this).prop('disabled', true);
                // $(this).attr("disabled", true);
                let client_id = [];
                client_id.push($(this).data('id'));
                let this_obj = $(this);
                let id = $(this).data('id');
                let expire_date = $(this).data('expire_date');

                jQuery.ajaxSetup({
                    async: false
                });
                $.get("<?php echo e(route('csrf')); ?>", function(data) {
                    window.token = data;
                });

                $.ajax({
                    url: "<?php echo e(route('CustomerRecharge')); ?>",
                    type: "POST",
                    data: {
                        _token: window.token,
                        ids: client_id,
                        type: "Recharge",
                        uuid: $('#uuid').val(),
                    },
                    success: function(data) {
                        if (data.status == 'success') {
                            toastr.success(data.message);
                            $('#processing').hide();
                            $('.cStatus' + id).removeClass(
                                'bg-success bg-warning bg-danger bg-secondary');
                            $('.cStatus' + id).addClass('bg-success');
                            $('.cStatus' + id).html('Active');

                            $.get('/admin/client-info-data/' + id, function(data) {

                                var text = "BD: " + data.expire_bd + " <br>PD: " +
                                    data.expire_pd;

                                $('.cExpireDate' + id).removeClass(
                                    'bg-success bg-warning bg-danger bg-secondary'
                                );
                                $('.cExpireDate' + id).addClass('bg-success');
                                $('.cExpireDate' + id).html(text);

                            });
                        } else {
                            $('#processing').hide();
                            toastr.error(data.message);
                        }
                    }
                });

            }

        });

        let show_online_offline = $('#show_online_offline_in_top_bar').val();
        // console.log(show_online_offline);
        if (show_online_offline.trim() == 'Yes') {

            setTimeout(function() {
                $.ajax({
                    url: "<?php echo e(route('getOnlineUser')); ?>",
                    type: "GET",
                    success: function(data) {
                        $('#topbar_online_user').text(data.online);
                        let offline = data.total - data.online;
                        $('#topbar_offline_user').text(offline);
                    }
                });
            }, 1000);

            setInterval(function() {
                $.ajax({
                    url: "<?php echo e(route('getOnlineUser')); ?>",
                    type: "GET",
                    success: function(data) {
                        $('#topbar_online_user').text(data.online);
                        let offline = data.total - data.online;
                        $('#topbar_offline_user').text(offline);
                    }
                });
            }, 30000);
        }

        setTimeout(function() {
            $.ajax({
                url: "<?php echo e(route('showSmsBalance')); ?>",
                type: "GET",
                success: function(data) {
                    // console.log(data, 'hello');
                    $('#show_sms_balance').text(data);
                }
            });
        }, 30000);

        // Load voice balance
        setTimeout(function() {
            $.ajax({
                url: "<?php echo e(route('showVoiceBalance')); ?>",
                type: "GET",
                success: function(data) {
                    $('#show_voice_balance').text(data);
                }
            });
        }, 30000);

    });

    $(document).on('click', '.changeTemporaryExtend', function() {
        var id = $(this).attr('data-id');
        var extendedDay = $(this).attr('data-tmpExtend');
        $('#extend').val(extendedDay);
        $('#client_id').val(id);
    });
</script>
<?php /**PATH /var/www/html/extranet/radius-circle/resources/views/clients/JsFile/CustomerAllProperties.blade.php ENDPATH**/ ?>