<?php

namespace App\Services;

use Carbon\Carbon;

class SetExpireDateRoundService
{
    public function generateExpireDate($expireDate)
    {
        $old_expire_date = $expireDate;
        $new_expire_date = Carbon::parse($expireDate)->addMonth();

        $different_in_month =  Carbon::parse($new_expire_date)->format('m') - Carbon::parse($old_expire_date)->format('m');

        if($different_in_month > 1){
            return Carbon::parse($new_expire_date)->subMonth()->lastOfMonth();
        }
       
        return $new_expire_date;
    }

}
