import { Badge } from 'react-bootstrap';
import _ from 'lodash';
import { MdOutlineDeviceHub } from 'react-icons/md';

export const ConnectedComponent = ({ connected_component }) => {
    switch (connected_component?.type) {
        case 'splitter':
            return (
                <Badge className='bg-warning text-dark'>
                    <MdOutlineDeviceHub /> {connected_component.name} (1:
                    {connected_component.split_ratio})
                </Badge>
            );
        case 'onu':
            return (
                <Badge pill className='m-0' bg={'dark'}>
                    <span>{_.capitalize(connected_component.type)}</span>:-{' '}
                    {connected_component.id}:{connected_component.name} (
                    {connected_component.manufactures}:
                    {connected_component.mac_address})
                </Badge>
            );
        case 'client':
            return (
                <Badge pill className='m-0' bg={'dark'}>
                    <span>{_.capitalize(connected_component.type)}</span>:-{' '}
                    {connected_component.client.id}.{' '}
                    {connected_component.clients_name} (
                    {connected_component.client.userid}:{' '}
                    {connected_component.client.clients_status})
                </Badge>
            );
        default:
            return <Badge className='bg-dark'>Nothing connected</Badge>;
    }
};
