@extends('layout.app')
@section('content')

    <div class="card">
        <div class="card-body">

            <form action="{{ route('cash-in-hand', request()->segment(3)) }}" method="get" id="search">
                @method('get')
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input value="{{ $start->format('m/d/y') }}" type="text" name="from_date" class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">

                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input value="{{ $end->format('m/d/y') }}" type="text" name="to_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">

                            </div>


                        </div>
                    </div>


                    <div class="col-md-4">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>

                        </div>
                    </div>


                </div>




            </form>

            <div class="table-responsive">

                @if ($type == 'all')
                    <table class="table" style="width:100%">
                        <thead style="width:100%">
                            <tr>
                                <th class="bg-dark">Name</th>
                                <th class="bg-dark">Opening Balance</th>
                                <th class="bg-dark">Received Amount</th>
                                <th class="bg-dark">Paid Amount</th>
                                <th class="bg-dark">Balance</th>
                                <th class="bg-dark">Action</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td>CASH</td>
                                <td> {{ $cash['cash_opening'] ?? 0 }}</td>
                                <td class="bg-light">{{ $cash['cash_received'] ?? 0 }}</td>
                                <td class="">{{ abs($cash['cash_paid'] ?? 0) }}</td>
                                <td class="bg-light">
                                    {{ ($cash['cash_opening'] ?? 0) + ($cash['cash_received'] ?? 0) + ($cash['cash_paid'] ?? 0) }}
                                </td>
                                <td class="">
                                    <a href="{{ route('cash-in-hand', 'cash') }}" class="btn btn-primary"><i
                                            class="fa fa-eye"></i></a>
                                </td>
                            </tr>
                            {{-- {{dd($data)}} --}}
                            @foreach ($data as $d)
                                @if ($d['email'] != 'soiket@outlook.com' && $d['email'] != 'support@yetfix.com' && $d['email'] != 'rokibulhasan.356@gmail.com' && $d['email'] != 'admin@billingfix.xyz')
                                    <tr>
                                        <td>{{ $d['name'] }}</td>
                                        <td> {{ $d['op_balance'] ?? 0 }}</td>
                                        <td class="bg-light">{{ $d['ramount'] ?? 0 }}</td>
                                        <td class="">{{ $d['pamount'] ?? 0 }}</td>
                                        <td class="bg-light">
                                            {{ ($d['op_balance'] ?? 0) + ($d['ramount'] ?? 0) - ($d['pamount'] ?? 0) }}</td>
                                        <td class="">
                                            <a href="{{ route('view_user_account_history', $d['user_id']) }}"
                                                class="btn btn-primary"><i class="fa fa-eye"></i></a>
                                        </td>
                                    </tr>
                                @endif
                            @endforeach

                            <tr style="display: none">
                                <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                                <td class="bg-secondary" class="bg-light"></td>
                                <td class="bg-secondary"></td>
                                <td class="bg-secondary">
                                    {{-- {{ $accounts->sum('received_amount') + $opening_balance - $accounts->sum('paid_amount') }} --}}
                                </td>
                                <td class="bg-secondary"></td>
                            </tr>
                        </tbody>
                    </table>
                @elseif($type == 'cash')
                    <div class="table-responsive">

                        <table class="table" style="width:100%">
                            <thead style="width:100%">
                                <tr>
                                    <th class="bg-dark">Date</th>
                                    <th class="bg-dark">Particulars</th>
                                    <th class="bg-dark">Received Amount</th>
                                    <th class="bg-dark">Paid Amount</th>
                                    <th class="bg-dark">Balance</th>
                                    <th class="bg-dark">Remarks/Narration</th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td class="bg-light"></td>
                                    <td class="">Opening Balance:</td>
                                    <td class="bg-light">{{ $cash['cash_opening'] }}</td>
                                    <td class=""></td>
                                </tr>

                                @php
                                    $tr = 0;
                                    $tp = 0;
                                @endphp
                                @foreach ($data as $d)
                                    <tr>
                                        <td>{{ $d->created_at }}</td>
                                        <td>{{ $d->note }}</td>
                                        <td class="bg-light">
                                            @if ($d->amount > 0)
                                                @php($tr += $d->amount) {{ $d->amount }}
                                            @endif
                                        </td>
                                        <td class="">
                                            @if ($d->amount < 0)
                                                @php($tp += abs($d->amount)) {{ abs($d->amount) }}
                                            @endif
                                        </td>
                                        <td class="bg-light"></td>
                                        <td class=""></td>
                                    </tr>
                                @endforeach

                                <tr>
                                    <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                                    <td class="bg-secondary" class="bg-light">{{ $tr }}</td>
                                    <td class="bg-secondary">{{ $tp }}</td>
                                    <td class="bg-secondary">
                                        {{ $tr + $cash['cash_opening'] - $tp }}
                                    </td>
                                    <td class="bg-secondary"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                @endif


            </div>

            <div id="app" style="display: none">
                <table class="table" style="width:100%;display:none" v-show="true">
                    <thead style="width:100%">
                        <tr>
                            <th class="bg-dark">Name</th>
                            <th class="bg-dark">Opening Balance</th>
                            <th class="bg-dark">Received Amount</th>
                            <th class="bg-dark">Paid Amount</th>
                            <th class="bg-dark">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="cash in data">
                            <td>@{{ cash.name }}</td>
                            <td>@{{ cash.op_balance }}</td>
                            <td v-model.number="item.ramount" class="bg-light">@{{ cash.ramount }}</td>
                            <td class="" v-model.number="item.pamount">@{{ cash.pamount }}</td>
                            <td class="bg-light"> </td>
                        </tr>
                        <tr>
                            <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                            <td class="bg-secondary" class="bg-light"></td>
                            <td class="bg-secondary"></td>
                            <td class="bg-secondary">
                                {{-- {{ $accounts->sum('received_amount') + $opening_balance - $accounts->sum('paid_amount') }} --}}
                            </td>
                            <td class="bg-secondary"></td>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>
    </div>




@endsection

@section('ajax')
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.14"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.24.0/axios.min.js"
        integrity="sha512-u9akINsQsAkG9xjc1cnGF4zw5TFDwkxuc9vUp5dltDWYCSmyd0meygbvgXrlc/z7/o4a19Fb5V0OUE58J7dcyw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                data: [],
                item: {
                    'ramount': '',
                    'pamount': '',
                    'op_balance': ''
                }

            },
            computed: {
                // subtotal:function(){
                //   return this.data.accounts.reduce((item) => {
                //     return parseInt(item.ramount)+parseInt(item.op_balance)-parseInt(item.pamount);
                //   },0)
                // }
            },
            mounted() {
                axios.get('{{ route('cash_in_hand_api') }}')
                    .then(response => {
                        console.log(response.data);
                        this.data = response.data.data;
                    });
            }
        })
    </script>
@endsection
