<?php

namespace App\Services;

use App\Models\Client;
use Illuminate\Support\Facades\DB;

class CheckUniqClientService
{

    public function checkUserAvailabilityOnClientEdit($userId)
    {
        $username = $userId;
        if (!checkAPI()) {
            if (preg_match('/[\'^£$%*()}{~?><>,|=+¬]/', $username)) {
                return false;
            }
            if (preg_match('/^\S.*\s.*\S$/', $username)) {
                return false;
            }
        }
        $result = Client::withTrashed()
                    ->whereRaw('BINARY userid = ?', [$username])
                    ->first();


        if (empty($result)) {
            return true;
        } else {
            return false;
        }
    }


}

