@extends('Customer.customer-layout')


@section('body')

    @include('Customer.left-menu')

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>Bill Pay</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('customerDashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Bill Pay</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
        <section class="section profile">
            <div class="row">

                <div class="col-xl-8">

                    <div class="card">
                        <div class="card-body pt-3">
                            <!-- Bordered Tabs -->

                            @if (Session::has('successMsg'))
                                <p class="alert alert-info">{{ Session::get('successMsg') }}</p>
                            @endif
                            @if (Session::has('error'))
                                <p class="alert alert-danger">{{ Session::get('error') }}</p>
                            @endif

                            <div class="tab-content pt-2">

                                <div class="tab-pane fade show active profile-overview" id="profile-overview">
                                    <h5 class="card-title">Profile Details</h5>

                                    @if (json_decode(siteinfo()->payment_url)->payment_url_enable == 'on')
                                        <h2>Pay now Using Different Url</h2>
                                        <a href="{{ json_decode(siteinfo()->payment_url)->payment_url }}" target="_blank"
                                            class="btn btn-danger mb-5" style="padding:10px 50px;">Pay Now</a>
                                    @endif

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label ">Full Name</div>
                                        <div class="col-lg-9 col-md-8">
                                            {{ $details['userinfo']->clientsinfo->clients_name }}</div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Subscriber ID</div>
                                        <div class="col-lg-9 col-md-8">{{ $details['userinfo']->id }}</div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">PACKAGE NAME</div>
                                        <div class="col-lg-9 col-md-8">{{ $details['package']->package_name }}</div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">STATUS</div>
                                        <div class="col-lg-9 col-md-8">
                                            @if ($details['userinfo']->clients_status == 'expired')
                                                <span
                                                    class="badge bg-danger">{{ $details['userinfo']->clients_status }}</span>
                                            @else
                                                <span
                                                    class="badge bg-success">{{ $details['userinfo']->clients_status }}</span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">PACKAGE PRICE</div>
                                        <div class="col-lg-9 col-md-8">{{ $details['package']->package_rate }}</div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">CURRENT BALANCE</div>
                                        <div class="col-lg-9 col-md-8">
                                            @if (isset($details['account']->dueAmount) && $details['account']->dueAmount < 1)
                                                {{ abs($details['account']->dueAmount) }}
                                            @else
                                                0
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Due Balance</div>
                                        <div class="col-lg-9 col-md-8">
                                            @if (isset($details['account']->dueAmount) && $details['account']->dueAmount > 0)
                                                <span class="text-red-600 font-bold">
                                                    {{ abs($details['account']->dueAmount) }} </span>
                                            @else
                                                0
                                            @endif
                                        </div>
                                    </div>


                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">EXPIRE DATE</div>
                                        <div class="col-lg-9 col-md-8">
                                            {{ date('d-M-Y', strtotime($details['userinfo']->expire_date)) }}</div>
                                    </div>



                                    <div class="row d-none">
                                        <div class="col-lg-3 col-md-4 label ">Name</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="text" name="customer_name" class="border px-3 py-1"
                                                id="customer_name" placeholder=""
                                                value="{{ $details['userinfo']->clientsinfo->clients_name }}"
                                                value="" required>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Mobile</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="text" name="customer_mobile" class="border px-4 py-1"
                                                id="mobile" placeholder="Mobile" readonly
                                                value="{{ $details['userinfo']->clientsinfo->contact_no }}" required>
                                        </div>
                                    </div>

                                    <div class="row d-none">
                                        <div class="col-lg-3 col-md-4 label">Email</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="email" name="customer_email" class="border px-4 py-1"
                                                id="email"
                                                value="{{ $details['userinfo']->clientsinfo->email ?? 'test@gmail.com' }}"
                                                placeholder="you@example.com" required>
                                        </div>
                                    </div>

                                    <div class="row d-none">
                                        <div class="col-lg-3 col-md-4 label">Address</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="text" class="border px-4 py-1 " id="address" name="address1"
                                                placeholder="1234 Main St"
                                                value="{{ $details['userinfo']->clientsinfo->area }}" value=""
                                                required>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Payment Amount</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="hidden" id="customer_id" name="customer_id" class=""
                                                value="{{ $details['userinfo']->id }}">

                                            @if (getBillingType() === 'day_to_day')
                                                <input type="hidden" min="0" value="{{ $bill_amount }}"
                                                    name="amount" id="amount" class="border px-4 py-1" required />
                                                {{ $bill_amount }}
                                            @else
                                                @if (isset($details['account']->dueAmount) && $details['account']->dueAmount > 0)
                                                    <input type="number" min="0" name="amount" id="amount"
                                                        value="{{ abs($details['account']->dueAmount) }}"
                                                        class="border px-4 py-1" required />
                                                @else
                                                    <input type="number" min="0" name="amount" id="amount"
                                                        value="{{ $details['package']->package_rate - $details['userinfo']->parmanent_discount }}"
                                                        class="border px-4 py-1" required />
                                                @endif
                                            @endif


                                        </div>
                                    </div>

                                    @php
                                        $payment_button = collect(siteinfo()->payment_button);
                                        $bkash_image_btn = $buttons->where('type', 'bkash_img')->first();
                                        $ssl_image_btn = $buttons->where('type', 'ssl_img')->first();
                                        $upay_image_btn = $buttons->where('type', 'upay_img')->first();
                                        $nagad_image_btn = $buttons->where('type', 'nagod_img')->first();

                                    @endphp

                                   

                                    <ul class="nav nav-tabs" id="myTab" role="tablist">

                                        <li class="nav-item" role="presentation">
                                            @if (checkSettings('bkash-show') == 'enable')
                                            <button class="nav-link active" id="bkash_payment-tab" 
                                            data-bs-toggle="tab" data-bs-target="#bkash_payment" 
                                            type="button" role="tab" aria-controls="bkash_payment" 
                                            aria-selected="true">Bkash
                                            
                                        </button>
                                            @endif
                                          
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            @if (checkSettings('nagad-checkout-client-payment') == 'enable')
                                          <button class="nav-link" id="nagod_payment-tab" 
                                          data-bs-toggle="tab" data-bs-target="#nagod_payment" 
                                          type="button" role="tab" aria-controls="nagod_payment"
                                           aria-selected="false">Nogod</button>
                                           @endif
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            @if (checkSettings('uddokta-pay-show') == 'enable')
                                            <button class="nav-link" id="uddokta_payment-tab" 
                                            data-bs-toggle="tab" data-bs-target="#uddokta_payment" 
                                            type="button" role="tab" aria-controls="uddokta_payment"
                                            aria-selected="false">Uddokta</button>
                                            @endif
                                          
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            @if (checkSettings('upay-payment') == 'enable')
                                            <button class="nav-link " id="upay_payment-tab" data-bs-toggle="tab"
                                            data-bs-target="#upay_payment" type="button" 
                                            role="tab" aria-controls="upay_payment" aria-selected="true">Upay</button>
                                            @endif
                                          
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            @if (checkSettings('surjo-pay-show') == 'enable')
                                            <button class="nav-link" id="surjo_payment-tab"
                                            data-bs-toggle="tab" data-bs-target="#surjo_payment" 
                                            type="button" role="tab" aria-controls="surjo_payment" 
                                            aria-selected="false">Surjo</button>
                                            @endif
                                          
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            @if (checkSettings('ssl-commerz-show') == 'enable')
                                            <button class="nav-link" id="ssl_payment-tab" 
                                            data-bs-toggle="tab" data-bs-target="#ssl_payment" 
                                            type="button" role="tab" aria-controls="ssl_payment" 
                                            ;aria-selected="false">SSL</button>
                                            @endif
                                          
                                        </li>
                                    
                                      </ul>
                                    
                                    
                                      <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade show active" id="bkash_payment" role="tabpanel" aria-labelledby="bkash_payment-tab">
                                            @if (checkSettings('bkash-tokenized') == 'enable')
                                             <button class="btn btn-default" id="bKash_payment">
                                               
                                    
                                                <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                    src="@if (!empty($bkash_image_btn)) {{ asset('storage/company/' . $bkash_image_btn->value) }} @else https://www.bkash.com/sites/all/themes/bkash/logo.png @endif"
                                                    alt="">
                                             </button>
                                            @endif
                                    
                                        @if (checkSettings('bkash-checkout') == 'enable')
                                            <button id="bKash_button" class="btn btn-default"
                                                onclick="BkashPayment()">
                                                <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                    src="@if (!empty($bkash_image_btn)) {{ asset('storage/company/' . $bkash_image_btn->value) }} @else https://www.bkash.com/sites/all/themes/bkash/logo.png @endif"
                                                    alt="">
                                            </button>
                                        @endif
                                        </div>
                                        <div class="tab-pane fade" id="nagod_payment" role="tabpanel" aria-labelledby="nagod_payment-tab">
                                            <button class="btn btn-default" id="nagad_payment">
                                                
                                                <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                    src="@if (!empty($nagad_image_btn)) {{ asset('storage/company/' . $nagad_image_btn->value) }} @else @endif"
                                                    alt="">
                                            </button>
                                        </div>
                                        <div class="tab-pane fade" id="uddokta_payment" role="tabpanel" aria-labelledby="uddokta_payment-tab">
                                            @if (checkSettings('uddokta-pay-show') == 'enable')
                                           
                                                <button class="btn btn-danger" type="button"
                                                    id="uddokta_pay">Uddokta Pay</button>
                                            
                                        @endif
                                        </div>
                                        <div class="tab-pane fade" id="upay_payment" role="tabpanel" aria-labelledby="upay_payment-tab">
                                            @if (checkSettings('upay-payment') == 'enable')
                                                <button class="btn btn-default" id="upay_payment">
                                                    
                                                    <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                        src="@if (!empty($upay_image_btn)) {{ asset('storage/company/' . $upay_image_btn->value) }} @else @endif"
                                                        alt="">
                                                </button>
                                            @endif
                                        </div>
                                        <div class="tab-pane fade" id="surjo_payment" role="tabpanel" aria-labelledby="surjo_payment-tab">
                                            @if (checkSettings('surjo-pay-show') == 'enable')
                                                <button class="btn btn-default" id="surjo_payment">
                                                    
                                                    <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                        src="{{ asset('images/payment_getway/shurjopay.png') }}"
                                                        alt="">
                                                </button>
                                            @endif
                                        </div>
                                        <div class="tab-pane fade" id="ssl_payment" role="tabpanel" aria-labelledby="ssl_payment-tab">
                                            @if (checkSettings('ssl-commerz-show') == 'enable')
                                                
                                                    <button type="button" id="paySSL" class="btn btn-default">

                                                        <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                            src="@if (!empty($ssl_image_btn)) {{ asset('storage/company/' . $ssl_image_btn->value) }} @else visa.png @endif"
                                                            alt="">
                                                    </button>

                                                    <button style="display: none"
                                                        class="hidden btn btn-primary btn-lg btn-block" id="sslczPayBtn"
                                                        token="if you have any token validation"
                                                        postdata="your javascript arrays or objects which requires in backend"
                                                        order="If you already have the transaction generated for current order"
                                                        endpoint="{{ url('/pay-via-ajax') }}"> Pay Now
                                                    </button>
                                                
                                            @endif
                                        </div>
                                      </div>

                                    
                                </div><!-- End Bordered Tabs -->

                            </div>
                        </div>

                        <div class="card-footer">
                            <button class="btn btn-primary"><a href="{{ route('customerDashboard') }}"
                                    class="text-light"><i class="fa fa-arrow-left"></i>
                                    Back</a></button>
                        </div>

                    </div>




                </div>
        </section>

    </main>
@endsection

@section('script')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"
        integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous">
    </script>
    <link rel="stylesheet" href="{{ asset('/') }}css/toastr.min.css">
    <script src="{{ asset('/') }}js/toastr.min.js"></script>

    {!! Toastr::message() !!}

    @if (checkSettings('ssl-commerz-show') == 'enable')
        @include('Customer.sslcommerz-script')
    @endif

    @if (checkSettings('bkash-tokenized') == 'enable')
        @include('Customer.bkash-tokenized')
    @endif
    @if (checkSettings('bkash-checkout') == 'enable')
        @include('Customer.bkash-checkout')
    @endif
    @if (checkSettings('upay-payment') == 'enable')
        @include('Customer.upay-payment')
    @endif

    @if (checkSettings('nagad-checkout-client-payment') == 'enable')
        @include('Customer.nagad_checkout')
    @endif

    <script>
        // onclick uddokta_pay button send request to pay route
        $('#uddokta_pay').click(function() {

            if ($('#amount').val() == '') {
                toastr.error('Amount is required');
            } else if ($('#customer_name').val() == '') {
                toastr.error('Customer name is required');
            } else if ($('#mobile').val() == '') {
                toastr.error('Mobile number is required');
            } else {
                //submit for
                $.ajax({
                    url: "{{ route('uddoktapay.pay') }}",
                    type: "POST",
                    data: {
                        full_name: $('#customer_name').val(),
                        mobile: $('#mobile').val(),
                        email: $('#email').val(),
                        amount: $('#amount').val(),
                        customer_id: $('#customer_id').val()
                    },
                    success: function(data) {
                        if (data.status == 'success') {
                            window.location.href = data.payment_url;
                        } else {
                            toastr.error(data.message);
                        }
                        //
                    }
                });
            }


        });
    </script>

    @include('Customer.surjopayscript')
@endsection
