<?php

namespace Database\Seeders;

use App\Models\Upazila;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ThanaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $thanas = [
            ['upazila_id' => '1', 'name' => 'Debidwar', 'bn_name' => 'দেবিদ্বার', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '2', 'name' => 'Barura', 'bn_name' => 'বরুড়া', 'url' => 'barura.comilla.gov.bd'],
            ['upazila_id' => '3', 'name' => 'Brahmanpara', 'bn_name' => 'ব্রাহ্মণপাড়া', 'url' => 'brahmanpara.comilla.gov.bd'],
            ['upazila_id' => '4', 'name' => 'Chandina', 'bn_name' => 'চান্দিনা', 'url' => 'chandina.comilla.gov.bd'],
            ['upazila_id' => '5', 'name' => 'Chauddagram', 'bn_name' => 'চৌদ্দগ্রাম', 'url' => 'chauddagram.comilla.gov.bd'],
            ['upazila_id' => '6', 'name' => 'Daudkandi', 'bn_name' => 'দাউদকান্দি', 'url' => 'daudkandi.comilla.gov.bd'],
            ['upazila_id' => '7', 'name' => 'Homna', 'bn_name' => 'হোমনা', 'url' => 'homna.comilla.gov.bd'],
            ['upazila_id' => '8', 'name' => 'Laksam', 'bn_name' => 'লাকসাম', 'url' => 'laksam.comilla.gov.bd'],
            ['upazila_id' => '9', 'name' => 'Muradnagar', 'bn_name' => 'মুরাদনগর', 'url' => 'muradnagar.comilla.gov.bd'],
            ['upazila_id' => '10', 'name' => 'Nangalkot', 'bn_name' => 'নাঙ্গলকোট', 'url' => 'nangalkot.comilla.gov.bd'],
            ['upazila_id' => '11', 'name' => 'Comilla Sadar', 'bn_name' => 'কুমিল্লা সদর', 'url' => 'comillasadar.comilla.gov.bd'],
            ['upazila_id' => '12', 'name' => 'Meghna', 'bn_name' => 'মেঘনা', 'url' => 'meghna.comilla.gov.bd'],
            ['upazila_id' => '13', 'name' => 'Monohargonj', 'bn_name' => 'মনোহরগঞ্জ', 'url' => 'monohargonj.comilla.gov.bd'],
            ['upazila_id' => '14', 'name' => 'Sadarsouth', 'bn_name' => 'সদর দক্ষিণ', 'url' => 'sadarsouth.comilla.gov.bd'],
            ['upazila_id' => '15', 'name' => 'Titas', 'bn_name' => 'তিতাস', 'url' => 'titas.comilla.gov.bd'],
            ['upazila_id' => '16', 'name' => 'Burichang', 'bn_name' => 'বুড়িচং', 'url' => 'burichang.comilla.gov.bd'],
            ['upazila_id' => '17', 'name' => 'Lalmai', 'bn_name' => 'লালমাই', 'url' => 'lalmai.comilla.gov.bd'],
            ['upazila_id' => '18', 'name' => 'Chhagalnaiya', 'bn_name' => 'ছাগলনাইয়া', 'url' => 'chhagalnaiya.feni.gov.bd'],
            ['upazila_id' => '19', 'name' => 'Feni Sadar', 'bn_name' => 'ফেনী সদর', 'url' => 'sadar.feni.gov.bd'],
            ['upazila_id' => '20', 'name' => 'Sonagazi', 'bn_name' => 'সোনাগাজী', 'url' => 'sonagazi.feni.gov.bd'],
            ['upazila_id' => '21', 'name' => 'Fulgazi', 'bn_name' => 'ফুলগাজী', 'url' => 'fulgazi.feni.gov.bd'],
            ['upazila_id' => '22', 'name' => 'Parshuram', 'bn_name' => 'পরশুরাম', 'url' => 'parshuram.feni.gov.bd'],
            ['upazila_id' => '23', 'name' => 'Daganbhuiyan', 'bn_name' => 'দাগনভূঞা', 'url' => 'daganbhuiyan.feni.gov.bd'],
            ['upazila_id' => '24', 'name' => 'Brahmanbaria Sadar', 'bn_name' => 'ব্রাহ্মণবাড়িয়া সদর', 'url' => 'sadar.brahmanbaria.gov.bd'],
            ['upazila_id' => '25', 'name' => 'Kasba', 'bn_name' => 'কসবা', 'url' => 'kasba.brahmanbaria.gov.bd'],
            ['upazila_id' => '26', 'name' => 'Nasirnagar', 'bn_name' => 'নাসিরনগর', 'url' => 'nasirnagar.brahmanbaria.gov.bd'],
            ['upazila_id' => '27', 'name' => 'Sarail', 'bn_name' => 'সরাইল', 'url' => 'sarail.brahmanbaria.gov.bd'],
            ['upazila_id' => '28', 'name' => 'Ashuganj', 'bn_name' => 'আশুগঞ্জ', 'url' => 'ashuganj.brahmanbaria.gov.bd'],
            ['upazila_id' => '29', 'name' => 'Akhaura', 'bn_name' => 'আখাউড়া', 'url' => 'akhaura.brahmanbaria.gov.bd'],
            ['upazila_id' => '30', 'name' => 'Nabinagar', 'bn_name' => 'নবীনগর', 'url' => 'nabinagar.brahmanbaria.gov.bd'],
            ['upazila_id' => '31', 'name' => 'Bancharampur', 'bn_name' => 'বাঞ্ছারামপুর', 'url' => 'bancharampur.brahmanbaria.gov.bd'],
            ['upazila_id' => '32', 'name' => 'Bijoynagar', 'bn_name' => 'বিজয়নগর', 'url' => 'bijoynagar.brahmanbaria.gov.bd    '],
            ['upazila_id' => '33', 'name' => 'Rangamati Sadar', 'bn_name' => 'রাঙ্গামাটি সদর', 'url' => 'sadar.rangamati.gov.bd'],
            ['upazila_id' => '34', 'name' => 'Kaptai', 'bn_name' => 'কাপ্তাই', 'url' => 'kaptai.rangamati.gov.bd'],
            ['upazila_id' => '35', 'name' => 'Kawkhali', 'bn_name' => 'কাউখালী', 'url' => 'kawkhali.rangamati.gov.bd'],
            ['upazila_id' => '36', 'name' => 'Baghaichari', 'bn_name' => 'বাঘাইছড়ি', 'url' => 'baghaichari.rangamati.gov.bd'],
            ['upazila_id' => '37', 'name' => 'Barkal', 'bn_name' => 'বরকল', 'url' => 'barkal.rangamati.gov.bd'],
            ['upazila_id' => '38', 'name' => 'Langadu', 'bn_name' => 'লংগদু', 'url' => 'langadu.rangamati.gov.bd'],
            ['upazila_id' => '39', 'name' => 'Rajasthali', 'bn_name' => 'রাজস্থলী', 'url' => 'rajasthali.rangamati.gov.bd'],
            ['upazila_id' => '40', 'name' => 'Belaichari', 'bn_name' => 'বিলাইছড়ি', 'url' => 'belaichari.rangamati.gov.bd'],
            ['upazila_id' => '41', 'name' => 'Juraichari', 'bn_name' => 'জুরাছড়ি', 'url' => 'juraichari.rangamati.gov.bd'],
            ['upazila_id' => '42', 'name' => 'Naniarchar', 'bn_name' => 'নানিয়ারচর', 'url' => 'naniarchar.rangamati.gov.bd'],
            ['upazila_id' => '43', 'name' => 'Noakhali Sadar', 'bn_name' => 'নোয়াখালী সদর', 'url' => 'sadar.noakhali.gov.bd'],
            ['upazila_id' => '44', 'name' => 'Companiganj', 'bn_name' => 'কোম্পানীগঞ্জ', 'url' => 'companiganj.noakhali.gov.bd'],
            ['upazila_id' => '45', 'name' => 'Begumganj', 'bn_name' => 'বেগমগঞ্জ', 'url' => 'begumganj.noakhali.gov.bd'],
            ['upazila_id' => '46', 'name' => 'Hatia', 'bn_name' => 'হাতিয়া', 'url' => 'hatia.noakhali.gov.bd'],
            ['upazila_id' => '47', 'name' => 'Subarnachar', 'bn_name' => 'সুবর্ণচর', 'url' => 'subarnachar.noakhali.gov.bd'],
            ['upazila_id' => '48', 'name' => 'Kabirhat', 'bn_name' => 'কবিরহাট', 'url' => 'kabirhat.noakhali.gov.bd'],
            ['upazila_id' => '49', 'name' => 'Senbug', 'bn_name' => 'সেনবাগ', 'url' => 'senbug.noakhali.gov.bd'],
            ['upazila_id' => '50', 'name' => 'Chatkhil', 'bn_name' => 'চাটখিল', 'url' => 'chatkhil.noakhali.gov.bd'],
            ['upazila_id' => '51', 'name' => 'Sonaimori', 'bn_name' => 'সোনাইমুড়ী', 'url' => 'sonaimori.noakhali.gov.bd'],
            ['upazila_id' => '52', 'name' => 'Haimchar', 'bn_name' => 'হাইমচর', 'url' => 'haimchar.chandpur.gov.bd'],
            ['upazila_id' => '53', 'name' => 'Kachua', 'bn_name' => 'কচুয়া', 'url' => 'kachua.chandpur.gov.bd'],
            ['upazila_id' => '54', 'name' => 'Shahrasti', 'bn_name' => 'শাহরাস্তি	', 'url' => 'shahrasti.chandpur.gov.bd'],
            ['upazila_id' => '55', 'name' => 'Chandpur Sadar', 'bn_name' => 'চাঁদপুর সদর', 'url' => 'sadar.chandpur.gov.bd'],
            ['upazila_id' => '56', 'name' => 'Matlab South', 'bn_name' => 'মতলব দক্ষিণ', 'url' => 'matlabsouth.chandpur.gov.bd'],
            ['upazila_id' => '57', 'name' => 'Hajiganj', 'bn_name' => 'হাজীগঞ্জ', 'url' => 'hajiganj.chandpur.gov.bd'],
            ['upazila_id' => '58', 'name' => 'Matlab North', 'bn_name' => 'মতলব উত্তর', 'url' => 'matlabnorth.chandpur.gov.bd'],
            ['upazila_id' => '59', 'name' => 'Faridgonj', 'bn_name' => 'ফরিদগঞ্জ', 'url' => 'faridgonj.chandpur.gov.bd'],
            ['upazila_id' => '60', 'name' => 'Lakshmipur Sadar', 'bn_name' => 'লক্ষ্মীপুর সদর', 'url' => 'sadar.lakshmipur.gov.bd'],
            ['upazila_id' => '61', 'name' => 'Kamalnagar', 'bn_name' => 'কমলনগর', 'url' => 'kamalnagar.lakshmipur.gov.bd'],
            ['upazila_id' => '62', 'name' => 'Raipur', 'bn_name' => 'রায়পুর', 'url' => 'raipur.lakshmipur.gov.bd'],
            ['upazila_id' => '63', 'name' => 'Ramgati', 'bn_name' => 'রামগতি', 'url' => 'ramgati.lakshmipur.gov.bd'],
            ['upazila_id' => '64', 'name' => 'Ramganj', 'bn_name' => 'রামগঞ্জ', 'url' => 'ramganj.lakshmipur.gov.bd'],
            ['upazila_id' => '65', 'name' => 'Rangunia', 'bn_name' => 'রাঙ্গুনিয়া', 'url' => 'rangunia.chittagong.gov.bd'],
            ['upazila_id' => '66', 'name' => 'Sitakunda', 'bn_name' => 'সীতাকুন্ড', 'url' => 'sitakunda.chittagong.gov.bd'],
            ['upazila_id' => '67', 'name' => 'Mirsharai', 'bn_name' => 'মীরসরাই', 'url' => 'mirsharai.chittagong.gov.bd'],
            ['upazila_id' => '68', 'name' => 'Patiya', 'bn_name' => 'পটিয়া', 'url' => 'patiya.chittagong.gov.bd'],
            ['upazila_id' => '69', 'name' => 'Sandwip', 'bn_name' => 'সন্দ্বীপ', 'url' => 'sandwip.chittagong.gov.bd'],
            ['upazila_id' => '70', 'name' => 'Banshkhali', 'bn_name' => 'বাঁশখালী', 'url' => 'banshkhali.chittagong.gov.bd'],
            ['upazila_id' => '71', 'name' => 'Boalkhali', 'bn_name' => 'বোয়ালখালী', 'url' => 'boalkhali.chittagong.gov.bd'],
            ['upazila_id' => '72', 'name' => 'Anwara', 'bn_name' => 'আনোয়ারা', 'url' => 'anwara.chittagong.gov.bd'],
            ['upazila_id' => '73', 'name' => 'Chandanaish', 'bn_name' => 'চন্দনাইশ', 'url' => 'chandanaish.chittagong.gov.bd'],
            ['upazila_id' => '74', 'name' => 'Satkania', 'bn_name' => 'সাতকানিয়া', 'url' => 'satkania.chittagong.gov.bd'],
            ['upazila_id' => '75', 'name' => 'Lohagara', 'bn_name' => 'লোহাগাড়া', 'url' => 'lohagara.chittagong.gov.bd'],
            ['upazila_id' => '76', 'name' => 'Hathazari', 'bn_name' => 'হাটহাজারী', 'url' => 'hathazari.chittagong.gov.bd'],
            ['upazila_id' => '77', 'name' => 'Fatikchhari', 'bn_name' => 'ফটিকছড়ি', 'url' => 'fatikchhari.chittagong.gov.bd'],
            ['upazila_id' => '78', 'name' => 'Raozan', 'bn_name' => 'রাউজান', 'url' => 'raozan.chittagong.gov.bd'],
            ['upazila_id' => '79', 'name' => 'Karnafuli', 'bn_name' => 'কর্ণফুলী', 'url' => 'karnafuli.chittagong.gov.bd'],
            ['upazila_id' => '80', 'name' => 'Coxsbazar Sadar', 'bn_name' => 'কক্সবাজার সদর', 'url' => 'sadar.coxsbazar.gov.bd'],
            ['upazila_id' => '81', 'name' => 'Chakaria', 'bn_name' => 'চকরিয়া', 'url' => 'chakaria.coxsbazar.gov.bd'],
            ['upazila_id' => '82', 'name' => 'Kutubdia', 'bn_name' => 'কুতুবদিয়া', 'url' => 'kutubdia.coxsbazar.gov.bd'],
            ['upazila_id' => '83', 'name' => 'Ukhiya', 'bn_name' => 'উখিয়া', 'url' => 'ukhiya.coxsbazar.gov.bd'],
            ['upazila_id' => '84', 'name' => 'Moheshkhali', 'bn_name' => 'মহেশখালী', 'url' => 'moheshkhali.coxsbazar.gov.bd'],
            ['upazila_id' => '85', 'name' => 'Pekua', 'bn_name' => 'পেকুয়া', 'url' => 'pekua.coxsbazar.gov.bd'],
            ['upazila_id' => '86', 'name' => 'Ramu', 'bn_name' => 'রামু', 'url' => 'ramu.coxsbazar.gov.bd'],
            ['upazila_id' => '87', 'name' => 'Teknaf', 'bn_name' => 'টেকনাফ', 'url' => 'teknaf.coxsbazar.gov.bd'],
            ['upazila_id' => '88', 'name' => 'Khagrachhari Sadar', 'bn_name' => 'খাগড়াছড়ি সদর', 'url' => 'sadar.khagrachhari.gov.bd'],
            ['upazila_id' => '89', 'name' => 'Dighinala', 'bn_name' => 'দিঘীনালা', 'url' => 'dighinala.khagrachhari.gov.bd'],
            ['upazila_id' => '90', 'name' => 'Panchari', 'bn_name' => 'পানছড়ি', 'url' => 'panchari.khagrachhari.gov.bd'],
            ['upazila_id' => '91', 'name' => 'Laxmichhari', 'bn_name' => 'লক্ষীছড়ি', 'url' => 'laxmichhari.khagrachhari.gov.bd'],
            ['upazila_id' => '92', 'name' => 'Mohalchari', 'bn_name' => 'মহালছড়ি', 'url' => 'mohalchari.khagrachhari.gov.bd'],
            ['upazila_id' => '93', 'name' => 'Manikchari', 'bn_name' => 'মানিকছড়ি', 'url' => 'manikchari.khagrachhari.gov.bd'],
            ['upazila_id' => '94', 'name' => 'Ramgarh', 'bn_name' => 'রামগড়', 'url' => 'ramgarh.khagrachhari.gov.bd'],
            ['upazila_id' => '95', 'name' => 'Matiranga', 'bn_name' => 'মাটিরাঙ্গা', 'url' => 'matiranga.khagrachhari.gov.bd'],
            ['upazila_id' => '96', 'name' => 'Guimara', 'bn_name' => 'গুইমারা', 'url' => 'guimara.khagrachhari.gov.bd'],
            ['upazila_id' => '97', 'name' => 'Bandarban Sadar', 'bn_name' => 'বান্দরবান সদর', 'url' => 'sadar.bandarban.gov.bd'],
            ['upazila_id' => '98', 'name' => 'Alikadam', 'bn_name' => 'আলীকদম', 'url' => 'alikadam.bandarban.gov.bd'],
            ['upazila_id' => '99', 'name' => 'Naikhongchhari', 'bn_name' => 'নাইক্ষ্যংছড়ি', 'url' => 'naikhongchhari.bandarban.gov.bd'],
            ['upazila_id' => '100', 'name' => 'Rowangchhari', 'bn_name' => 'রোয়াংছড়ি', 'url' => 'rowangchhari.bandarban.gov.bd'],
            ['upazila_id' => '101', 'name' => 'Lama', 'bn_name' => 'লামা', 'url' => 'lama.bandarban.gov.bd'],
            ['upazila_id' => '102', 'name' => 'Ruma', 'bn_name' => 'রুমা', 'url' => 'ruma.bandarban.gov.bd'],
            ['upazila_id' => '103', 'name' => 'Thanchi', 'bn_name' => 'থানচি', 'url' => 'thanchi.bandarban.gov.bd'],
            ['upazila_id' => '104', 'name' => 'Belkuchi', 'bn_name' => 'বেলকুচি', 'url' => 'belkuchi.sirajganj.gov.bd'],
            ['upazila_id' => '105', 'name' => 'Chauhali', 'bn_name' => 'চৌহালি', 'url' => 'chauhali.sirajganj.gov.bd'],
            ['upazila_id' => '106', 'name' => 'Kamarkhand', 'bn_name' => 'কামারখন্দ', 'url' => 'kamarkhand.sirajganj.gov.bd'],
            ['upazila_id' => '107', 'name' => 'Kazipur', 'bn_name' => 'কাজীপুর', 'url' => 'kazipur.sirajganj.gov.bd'],
            ['upazila_id' => '108', 'name' => 'Raigonj', 'bn_name' => 'রায়গঞ্জ', 'url' => 'raigonj.sirajganj.gov.bd'],
            ['upazila_id' => '109', 'name' => 'Shahjadpur', 'bn_name' => 'শাহজাদপুর', 'url' => 'shahjadpur.sirajganj.gov.bd'],
            ['upazila_id' => '110', 'name' => 'Sirajganj Sadar', 'bn_name' => 'সিরাজগঞ্জ সদর', 'url' => 'sirajganjsadar.sirajganj.gov.bd'],
            ['upazila_id' => '111', 'name' => 'Tarash', 'bn_name' => 'তাড়াশ', 'url' => 'tarash.sirajganj.gov.bd'],
            ['upazila_id' => '112', 'name' => 'Ullapara', 'bn_name' => 'উল্লাপাড়া', 'url' => 'ullapara.sirajganj.gov.bd'],
            ['upazila_id' => '113', 'name' => 'Sujanagar', 'bn_name' => 'সুজানগর', 'url' => 'sujanagar.pabna.gov.bd'],
            ['upazila_id' => '114', 'name' => 'Ishurdi', 'bn_name' => 'ঈশ্বরদী', 'url' => 'ishurdi.pabna.gov.bd'],
            ['upazila_id' => '115', 'name' => 'Bhangura', 'bn_name' => 'ভাঙ্গুড়া', 'url' => 'bhangura.pabna.gov.bd'],
            ['upazila_id' => '116', 'name' => 'Pabna Sadar', 'bn_name' => 'পাবনা সদর', 'url' => 'pabnasadar.pabna.gov.bd'],
            ['upazila_id' => '117', 'name' => 'Bera', 'bn_name' => 'বেড়া', 'url' => 'bera.pabna.gov.bd'],
            ['upazila_id' => '118', 'name' => 'Atghoria', 'bn_name' => 'আটঘরিয়া', 'url' => 'atghoria.pabna.gov.bd'],
            ['upazila_id' => '119', 'name' => 'Chatmohar', 'bn_name' => 'চাটমোহর', 'url' => 'chatmohar.pabna.gov.bd'],
            ['upazila_id' => '120', 'name' => 'Santhia', 'bn_name' => 'সাঁথিয়া', 'url' => 'santhia.pabna.gov.bd'],
            ['upazila_id' => '121', 'name' => 'Faridpur', 'bn_name' => 'ফরিদপুর', 'url' => 'faridpur.pabna.gov.bd'],
            ['upazila_id' => '122', 'name' => 'Kahaloo', 'bn_name' => 'কাহালু', 'url' => 'kahaloo.bogra.gov.bd'],
            ['upazila_id' => '123', 'name' => 'Bogra Sadar', 'bn_name' => 'বগুড়া সদর', 'url' => 'sadar.bogra.gov.bd'],
            ['upazila_id' => '124', 'name' => 'Shariakandi', 'bn_name' => 'সারিয়াকান্দি', 'url' => 'shariakandi.bogra.gov.bd'],
            ['upazila_id' => '125', 'name' => 'Shajahanpur', 'bn_name' => 'শাজাহানপুর', 'url' => 'shajahanpur.bogra.gov.bd'],
            ['upazila_id' => '126', 'name' => 'Dupchanchia', 'bn_name' => 'দুপচাচিঁয়া', 'url' => 'dupchanchia.bogra.gov.bd'],
            ['upazila_id' => '127', 'name' => 'Adamdighi', 'bn_name' => 'আদমদিঘি', 'url' => 'adamdighi.bogra.gov.bd'],
            ['upazila_id' => '128', 'name' => 'Nondigram', 'bn_name' => 'নন্দিগ্রাম', 'url' => 'nondigram.bogra.gov.bd'],
            ['upazila_id' => '129', 'name' => 'Sonatala', 'bn_name' => 'সোনাতলা', 'url' => 'sonatala.bogra.gov.bd'],
            ['upazila_id' => '130', 'name' => 'Dhunot', 'bn_name' => 'ধুনট', 'url' => 'dhunot.bogra.gov.bd'],
            ['upazila_id' => '131', 'name' => 'Gabtali', 'bn_name' => 'গাবতলী', 'url' => 'gabtali.bogra.gov.bd'],
            ['upazila_id' => '132', 'name' => 'Sherpur', 'bn_name' => 'শেরপুর', 'url' => 'sherpur.bogra.gov.bd'],
            ['upazila_id' => '133', 'name' => 'Shibganj', 'bn_name' => 'শিবগঞ্জ', 'url' => 'shibganj.bogra.gov.bd'],
            ['upazila_id' => '134', 'name' => 'Paba', 'bn_name' => 'পবা', 'url' => 'paba.rajshahi.gov.bd'],
            ['upazila_id' => '135', 'name' => 'Durgapur', 'bn_name' => 'দুর্গাপুর', 'url' => 'durgapur.rajshahi.gov.bd'],
            ['upazila_id' => '136', 'name' => 'Mohonpur', 'bn_name' => 'মোহনপুর', 'url' => 'mohonpur.rajshahi.gov.bd'],
            ['upazila_id' => '137', 'name' => 'Charghat', 'bn_name' => 'চারঘাট', 'url' => 'charghat.rajshahi.gov.bd'],
            ['upazila_id' => '138', 'name' => 'Puthia', 'bn_name' => 'পুঠিয়া', 'url' => 'puthia.rajshahi.gov.bd'],
            ['upazila_id' => '139', 'name' => 'Bagha', 'bn_name' => 'বাঘা', 'url' => 'bagha.rajshahi.gov.bd'],
            ['upazila_id' => '140', 'name' => 'Godagari', 'bn_name' => 'গোদাগাড়ী', 'url' => 'godagari.rajshahi.gov.bd'],
            ['upazila_id' => '141', 'name' => 'Tanore', 'bn_name' => 'তানোর', 'url' => 'tanore.rajshahi.gov.bd'],
            ['upazila_id' => '142', 'name' => 'Bagmara', 'bn_name' => 'বাগমারা', 'url' => 'bagmara.rajshahi.gov.bd'],
            ['upazila_id' => '143', 'name' => 'Natore Sadar', 'bn_name' => 'নাটোর সদর', 'url' => 'natoresadar.natore.gov.bd'],
            ['upazila_id' => '144', 'name' => 'Singra', 'bn_name' => 'সিংড়া', 'url' => 'singra.natore.gov.bd'],
            ['upazila_id' => '145', 'name' => 'Baraigram', 'bn_name' => 'বড়াইগ্রাম', 'url' => 'baraigram.natore.gov.bd'],
            ['upazila_id' => '146', 'name' => 'Bagatipara', 'bn_name' => 'বাগাতিপাড়া', 'url' => 'bagatipara.natore.gov.bd'],
            ['upazila_id' => '147', 'name' => 'Lalpur', 'bn_name' => 'লালপুর', 'url' => 'lalpur.natore.gov.bd'],
            ['upazila_id' => '148', 'name' => 'Gurudaspur', 'bn_name' => 'গুরুদাসপুর', 'url' => 'gurudaspur.natore.gov.bd'],
            ['upazila_id' => '149', 'name' => 'Naldanga', 'bn_name' => 'নলডাঙ্গা', 'url' => 'naldanga.natore.gov.bd'],
            ['upazila_id' => '150', 'name' => 'Akkelpur', 'bn_name' => 'আক্কেলপুর', 'url' => 'akkelpur.joypurhat.gov.bd'],
            ['upazila_id' => '151', 'name' => 'Kalai', 'bn_name' => 'কালাই', 'url' => 'kalai.joypurhat.gov.bd'],
            ['upazila_id' => '152', 'name' => 'Khetlal', 'bn_name' => 'ক্ষেতলাল', 'url' => 'khetlal.joypurhat.gov.bd'],
            ['upazila_id' => '153', 'name' => 'Panchbibi', 'bn_name' => 'পাঁচবিবি', 'url' => 'panchbibi.joypurhat.gov.bd'],
            ['upazila_id' => '154', 'name' => 'Joypurhat Sadar', 'bn_name' => 'জয়পুরহাট সদর', 'url' => 'joypurhatsadar.joypurhat.gov.bd'],
            ['upazila_id' => '155', 'name' => 'Chapainawabganj Sadar', 'bn_name' => 'চাঁপাইনবাবগঞ্জ সদর', 'url' => 'chapainawabganjsadar.chapainawabganj.gov.bd'],
            ['upazila_id' => '156', 'name' => 'Gomostapur', 'bn_name' => 'গোমস্তাপুর', 'url' => 'gomostapur.chapainawabganj.gov.bd'],
            ['upazila_id' => '157', 'name' => 'Nachol', 'bn_name' => 'নাচোল', 'url' => 'nachol.chapainawabganj.gov.bd'],
            ['upazila_id' => '158', 'name' => 'Bholahat', 'bn_name' => 'ভোলাহাট', 'url' => 'bholahat.chapainawabganj.gov.bd'],

            ['upazila_id' => '160', 'name' => 'Mohadevpur', 'bn_name' => 'মহাদেবপুর', 'url' => 'mohadevpur.naogaon.gov.bd'],
            ['upazila_id' => '161', 'name' => 'Badalgachi', 'bn_name' => 'বদলগাছী', 'url' => 'badalgachi.naogaon.gov.bd'],
            ['upazila_id' => '162', 'name' => 'Patnitala', 'bn_name' => 'পত্নিতলা', 'url' => 'patnitala.naogaon.gov.bd'],
            ['upazila_id' => '163', 'name' => 'Dhamoirhat', 'bn_name' => 'ধামইরহাট', 'url' => 'dhamoirhat.naogaon.gov.bd'],
            ['upazila_id' => '164', 'name' => 'Niamatpur', 'bn_name' => 'নিয়ামতপুর', 'url' => 'niamatpur.naogaon.gov.bd'],
            ['upazila_id' => '165', 'name' => 'Manda', 'bn_name' => 'মান্দা', 'url' => 'manda.naogaon.gov.bd'],
            ['upazila_id' => '166', 'name' => 'Atrai', 'bn_name' => 'আত্রাই', 'url' => 'atrai.naogaon.gov.bd'],
            ['upazila_id' => '167', 'name' => 'Raninagar', 'bn_name' => 'রাণীনগর', 'url' => 'raninagar.naogaon.gov.bd'],
            ['upazila_id' => '168', 'name' => 'Naogaon Sadar', 'bn_name' => 'নওগাঁ সদর', 'url' => 'naogaonsadar.naogaon.gov.bd'],
            ['upazila_id' => '169', 'name' => 'Porsha', 'bn_name' => 'পোরশা', 'url' => 'porsha.naogaon.gov.bd'],
            ['upazila_id' => '170', 'name' => 'Sapahar', 'bn_name' => 'সাপাহার', 'url' => 'sapahar.naogaon.gov.bd'],
            ['upazila_id' => '171', 'name' => 'Manirampur', 'bn_name' => 'মণিরামপুর', 'url' => 'manirampur.jessore.gov.bd'],
            ['upazila_id' => '172', 'name' => 'Abhaynagar', 'bn_name' => 'অভয়নগর', 'url' => 'abhaynagar.jessore.gov.bd'],
            ['upazila_id' => '173', 'name' => 'Bagherpara', 'bn_name' => 'বাঘারপাড়া', 'url' => 'bagherpara.jessore.gov.bd'],
            ['upazila_id' => '174', 'name' => 'Chougachha', 'bn_name' => 'চৌগাছা', 'url' => 'chougachha.jessore.gov.bd'],
            ['upazila_id' => '175', 'name' => 'Jhikargacha', 'bn_name' => 'ঝিকরগাছা', 'url' => 'jhikargacha.jessore.gov.bd'],
            ['upazila_id' => '176', 'name' => 'Keshabpur', 'bn_name' => 'কেশবপুর', 'url' => 'keshabpur.jessore.gov.bd'],
            ['upazila_id' => '177', 'name' => 'Jessore Sadar', 'bn_name' => 'যশোর সদর', 'url' => 'sadar.jessore.gov.bd'],
            ['upazila_id' => '178', 'name' => 'Sharsha', 'bn_name' => 'শার্শা', 'url' => 'sharsha.jessore.gov.bd'],
            ['upazila_id' => '179', 'name' => 'Assasuni', 'bn_name' => 'আশাশুনি', 'url' => 'assasuni.satkhira.gov.bd'],
            ['upazila_id' => '180', 'name' => 'Debhata', 'bn_name' => 'দেবহাটা', 'url' => 'debhata.satkhira.gov.bd'],
            ['upazila_id' => '181', 'name' => 'Kalaroa', 'bn_name' => 'কলারোয়া', 'url' => 'kalaroa.satkhira.gov.bd'],
            ['upazila_id' => '182', 'name' => 'Satkhira Sadar', 'bn_name' => 'সাতক্ষীরা সদর', 'url' => 'satkhirasadar.satkhira.gov.bd'],
            ['upazila_id' => '183', 'name' => 'Shyamnagar', 'bn_name' => 'শ্যামনগর', 'url' => 'shyamnagar.satkhira.gov.bd'],
            ['upazila_id' => '184', 'name' => 'Tala', 'bn_name' => 'তালা', 'url' => 'tala.satkhira.gov.bd'],
            ['upazila_id' => '185', 'name' => 'Kaliganj', 'bn_name' => 'কালিগঞ্জ', 'url' => 'kaliganj.satkhira.gov.bd'],
            ['upazila_id' => '186', 'name' => 'Mujibnagar', 'bn_name' => 'মুজিবনগর', 'url' => 'mujibnagar.meherpur.gov.bd'],
            ['upazila_id' => '187', 'name' => 'Meherpur Sadar', 'bn_name' => 'মেহেরপুর সদর', 'url' => 'meherpursadar.meherpur.gov.bd'],
            ['upazila_id' => '188', 'name' => 'Gangni', 'bn_name' => 'গাংনী', 'url' => 'gangni.meherpur.gov.bd'],
            ['upazila_id' => '189', 'name' => 'Narail Sadar', 'bn_name' => 'নড়াইল সদর', 'url' => 'narailsadar.narail.gov.bd'],

            ['upazila_id' => '191', 'name' => 'Kalia', 'bn_name' => 'কালিয়া', 'url' => 'kalia.narail.gov.bd'],
            ['upazila_id' => '192', 'name' => 'Chuadanga Sadar', 'bn_name' => 'চুয়াডাঙ্গা সদর', 'url' => 'chuadangasadar.chuadanga.gov.bd'],
            ['upazila_id' => '193', 'name' => 'Alamdanga', 'bn_name' => 'আলমডাঙ্গা', 'url' => 'alamdanga.chuadanga.gov.bd'],
            ['upazila_id' => '194', 'name' => 'Damurhuda', 'bn_name' => 'দামুড়হুদা', 'url' => 'damurhuda.chuadanga.gov.bd'],
            ['upazila_id' => '195', 'name' => 'Jibannagar', 'bn_name' => 'জীবননগর', 'url' => 'jibannagar.chuadanga.gov.bd'],
            ['upazila_id' => '196', 'name' => 'Kushtia Sadar', 'bn_name' => 'কুষ্টিয়া সদর', 'url' => 'kushtiasadar.kushtia.gov.bd'],
            ['upazila_id' => '197', 'name' => 'Kumarkhali', 'bn_name' => 'কুমারখালী', 'url' => 'kumarkhali.kushtia.gov.bd'],
            ['upazila_id' => '198', 'name' => 'Khoksa', 'bn_name' => 'খোকসা', 'url' => 'khoksa.kushtia.gov.bd'],
            ['upazila_id' => '199', 'name' => 'Mirpur', 'bn_name' => 'মিরপুর', 'url' => 'mirpurkushtia.kushtia.gov.bd'],
            ['upazila_id' => '200', 'name' => 'Daulatpur', 'bn_name' => 'দৌলতপুর', 'url' => 'daulatpur.kushtia.gov.bd'],
            ['upazila_id' => '201', 'name' => 'Bheramara', 'bn_name' => 'ভেড়ামারা', 'url' => 'bheramara.kushtia.gov.bd'],
            ['upazila_id' => '202', 'name' => 'Shalikha', 'bn_name' => 'শালিখা', 'url' => 'shalikha.magura.gov.bd'],
            ['upazila_id' => '203', 'name' => 'Sreepur', 'bn_name' => 'শ্রীপুর', 'url' => 'sreepur.magura.gov.bd'],
            ['upazila_id' => '204', 'name' => 'Magura Sadar', 'bn_name' => 'মাগুরা সদর', 'url' => 'magurasadar.magura.gov.bd'],
            ['upazila_id' => '205', 'name' => 'Mohammadpur', 'bn_name' => 'মহম্মদপুর', 'url' => 'mohammadpur.magura.gov.bd'],
            ['upazila_id' => '206', 'name' => 'Paikgasa', 'bn_name' => 'পাইকগাছা', 'url' => 'paikgasa.khulna.gov.bd'],
            ['upazila_id' => '207', 'name' => 'Fultola', 'bn_name' => 'ফুলতলা', 'url' => 'fultola.khulna.gov.bd'],
            ['upazila_id' => '208', 'name' => 'Digholia', 'bn_name' => 'দিঘলিয়া', 'url' => 'digholia.khulna.gov.bd'],
            ['upazila_id' => '209', 'name' => 'Rupsha', 'bn_name' => 'রূপসা', 'url' => 'rupsha.khulna.gov.bd'],
            ['upazila_id' => '210', 'name' => 'Terokhada', 'bn_name' => 'তেরখাদা', 'url' => 'terokhada.khulna.gov.bd'],
            ['upazila_id' => '211', 'name' => 'Dumuria', 'bn_name' => 'ডুমুরিয়া', 'url' => 'dumuria.khulna.gov.bd'],
            ['upazila_id' => '212', 'name' => 'Botiaghata', 'bn_name' => 'বটিয়াঘাটা', 'url' => 'botiaghata.khulna.gov.bd'],
            ['upazila_id' => '213', 'name' => 'Dakop', 'bn_name' => 'দাকোপ', 'url' => 'dakop.khulna.gov.bd'],
            ['upazila_id' => '214', 'name' => 'Koyra', 'bn_name' => 'কয়রা', 'url' => 'koyra.khulna.gov.bd'],
            ['upazila_id' => '215', 'name' => 'Fakirhat', 'bn_name' => 'ফকিরহাট', 'url' => 'fakirhat.bagerhat.gov.bd'],
            ['upazila_id' => '216', 'name' => 'Bagerhat Sadar', 'bn_name' => 'বাগেরহাট সদর', 'url' => 'sadar.bagerhat.gov.bd'],
            ['upazila_id' => '217', 'name' => 'Mollahat', 'bn_name' => 'মোল্লাহাট', 'url' => 'mollahat.bagerhat.gov.bd'],
            ['upazila_id' => '218', 'name' => 'Sarankhola', 'bn_name' => 'শরণখোলা', 'url' => 'sarankhola.bagerhat.gov.bd'],
            ['upazila_id' => '219', 'name' => 'Rampal', 'bn_name' => 'রামপাল', 'url' => 'rampal.bagerhat.gov.bd'],
            ['upazila_id' => '220', 'name' => 'Morrelganj', 'bn_name' => 'মোড়েলগঞ্জ', 'url' => 'morrelganj.bagerhat.gov.bd'],

            ['upazila_id' => '222', 'name' => 'Mongla', 'bn_name' => 'মোংলা', 'url' => 'mongla.bagerhat.gov.bd'],
            ['upazila_id' => '223', 'name' => 'Chitalmari', 'bn_name' => 'চিতলমারী', 'url' => 'chitalmari.bagerhat.gov.bd'],
            ['upazila_id' => '224', 'name' => 'Jhenaidah Sadar', 'bn_name' => 'ঝিনাইদহ সদর', 'url' => 'sadar.jhenaidah.gov.bd'],
            ['upazila_id' => '225', 'name' => 'Shailkupa', 'bn_name' => 'শৈলকুপা', 'url' => 'shailkupa.jhenaidah.gov.bd'],
            ['upazila_id' => '226', 'name' => 'Harinakundu', 'bn_name' => 'হরিণাকুন্ডু', 'url' => 'harinakundu.jhenaidah.gov.bd'],

            ['upazila_id' => '228', 'name' => 'Kotchandpur', 'bn_name' => 'কোটচাঁদপুর', 'url' => 'kotchandpur.jhenaidah.gov.bd'],
            ['upazila_id' => '229', 'name' => 'Moheshpur', 'bn_name' => 'মহেশপুর', 'url' => 'moheshpur.jhenaidah.gov.bd'],
            ['upazila_id' => '230', 'name' => 'Jhalakathi Sadar', 'bn_name' => 'ঝালকাঠি সদর', 'url' => 'sadar.jhalakathi.gov.bd'],
            ['upazila_id' => '231', 'name' => 'Kathalia', 'bn_name' => 'কাঠালিয়া', 'url' => 'kathalia.jhalakathi.gov.bd'],
            ['upazila_id' => '232', 'name' => 'Nalchity', 'bn_name' => 'নলছিটি', 'url' => 'nalchity.jhalakathi.gov.bd'],
            ['upazila_id' => '233', 'name' => 'Rajapur', 'bn_name' => 'রাজাপুর', 'url' => 'rajapur.jhalakathi.gov.bd'],
            ['upazila_id' => '234', 'name' => 'Bauphal', 'bn_name' => 'বাউফল', 'url' => 'bauphal.patuakhali.gov.bd'],
            ['upazila_id' => '235', 'name' => 'Patuakhali Sadar', 'bn_name' => 'পটুয়াখালী সদর', 'url' => 'sadar.patuakhali.gov.bd'],
            ['upazila_id' => '236', 'name' => 'Dumki', 'bn_name' => 'দুমকি', 'url' => 'dumki.patuakhali.gov.bd'],
            ['upazila_id' => '237', 'name' => 'Dashmina', 'bn_name' => 'দশমিনা', 'url' => 'dashmina.patuakhali.gov.bd'],
            ['upazila_id' => '238', 'name' => 'Kalapara', 'bn_name' => 'কলাপাড়া', 'url' => 'kalapara.patuakhali.gov.bd'],
            ['upazila_id' => '239', 'name' => 'Mirzaganj', 'bn_name' => 'মির্জাগঞ্জ', 'url' => 'mirzaganj.patuakhali.gov.bd'],
            ['upazila_id' => '240', 'name' => 'Galachipa', 'bn_name' => 'গলাচিপা', 'url' => 'galachipa.patuakhali.gov.bd'],
            ['upazila_id' => '241', 'name' => 'Rangabali', 'bn_name' => 'রাঙ্গাবালী', 'url' => 'rangabali.patuakhali.gov.bd'],
            ['upazila_id' => '242', 'name' => 'Pirojpur Sadar', 'bn_name' => 'পিরোজপুর সদর', 'url' => 'sadar.pirojpur.gov.bd'],
            ['upazila_id' => '243', 'name' => 'Nazirpur', 'bn_name' => 'নাজিরপুর', 'url' => 'nazirpur.pirojpur.gov.bd'],

            ['upazila_id' => '245', 'name' => 'Zianagar', 'bn_name' => 'জিয়ানগর', 'url' => 'zianagar.pirojpur.gov.bd'],
            ['upazila_id' => '246', 'name' => 'Bhandaria', 'bn_name' => 'ভান্ডারিয়া', 'url' => 'bhandaria.pirojpur.gov.bd'],
            ['upazila_id' => '247', 'name' => 'Mathbaria', 'bn_name' => 'মঠবাড়ীয়া', 'url' => 'mathbaria.pirojpur.gov.bd'],
            ['upazila_id' => '248', 'name' => 'Nesarabad', 'bn_name' => 'নেছারাবাদ', 'url' => 'nesarabad.pirojpur.gov.bd'],
            ['upazila_id' => '249', 'name' => 'Barisal Sadar', 'bn_name' => 'বরিশাল সদর', 'url' => 'barisalsadar.barisal.gov.bd'],
            ['upazila_id' => '250', 'name' => 'Bakerganj', 'bn_name' => 'বাকেরগঞ্জ', 'url' => 'bakerganj.barisal.gov.bd'],
            ['upazila_id' => '251', 'name' => 'Babuganj', 'bn_name' => 'বাবুগঞ্জ', 'url' => 'babuganj.barisal.gov.bd'],
            ['upazila_id' => '252', 'name' => 'Wazirpur', 'bn_name' => 'উজিরপুর', 'url' => 'wazirpur.barisal.gov.bd'],
            ['upazila_id' => '253', 'name' => 'Banaripara', 'bn_name' => 'বানারীপাড়া', 'url' => 'banaripara.barisal.gov.bd'],
            ['upazila_id' => '254', 'name' => 'Gournadi', 'bn_name' => 'গৌরনদী', 'url' => 'gournadi.barisal.gov.bd'],
            ['upazila_id' => '255', 'name' => 'Agailjhara', 'bn_name' => 'আগৈলঝাড়া', 'url' => 'agailjhara.barisal.gov.bd'],
            ['upazila_id' => '256', 'name' => 'Mehendiganj', 'bn_name' => 'মেহেন্দিগঞ্জ', 'url' => 'mehendiganj.barisal.gov.bd'],
            ['upazila_id' => '257', 'name' => 'Muladi', 'bn_name' => 'মুলাদী', 'url' => 'muladi.barisal.gov.bd'],
            ['upazila_id' => '258', 'name' => 'Hizla', 'bn_name' => 'হিজলা', 'url' => 'hizla.barisal.gov.bd'],
            ['upazila_id' => '259', 'name' => 'Bhola Sadar', 'bn_name' => 'ভোলা সদর', 'url' => 'sadar.bhola.gov.bd'],
            ['upazila_id' => '260', 'name' => 'Borhan Sddin', 'bn_name' => 'বোরহান উদ্দিন', 'url' => 'borhanuddin.bhola.gov.bd'],
            ['upazila_id' => '261', 'name' => 'Charfesson', 'bn_name' => 'চরফ্যাশন', 'url' => 'charfesson.bhola.gov.bd'],
            ['upazila_id' => '262', 'name' => 'Doulatkhan', 'bn_name' => 'দৌলতখান', 'url' => 'doulatkhan.bhola.gov.bd'],
            ['upazila_id' => '263', 'name' => 'Monpura', 'bn_name' => 'মনপুরা', 'url' => 'monpura.bhola.gov.bd'],
            ['upazila_id' => '264', 'name' => 'Tazumuddin', 'bn_name' => 'তজুমদ্দিন', 'url' => 'tazumuddin.bhola.gov.bd'],
            ['upazila_id' => '265', 'name' => 'Lalmohan', 'bn_name' => 'লালমোহন', 'url' => 'lalmohan.bhola.gov.bd'],
            ['upazila_id' => '266', 'name' => 'Amtali', 'bn_name' => 'আমতলী', 'url' => 'amtali.barguna.gov.bd'],
            ['upazila_id' => '267', 'name' => 'Barguna Sadar', 'bn_name' => 'বরগুনা সদর', 'url' => 'sadar.barguna.gov.bd'],
            ['upazila_id' => '268', 'name' => 'Betagi', 'bn_name' => 'বেতাগী', 'url' => 'betagi.barguna.gov.bd'],
            ['upazila_id' => '269', 'name' => 'Bamna', 'bn_name' => 'বামনা', 'url' => 'bamna.barguna.gov.bd'],
            ['upazila_id' => '270', 'name' => 'Pathorghata', 'bn_name' => 'পাথরঘাটা', 'url' => 'pathorghata.barguna.gov.bd'],
            ['upazila_id' => '271', 'name' => 'Taltali', 'bn_name' => 'তালতলি', 'url' => 'taltali.barguna.gov.bd'],
            ['upazila_id' => '272', 'name' => 'Balaganj', 'bn_name' => 'বালাগঞ্জ', 'url' => 'balaganj.sylhet.gov.bd'],
            ['upazila_id' => '273', 'name' => 'Beanibazar', 'bn_name' => 'বিয়ানীবাজার', 'url' => 'beanibazar.sylhet.gov.bd'],
            ['upazila_id' => '274', 'name' => 'Bishwanath', 'bn_name' => 'বিশ্বনাথ', 'url' => 'bishwanath.sylhet.gov.bd'],

            ['upazila_id' => '276', 'name' => 'Fenchuganj', 'bn_name' => 'ফেঞ্চুগঞ্জ', 'url' => 'fenchuganj.sylhet.gov.bd'],
            ['upazila_id' => '277', 'name' => 'Golapganj', 'bn_name' => 'গোলাপগঞ্জ', 'url' => 'golapganj.sylhet.gov.bd'],
            ['upazila_id' => '278', 'name' => 'Gowainghat', 'bn_name' => 'গোয়াইনঘাট', 'url' => 'gowainghat.sylhet.gov.bd'],
            ['upazila_id' => '279', 'name' => 'Jaintiapur', 'bn_name' => 'জৈন্তাপুর', 'url' => 'jaintiapur.sylhet.gov.bd'],
            ['upazila_id' => '280', 'name' => 'Kanaighat', 'bn_name' => 'কানাইঘাট', 'url' => 'kanaighat.sylhet.gov.bd'],
            ['upazila_id' => '281', 'name' => 'Sylhet Sadar', 'bn_name' => 'সিলেট সদর', 'url' => 'sylhetsadar.sylhet.gov.bd'],
            ['upazila_id' => '282', 'name' => 'Zakiganj', 'bn_name' => 'জকিগঞ্জ', 'url' => 'zakiganj.sylhet.gov.bd'],
            ['upazila_id' => '283', 'name' => 'Dakshinsurma', 'bn_name' => 'দক্ষিণ সুরমা', 'url' => 'dakshinsurma.sylhet.gov.bd'],
            ['upazila_id' => '284', 'name' => 'Osmaninagar', 'bn_name' => 'ওসমানী নগর', 'url' => 'osmaninagar.sylhet.gov.bd'],
            ['upazila_id' => '285', 'name' => 'Barlekha', 'bn_name' => 'বড়লেখা', 'url' => 'barlekha.moulvibazar.gov.bd'],
            ['upazila_id' => '286', 'name' => 'Kamolganj', 'bn_name' => 'কমলগঞ্জ', 'url' => 'kamolganj.moulvibazar.gov.bd'],
            ['upazila_id' => '287', 'name' => 'Kulaura', 'bn_name' => 'কুলাউড়া', 'url' => 'kulaura.moulvibazar.gov.bd'],
            ['upazila_id' => '288', 'name' => 'Moulvibazar Sadar', 'bn_name' => 'মৌলভীবাজার সদর', 'url' => 'moulvibazarsadar.moulvibazar.gov.bd'],
            ['upazila_id' => '289', 'name' => 'Rajnagar', 'bn_name' => 'রাজনগর', 'url' => 'rajnagar.moulvibazar.gov.bd'],
            ['upazila_id' => '290', 'name' => 'Sreemangal', 'bn_name' => 'শ্রীমঙ্গল', 'url' => 'sreemangal.moulvibazar.gov.bd'],
            ['upazila_id' => '291', 'name' => 'Juri', 'bn_name' => 'জুড়ী', 'url' => 'juri.moulvibazar.gov.bd'],
            ['upazila_id' => '292', 'name' => 'Nabiganj', 'bn_name' => 'নবীগঞ্জ', 'url' => 'nabiganj.habiganj.gov.bd'],
            ['upazila_id' => '293', 'name' => 'Bahubal', 'bn_name' => 'বাহুবল', 'url' => 'bahubal.habiganj.gov.bd'],
            ['upazila_id' => '294', 'name' => 'Ajmiriganj', 'bn_name' => 'আজমিরীগঞ্জ', 'url' => 'ajmiriganj.habiganj.gov.bd'],
            ['upazila_id' => '295', 'name' => 'Baniachong', 'bn_name' => 'বানিয়াচং', 'url' => 'baniachong.habiganj.gov.bd'],
            ['upazila_id' => '296', 'name' => 'Lakhai', 'bn_name' => 'লাখাই', 'url' => 'lakhai.habiganj.gov.bd'],
            ['upazila_id' => '297', 'name' => 'Chunarughat', 'bn_name' => 'চুনারুঘাট', 'url' => 'chunarughat.habiganj.gov.bd'],
            ['upazila_id' => '298', 'name' => 'Habiganj Sadar', 'bn_name' => 'হবিগঞ্জ সদর', 'url' => 'habiganjsadar.habiganj.gov.bd'],
            ['upazila_id' => '299', 'name' => 'Madhabpur', 'bn_name' => 'মাধবপুর', 'url' => 'madhabpur.habiganj.gov.bd'],
            ['upazila_id' => '300', 'name' => 'Sunamganj Sadar', 'bn_name' => 'সুনামগঞ্জ সদর', 'url' => 'sadar.sunamganj.gov.bd'],
            ['upazila_id' => '301', 'name' => 'South Sunamganj', 'bn_name' => 'দক্ষিণ সুনামগঞ্জ', 'url' => 'southsunamganj.sunamganj.gov.bd'],
            ['upazila_id' => '302', 'name' => 'Bishwambarpur', 'bn_name' => 'বিশ্বম্ভরপুর', 'url' => 'bishwambarpur.sunamganj.gov.bd'],
            ['upazila_id' => '303', 'name' => 'Chhatak', 'bn_name' => 'ছাতক', 'url' => 'chhatak.sunamganj.gov.bd'],
            ['upazila_id' => '304', 'name' => 'Jagannathpur', 'bn_name' => 'জগন্নাথপুর', 'url' => 'jagannathpur.sunamganj.gov.bd'],
            ['upazila_id' => '305', 'name' => 'Dowarabazar', 'bn_name' => 'দোয়ারাবাজার', 'url' => 'dowarabazar.sunamganj.gov.bd'],
            ['upazila_id' => '306', 'name' => 'Tahirpur', 'bn_name' => 'তাহিরপুর', 'url' => 'tahirpur.sunamganj.gov.bd'],
            ['upazila_id' => '307', 'name' => 'Dharmapasha', 'bn_name' => 'ধর্মপাশা', 'url' => 'dharmapasha.sunamganj.gov.bd'],
            ['upazila_id' => '308', 'name' => 'Jamalganj', 'bn_name' => 'জামালগঞ্জ', 'url' => 'jamalganj.sunamganj.gov.bd'],
            ['upazila_id' => '309', 'name' => 'Shalla', 'bn_name' => 'শাল্লা', 'url' => 'shalla.sunamganj.gov.bd'],
            ['upazila_id' => '310', 'name' => 'Derai', 'bn_name' => 'দিরাই', 'url' => 'derai.sunamganj.gov.bd'],
            ['upazila_id' => '311', 'name' => 'Belabo', 'bn_name' => 'বেলাবো', 'url' => 'belabo.narsingdi.gov.bd'],
            ['upazila_id' => '312', 'name' => 'Monohardi', 'bn_name' => 'মনোহরদী', 'url' => 'monohardi.narsingdi.gov.bd'],
            ['upazila_id' => '313', 'name' => 'Narsingdi Sadar', 'bn_name' => 'নরসিংদী সদর', 'url' => 'narsingdisadar.narsingdi.gov.bd'],
            ['upazila_id' => '314', 'name' => 'Palash', 'bn_name' => 'পলাশ', 'url' => 'palash.narsingdi.gov.bd'],
            ['upazila_id' => '315', 'name' => 'Raipura', 'bn_name' => 'রায়পুরা', 'url' => 'raipura.narsingdi.gov.bd'],
            ['upazila_id' => '316', 'name' => 'Shibpur', 'bn_name' => 'শিবপুর', 'url' => 'shibpur.narsingdi.gov.bd'],

            ['upazila_id' => '318', 'name' => 'Kaliakair', 'bn_name' => 'কালিয়াকৈর', 'url' => 'kaliakair.gazipur.gov.bd'],
            ['upazila_id' => '319', 'name' => 'Kapasia', 'bn_name' => 'কাপাসিয়া', 'url' => 'kapasia.gazipur.gov.bd'],
            ['upazila_id' => '320', 'name' => 'Gazipur Sadar', 'bn_name' => 'গাজীপুর সদর', 'url' => 'sadar.gazipur.gov.bd'],

            ['upazila_id' => '322', 'name' => 'Shariatpur Sadar', 'bn_name' => 'শরিয়তপুর সদর', 'url' => 'sadar.shariatpur.gov.bd'],
            ['upazila_id' => '323', 'name' => 'Naria', 'bn_name' => 'নড়িয়া', 'url' => 'naria.shariatpur.gov.bd'],
            ['upazila_id' => '324', 'name' => 'Zajira', 'bn_name' => 'জাজিরা', 'url' => 'zajira.shariatpur.gov.bd'],
            ['upazila_id' => '325', 'name' => 'Gosairhat', 'bn_name' => 'গোসাইরহাট', 'url' => 'gosairhat.shariatpur.gov.bd'],
            ['upazila_id' => '326', 'name' => 'Bhedarganj', 'bn_name' => 'ভেদরগঞ্জ', 'url' => 'bhedarganj.shariatpur.gov.bd'],
            ['upazila_id' => '327', 'name' => 'Damudya', 'bn_name' => 'ডামুড্যা', 'url' => 'damudya.shariatpur.gov.bd'],
            ['upazila_id' => '328', 'name' => 'Araihazar', 'bn_name' => 'আড়াইহাজার', 'url' => 'araihazar.narayanganj.gov.bd'],
            ['upazila_id' => '329', 'name' => 'Bandar', 'bn_name' => 'বন্দর', 'url' => 'bandar.narayanganj.gov.bd'],
            ['upazila_id' => '330', 'name' => 'Narayanganj Sadar', 'bn_name' => 'নারায়নগঞ্জ সদর', 'url' => 'narayanganjsadar.narayanganj.gov.bd'],
            ['upazila_id' => '331', 'name' => 'Rupganj', 'bn_name' => 'রূপগঞ্জ', 'url' => 'rupganj.narayanganj.gov.bd'],
            ['upazila_id' => '332', 'name' => 'Sonargaon', 'bn_name' => 'সোনারগাঁ', 'url' => 'sonargaon.narayanganj.gov.bd'],
            ['upazila_id' => '333', 'name' => 'Basail', 'bn_name' => 'বাসাইল', 'url' => 'basail.tangail.gov.bd'],
            ['upazila_id' => '334', 'name' => 'Bhuapur', 'bn_name' => 'ভুয়াপুর', 'url' => 'bhuapur.tangail.gov.bd'],
            ['upazila_id' => '335', 'name' => 'Delduar', 'bn_name' => 'দেলদুয়ার', 'url' => 'delduar.tangail.gov.bd'],
            ['upazila_id' => '336', 'name' => 'Ghatail', 'bn_name' => 'ঘাটাইল', 'url' => 'ghatail.tangail.gov.bd'],
            ['upazila_id' => '337', 'name' => 'Gopalpur', 'bn_name' => 'গোপালপুর', 'url' => 'gopalpur.tangail.gov.bd'],
            ['upazila_id' => '338', 'name' => 'Madhupur', 'bn_name' => 'মধুপুর', 'url' => 'madhupur.tangail.gov.bd'],
            ['upazila_id' => '339', 'name' => 'Mirzapur', 'bn_name' => 'মির্জাপুর', 'url' => 'mirzapur.tangail.gov.bd'],
            ['upazila_id' => '340', 'name' => 'Nagarpur', 'bn_name' => 'নাগরপুর', 'url' => 'nagarpur.tangail.gov.bd'],
            ['upazila_id' => '341', 'name' => 'Sakhipur', 'bn_name' => 'সখিপুর', 'url' => 'sakhipur.tangail.gov.bd'],
            ['upazila_id' => '342', 'name' => 'Tangail Sadar', 'bn_name' => 'টাঙ্গাইল সদর', 'url' => 'tangailsadar.tangail.gov.bd'],
            ['upazila_id' => '343', 'name' => 'Kalihati', 'bn_name' => 'কালিহাতী', 'url' => 'kalihati.tangail.gov.bd'],
            ['upazila_id' => '344', 'name' => 'Dhanbari', 'bn_name' => 'ধনবাড়ী', 'url' => 'dhanbari.tangail.gov.bd'],
            ['upazila_id' => '345', 'name' => 'Itna', 'bn_name' => 'ইটনা', 'url' => 'itna.kishoreganj.gov.bd'],
            ['upazila_id' => '346', 'name' => 'Katiadi', 'bn_name' => 'কটিয়াদী', 'url' => 'katiadi.kishoreganj.gov.bd'],
            ['upazila_id' => '347', 'name' => 'Bhairab', 'bn_name' => 'ভৈরব', 'url' => 'bhairab.kishoreganj.gov.bd'],
            ['upazila_id' => '348', 'name' => 'Tarail', 'bn_name' => 'তাড়াইল', 'url' => 'tarail.kishoreganj.gov.bd'],
            ['upazila_id' => '349', 'name' => 'Hossainpur', 'bn_name' => 'হোসেনপুর', 'url' => 'hossainpur.kishoreganj.gov.bd'],
            ['upazila_id' => '350', 'name' => 'Pakundia', 'bn_name' => 'পাকুন্দিয়া', 'url' => 'pakundia.kishoreganj.gov.bd'],
            ['upazila_id' => '351', 'name' => 'Kuliarchar', 'bn_name' => 'কুলিয়ারচর', 'url' => 'kuliarchar.kishoreganj.gov.bd'],
            ['upazila_id' => '352', 'name' => 'Kishoreganj Sadar', 'bn_name' => 'কিশোরগঞ্জ সদর', 'url' => 'kishoreganjsadar.kishoreganj.gov.bd'],
            ['upazila_id' => '353', 'name' => 'Karimgonj', 'bn_name' => 'করিমগঞ্জ', 'url' => 'karimgonj.kishoreganj.gov.bd'],
            ['upazila_id' => '354', 'name' => 'Bajitpur', 'bn_name' => 'বাজিতপুর', 'url' => 'bajitpur.kishoreganj.gov.bd'],
            ['upazila_id' => '355', 'name' => 'Austagram', 'bn_name' => 'অষ্টগ্রাম', 'url' => 'austagram.kishoreganj.gov.bd'],
            ['upazila_id' => '356', 'name' => 'Mithamoin', 'bn_name' => 'মিঠামইন', 'url' => 'mithamoin.kishoreganj.gov.bd'],
            ['upazila_id' => '357', 'name' => 'Nikli', 'bn_name' => 'নিকলী', 'url' => 'nikli.kishoreganj.gov.bd'],
            ['upazila_id' => '358', 'name' => 'Harirampur', 'bn_name' => 'হরিরামপুর', 'url' => 'harirampur.manikganj.gov.bd'],
            ['upazila_id' => '359', 'name' => 'Saturia', 'bn_name' => 'সাটুরিয়া', 'url' => 'saturia.manikganj.gov.bd'],
            ['upazila_id' => '360', 'name' => 'Manikganj Sadar', 'bn_name' => 'মানিকগঞ্জ সদর', 'url' => 'sadar.manikganj.gov.bd'],
            ['upazila_id' => '361', 'name' => 'Gior', 'bn_name' => 'ঘিওর', 'url' => 'gior.manikganj.gov.bd'],
            ['upazila_id' => '362', 'name' => 'Shibaloy', 'bn_name' => 'শিবালয়', 'url' => 'shibaloy.manikganj.gov.bd'],
            ['upazila_id' => '363', 'name' => 'Doulatpur', 'bn_name' => 'দৌলতপুর', 'url' => 'doulatpur.manikganj.gov.bd'],
            ['upazila_id' => '364', 'name' => 'Singiar', 'bn_name' => 'সিংগাইর', 'url' => 'singiar.manikganj.gov.bd'],
            ['upazila_id' => '365', 'name' => 'Savar', 'bn_name' => 'সাভার', 'url' => 'savar.dhaka.gov.bd'],
            ['upazila_id' => '366', 'name' => 'Dhamrai', 'bn_name' => 'ধামরাই', 'url' => 'dhamrai.dhaka.gov.bd'],
            ['upazila_id' => '367', 'name' => 'Keraniganj', 'bn_name' => 'কেরাণীগঞ্জ', 'url' => 'keraniganj.dhaka.gov.bd'],

            ['upazila_id' => '369', 'name' => 'Dohar', 'bn_name' => 'দোহার', 'url' => 'dohar.dhaka.gov.bd'],
            ['upazila_id' => '370', 'name' => 'Munshiganj Sadar', 'bn_name' => 'মুন্সিগঞ্জ সদর', 'url' => 'sadar.munshiganj.gov.bd'],
            ['upazila_id' => '371', 'name' => 'Sreenagar', 'bn_name' => 'শ্রীনগর', 'url' => 'sreenagar.munshiganj.gov.bd'],
            ['upazila_id' => '372', 'name' => 'Sirajdikhan', 'bn_name' => 'সিরাজদিখান', 'url' => 'sirajdikhan.munshiganj.gov.bd'],
            ['upazila_id' => '373', 'name' => 'Louhajanj', 'bn_name' => 'লৌহজং', 'url' => 'louhajanj.munshiganj.gov.bd'],
            ['upazila_id' => '374', 'name' => 'Gajaria', 'bn_name' => 'গজারিয়া', 'url' => 'gajaria.munshiganj.gov.bd'],
            ['upazila_id' => '375', 'name' => 'Tongibari', 'bn_name' => 'টংগীবাড়ি', 'url' => 'tongibari.munshiganj.gov.bd'],
            ['upazila_id' => '376', 'name' => 'Rajbari Sadar', 'bn_name' => 'রাজবাড়ী সদর', 'url' => 'sadar.rajbari.gov.bd'],
            ['upazila_id' => '377', 'name' => 'Goalanda', 'bn_name' => 'গোয়ালন্দ', 'url' => 'goalanda.rajbari.gov.bd'],
            ['upazila_id' => '378', 'name' => 'Pangsa', 'bn_name' => 'পাংশা', 'url' => 'pangsa.rajbari.gov.bd'],
            ['upazila_id' => '379', 'name' => 'Baliakandi', 'bn_name' => 'বালিয়াকান্দি', 'url' => 'baliakandi.rajbari.gov.bd'],
            ['upazila_id' => '380', 'name' => 'Kalukhali', 'bn_name' => 'কালুখালী', 'url' => 'kalukhali.rajbari.gov.bd'],
            ['upazila_id' => '381', 'name' => 'Madaripur Sadar', 'bn_name' => 'মাদারীপুর সদর', 'url' => 'sadar.madaripur.gov.bd'],
            ['upazila_id' => '382', 'name' => 'Shibchar', 'bn_name' => 'শিবচর', 'url' => 'shibchar.madaripur.gov.bd'],
            ['upazila_id' => '383', 'name' => 'Kalkini', 'bn_name' => 'কালকিনি', 'url' => 'kalkini.madaripur.gov.bd'],
            ['upazila_id' => '384', 'name' => 'Rajoir', 'bn_name' => 'রাজৈর', 'url' => 'rajoir.madaripur.gov.bd'],
            ['upazila_id' => '385', 'name' => 'Gopalganj Sadar', 'bn_name' => 'গোপালগঞ্জ সদর', 'url' => 'sadar.gopalganj.gov.bd'],
            ['upazila_id' => '386', 'name' => 'Kashiani', 'bn_name' => 'কাশিয়ানী', 'url' => 'kashiani.gopalganj.gov.bd'],
            ['upazila_id' => '387', 'name' => 'Tungipara', 'bn_name' => 'টুংগীপাড়া', 'url' => 'tungipara.gopalganj.gov.bd'],
            ['upazila_id' => '388', 'name' => 'Kotalipara', 'bn_name' => 'কোটালীপাড়া', 'url' => 'kotalipara.gopalganj.gov.bd'],
            ['upazila_id' => '389', 'name' => 'Muksudpur', 'bn_name' => 'মুকসুদপুর', 'url' => 'muksudpur.gopalganj.gov.bd'],
            ['upazila_id' => '390', 'name' => 'Faridpur Sadar', 'bn_name' => 'ফরিদপুর সদর', 'url' => 'sadar.faridpur.gov.bd'],
            ['upazila_id' => '391', 'name' => 'Alfadanga', 'bn_name' => 'আলফাডাঙ্গা', 'url' => 'alfadanga.faridpur.gov.bd'],
            ['upazila_id' => '392', 'name' => 'Boalmari', 'bn_name' => 'বোয়ালমারী', 'url' => 'boalmari.faridpur.gov.bd'],
            ['upazila_id' => '393', 'name' => 'Sadarpur', 'bn_name' => 'সদরপুর', 'url' => 'sadarpur.faridpur.gov.bd'],
            ['upazila_id' => '394', 'name' => 'Nagarkanda', 'bn_name' => 'নগরকান্দা', 'url' => 'nagarkanda.faridpur.gov.bd'],
            ['upazila_id' => '395', 'name' => 'Bhanga', 'bn_name' => 'ভাঙ্গা', 'url' => 'bhanga.faridpur.gov.bd'],
            ['upazila_id' => '396', 'name' => 'Charbhadrasan', 'bn_name' => 'চরভদ্রাসন', 'url' => 'charbhadrasan.faridpur.gov.bd'],
            ['upazila_id' => '397', 'name' => 'Madhukhali', 'bn_name' => 'মধুখালী', 'url' => 'madhukhali.faridpur.gov.bd'],
            ['upazila_id' => '398', 'name' => 'Saltha', 'bn_name' => 'সালথা', 'url' => 'saltha.faridpur.gov.bd'],
            ['upazila_id' => '399', 'name' => 'Panchagarh Sadar', 'bn_name' => 'পঞ্চগড় সদর', 'url' => 'panchagarhsadar.panchagarh.gov.bd'],
            ['upazila_id' => '400', 'name' => 'Debiganj', 'bn_name' => 'দেবীগঞ্জ', 'url' => 'debiganj.panchagarh.gov.bd'],
            ['upazila_id' => '401', 'name' => 'Boda', 'bn_name' => 'বোদা', 'url' => 'boda.panchagarh.gov.bd'],
            ['upazila_id' => '402', 'name' => 'Atwari', 'bn_name' => 'আটোয়ারী', 'url' => 'atwari.panchagarh.gov.bd'],
            ['upazila_id' => '403', 'name' => 'Tetulia', 'bn_name' => 'তেতুলিয়া', 'url' => 'tetulia.panchagarh.gov.bd'],
            ['upazila_id' => '404', 'name' => 'Nawabganj', 'bn_name' => 'নবাবগঞ্জ', 'url' => 'nawabganj.dinajpur.gov.bd'],
            ['upazila_id' => '405', 'name' => 'Birganj', 'bn_name' => 'বীরগঞ্জ', 'url' => 'birganj.dinajpur.gov.bd'],
            ['upazila_id' => '406', 'name' => 'Ghoraghat', 'bn_name' => 'ঘোড়াঘাট', 'url' => 'ghoraghat.dinajpur.gov.bd'],
            ['upazila_id' => '407', 'name' => 'Birampur', 'bn_name' => 'বিরামপুর', 'url' => 'birampur.dinajpur.gov.bd'],
            ['upazila_id' => '408', 'name' => 'Parbatipur', 'bn_name' => 'পার্বতীপুর', 'url' => 'parbatipur.dinajpur.gov.bd'],
            ['upazila_id' => '409', 'name' => 'Bochaganj', 'bn_name' => 'বোচাগঞ্জ', 'url' => 'bochaganj.dinajpur.gov.bd'],
            ['upazila_id' => '410', 'name' => 'Kaharol', 'bn_name' => 'কাহারোল', 'url' => 'kaharol.dinajpur.gov.bd'],
            ['upazila_id' => '411', 'name' => 'Fulbari', 'bn_name' => 'ফুলবাড়ী', 'url' => 'fulbari.dinajpur.gov.bd'],
            ['upazila_id' => '412', 'name' => 'Dinajpur Sadar', 'bn_name' => 'দিনাজপুর সদর', 'url' => 'dinajpursadar.dinajpur.gov.bd'],
            ['upazila_id' => '413', 'name' => 'Hakimpur', 'bn_name' => 'হাকিমপুর', 'url' => 'hakimpur.dinajpur.gov.bd'],
            ['upazila_id' => '414', 'name' => 'Khansama', 'bn_name' => 'খানসামা', 'url' => 'khansama.dinajpur.gov.bd'],
            ['upazila_id' => '415', 'name' => 'Birol', 'bn_name' => 'বিরল', 'url' => 'birol.dinajpur.gov.bd'],
            ['upazila_id' => '416', 'name' => 'Chirirbandar', 'bn_name' => 'চিরিরবন্দর', 'url' => 'chirirbandar.dinajpur.gov.bd'],
            ['upazila_id' => '417', 'name' => 'Lalmonirhat Sadar', 'bn_name' => 'লালমনিরহাট সদর', 'url' => 'sadar.lalmonirhat.gov.bd'],

            ['upazila_id' => '419', 'name' => 'Hatibandha', 'bn_name' => 'হাতীবান্ধা', 'url' => 'hatibandha.lalmonirhat.gov.bd'],
            ['upazila_id' => '420', 'name' => 'Patgram', 'bn_name' => 'পাটগ্রাম', 'url' => 'patgram.lalmonirhat.gov.bd'],
            ['upazila_id' => '421', 'name' => 'Aditmari', 'bn_name' => 'আদিতমারী', 'url' => 'aditmari.lalmonirhat.gov.bd'],
            ['upazila_id' => '422', 'name' => 'Syedpur', 'bn_name' => 'সৈয়দপুর', 'url' => 'syedpur.nilphamari.gov.bd'],
            ['upazila_id' => '423', 'name' => 'Domar', 'bn_name' => 'ডোমার', 'url' => 'domar.nilphamari.gov.bd'],
            ['upazila_id' => '424', 'name' => 'Dimla', 'bn_name' => 'ডিমলা', 'url' => 'dimla.nilphamari.gov.bd'],
            ['upazila_id' => '425', 'name' => 'Jaldhaka', 'bn_name' => 'জলঢাকা', 'url' => 'jaldhaka.nilphamari.gov.bd'],
            ['upazila_id' => '426', 'name' => 'Kishorganj', 'bn_name' => 'কিশোরগঞ্জ', 'url' => 'kishorganj.nilphamari.gov.bd'],
            ['upazila_id' => '427', 'name' => 'Nilphamari Sadar', 'bn_name' => 'নীলফামারী সদর', 'url' => 'nilphamarisadar.nilphamari.gov.bd'],
            ['upazila_id' => '428', 'name' => 'Sadullapur', 'bn_name' => 'সাদুল্লাপুর', 'url' => 'sadullapur.gaibandha.gov.bd'],
            ['upazila_id' => '429', 'name' => 'Gaibandha Sadar', 'bn_name' => 'গাইবান্ধা সদর', 'url' => 'gaibandhasadar.gaibandha.gov.bd'],
            ['upazila_id' => '430', 'name' => 'Palashbari', 'bn_name' => 'পলাশবাড়ী', 'url' => 'palashbari.gaibandha.gov.bd'],
            ['upazila_id' => '431', 'name' => 'Saghata', 'bn_name' => 'সাঘাটা', 'url' => 'saghata.gaibandha.gov.bd'],
            ['upazila_id' => '432', 'name' => 'Gobindaganj', 'bn_name' => 'গোবিন্দগঞ্জ', 'url' => 'gobindaganj.gaibandha.gov.bd'],
            ['upazila_id' => '433', 'name' => 'Sundarganj', 'bn_name' => 'সুন্দরগঞ্জ', 'url' => 'sundarganj.gaibandha.gov.bd'],
            ['upazila_id' => '434', 'name' => 'Phulchari', 'bn_name' => 'ফুলছড়ি', 'url' => 'phulchari.gaibandha.gov.bd'],
            ['upazila_id' => '435', 'name' => 'Thakurgaon Sadar', 'bn_name' => 'ঠাকুরগাঁও সদর', 'url' => 'thakurgaonsadar.thakurgaon.gov.bd'],
            ['upazila_id' => '436', 'name' => 'Pirganj', 'bn_name' => 'পীরগঞ্জ', 'url' => 'pirganj.thakurgaon.gov.bd'],
            ['upazila_id' => '437', 'name' => 'Ranisankail', 'bn_name' => 'রাণীশংকৈল', 'url' => 'ranisankail.thakurgaon.gov.bd'],
            ['upazila_id' => '438', 'name' => 'Haripur', 'bn_name' => 'হরিপুর', 'url' => 'haripur.thakurgaon.gov.bd'],
            ['upazila_id' => '439', 'name' => 'Baliadangi', 'bn_name' => 'বালিয়াডাঙ্গী', 'url' => 'baliadangi.thakurgaon.gov.bd'],
            ['upazila_id' => '440', 'name' => 'Rangpur Sadar', 'bn_name' => 'রংপুর সদর', 'url' => 'rangpursadar.rangpur.gov.bd'],
            ['upazila_id' => '441', 'name' => 'Gangachara', 'bn_name' => 'গংগাচড়া', 'url' => 'gangachara.rangpur.gov.bd'],
            ['upazila_id' => '442', 'name' => 'Taragonj', 'bn_name' => 'তারাগঞ্জ', 'url' => 'taragonj.rangpur.gov.bd'],
            ['upazila_id' => '443', 'name' => 'Badargonj', 'bn_name' => 'বদরগঞ্জ', 'url' => 'badargonj.rangpur.gov.bd'],
            ['upazila_id' => '444', 'name' => 'Mithapukur', 'bn_name' => 'মিঠাপুকুর', 'url' => 'mithapukur.rangpur.gov.bd'],
            ['upazila_id' => '445', 'name' => 'Pirgonj', 'bn_name' => 'পীরগঞ্জ', 'url' => 'pirgonj.rangpur.gov.bd'],
            ['upazila_id' => '446', 'name' => 'Kaunia', 'bn_name' => 'কাউনিয়া', 'url' => 'kaunia.rangpur.gov.bd'],
            ['upazila_id' => '447', 'name' => 'Pirgacha', 'bn_name' => 'পীরগাছা', 'url' => 'pirgacha.rangpur.gov.bd'],
            ['upazila_id' => '448', 'name' => 'Kurigram Sadar', 'bn_name' => 'কুড়িগ্রাম সদর', 'url' => 'kurigramsadar.kurigram.gov.bd'],
            ['upazila_id' => '449', 'name' => 'Nageshwari', 'bn_name' => 'নাগেশ্বরী', 'url' => 'nageshwari.kurigram.gov.bd'],
            ['upazila_id' => '450', 'name' => 'Bhurungamari', 'bn_name' => 'ভুরুঙ্গামারী', 'url' => 'bhurungamari.kurigram.gov.bd'],
            ['upazila_id' => '451', 'name' => 'Phulbari', 'bn_name' => 'ফুলবাড়ী', 'url' => 'phulbari.kurigram.gov.bd'],
            ['upazila_id' => '452', 'name' => 'Rajarhat', 'bn_name' => 'রাজারহাট', 'url' => 'rajarhat.kurigram.gov.bd'],
            ['upazila_id' => '453', 'name' => 'Ulipur', 'bn_name' => 'উলিপুর', 'url' => 'ulipur.kurigram.gov.bd'],
            ['upazila_id' => '454', 'name' => 'Chilmari', 'bn_name' => 'চিলমারী', 'url' => 'chilmari.kurigram.gov.bd'],
            ['upazila_id' => '455', 'name' => 'Rowmari', 'bn_name' => 'রৌমারী', 'url' => 'rowmari.kurigram.gov.bd'],
            ['upazila_id' => '456', 'name' => 'Charrajibpur', 'bn_name' => 'চর রাজিবপুর', 'url' => 'charrajibpur.kurigram.gov.bd'],
            ['upazila_id' => '457', 'name' => 'Sherpur Sadar', 'bn_name' => 'শেরপুর সদর', 'url' => 'sherpursadar.sherpur.gov.bd'],
            ['upazila_id' => '458', 'name' => 'Nalitabari', 'bn_name' => 'নালিতাবাড়ী', 'url' => 'nalitabari.sherpur.gov.bd'],
            ['upazila_id' => '459', 'name' => 'Sreebordi', 'bn_name' => 'শ্রীবরদী', 'url' => 'sreebordi.sherpur.gov.bd'],
            ['upazila_id' => '460', 'name' => 'Nokla', 'bn_name' => 'নকলা', 'url' => 'nokla.sherpur.gov.bd'],
            ['upazila_id' => '461', 'name' => 'Jhenaigati', 'bn_name' => 'ঝিনাইগাতী', 'url' => 'jhenaigati.sherpur.gov.bd'],
            ['upazila_id' => '462', 'name' => 'Fulbaria', 'bn_name' => 'ফুলবাড়ীয়া', 'url' => 'fulbaria.mymensingh.gov.bd'],
            ['upazila_id' => '463', 'name' => 'Trishal', 'bn_name' => 'ত্রিশাল', 'url' => 'trishal.mymensingh.gov.bd'],
            ['upazila_id' => '464', 'name' => 'Bhaluka', 'bn_name' => 'ভালুকা', 'url' => 'bhaluka.mymensingh.gov.bd'],
            ['upazila_id' => '465', 'name' => 'Muktagacha', 'bn_name' => 'মুক্তাগাছা', 'url' => 'muktagacha.mymensingh.gov.bd'],
            ['upazila_id' => '466', 'name' => 'Mymensingh Sadar', 'bn_name' => 'ময়মনসিংহ সদর', 'url' => 'mymensinghsadar.mymensingh.gov.bd'],
            ['upazila_id' => '467', 'name' => 'Dhobaura', 'bn_name' => 'ধোবাউড়া', 'url' => 'dhobaura.mymensingh.gov.bd'],
            ['upazila_id' => '468', 'name' => 'Phulpur', 'bn_name' => 'ফুলপুর', 'url' => 'phulpur.mymensingh.gov.bd'],
            ['upazila_id' => '469', 'name' => 'Haluaghat', 'bn_name' => 'হালুয়াঘাট', 'url' => 'haluaghat.mymensingh.gov.bd'],
            ['upazila_id' => '470', 'name' => 'Gouripur', 'bn_name' => 'গৌরীপুর', 'url' => 'gouripur.mymensingh.gov.bd'],
            ['upazila_id' => '471', 'name' => 'Gafargaon', 'bn_name' => 'গফরগাঁও', 'url' => 'gafargaon.mymensingh.gov.bd'],
            ['upazila_id' => '472', 'name' => 'Iswarganj', 'bn_name' => 'ঈশ্বরগঞ্জ', 'url' => 'iswarganj.mymensingh.gov.bd'],
            ['upazila_id' => '473', 'name' => 'Nandail', 'bn_name' => 'নান্দাইল', 'url' => 'nandail.mymensingh.gov.bd'],
            ['upazila_id' => '474', 'name' => 'Tarakanda', 'bn_name' => 'তারাকান্দা', 'url' => 'tarakanda.mymensingh.gov.bd'],
            ['upazila_id' => '475', 'name' => 'Jamalpur Sadar', 'bn_name' => 'জামালপুর সদর', 'url' => 'jamalpursadar.jamalpur.gov.bd'],
            ['upazila_id' => '476', 'name' => 'Melandah', 'bn_name' => 'মেলান্দহ', 'url' => 'melandah.jamalpur.gov.bd'],
            ['upazila_id' => '477', 'name' => 'Islampur', 'bn_name' => 'ইসলামপুর', 'url' => 'islampur.jamalpur.gov.bd'],
            ['upazila_id' => '478', 'name' => 'Dewangonj', 'bn_name' => 'দেওয়ানগঞ্জ', 'url' => 'dewangonj.jamalpur.gov.bd'],
            ['upazila_id' => '479', 'name' => 'Sarishabari', 'bn_name' => 'সরিষাবাড়ী', 'url' => 'sarishabari.jamalpur.gov.bd'],
            ['upazila_id' => '480', 'name' => 'Madarganj', 'bn_name' => 'মাদারগঞ্জ', 'url' => 'madarganj.jamalpur.gov.bd'],
            ['upazila_id' => '481', 'name' => 'Bokshiganj', 'bn_name' => 'বকশীগঞ্জ', 'url' => 'bokshiganj.jamalpur.gov.bd'],
            ['upazila_id' => '482', 'name' => 'Barhatta', 'bn_name' => 'বারহাট্টা', 'url' => 'barhatta.netrokona.gov.bd'],

            ['upazila_id' => '484', 'name' => 'Kendua', 'bn_name' => 'কেন্দুয়া', 'url' => 'kendua.netrokona.gov.bd'],
            ['upazila_id' => '485', 'name' => 'Atpara', 'bn_name' => 'আটপাড়া', 'url' => 'atpara.netrokona.gov.bd'],
            ['upazila_id' => '486', 'name' => 'Madan', 'bn_name' => 'মদন', 'url' => 'madan.netrokona.gov.bd'],
            ['upazila_id' => '487', 'name' => 'Khaliajuri', 'bn_name' => 'খালিয়াজুরী', 'url' => 'khaliajuri.netrokona.gov.bd'],
            ['upazila_id' => '488', 'name' => 'Kalmakanda', 'bn_name' => 'কলমাকান্দা', 'url' => 'kalmakanda.netrokona.gov.bd'],
            ['upazila_id' => '489', 'name' => 'Mohongonj', 'bn_name' => 'মোহনগঞ্জ', 'url' => 'mohongonj.netrokona.gov.bd'],
            ['upazila_id' => '490', 'name' => 'Purbadhala', 'bn_name' => 'পূর্বধলা', 'url' => 'purbadhala.netrokona.gov.bd'],
            ['upazila_id' => '491', 'name' => 'Netrokona Sadar', 'bn_name' => 'নেত্রকোণা সদর', 'url' => 'netrokonasadar.netrokona.gov.bd'],
            ['upazila_id' => '492', 'name' => 'Adabar Thana', 'bn_name' => 'আদাবর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '493', 'name' => 'Azampur Thana', 'bn_name' => 'আজমপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '494', 'name' => 'Badda Thana', 'bn_name' => 'বাড্ডা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '495', 'name' => 'Bangsal Thana', 'bn_name' => 'বংশাল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '496', 'name' => 'Bimanbandar Thana (Dhaka]', 'bn_name' => 'বিমানবন্দর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '497', 'name' => 'Cantonment Thana', 'bn_name' => 'ক্যান্টনমেন্ট থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '498', 'name' => 'Chowkbazar Thana', 'bn_name' => 'চকবাজার থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '499', 'name' => 'Darus Salam Thana', 'bn_name' => 'দারুস সালাম থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '500', 'name' => 'Demra Thana', 'bn_name' => 'ডেমরা থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '501', 'name' => 'Dhanmondi Thana', 'bn_name' => 'ধানমন্ডি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '502', 'name' => 'Gendaria Thana', 'bn_name' => 'গেন্ডারিয়া থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '503', 'name' => 'Hazaribagh Thana', 'bn_name' => 'হাজারিবাঘ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '504', 'name' => 'Kadamtali Thana', 'bn_name' => 'কদমতলি থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '505', 'name' => 'Kafrul Thana', 'bn_name' => 'কাফরুল থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '506', 'name' => 'Kalabagan Thana', 'bn_name' => 'কলাবাগান থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '507', 'name' => 'Kamrangirchar Thana', 'bn_name' => 'কামরাংগিচর থানা ', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '508', 'name' => 'Khilgaon Thana', 'bn_name' => 'খিলগাঁ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '509', 'name' => 'Khilkhet Thana', 'bn_name' => 'খিলখেত থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '510', 'name' => 'Kotwali Thana (Dhaka]', 'bn_name' => 'কতোয়াখালি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '511', 'name' => 'Lalbagh Thana', 'bn_name' => 'লালবাঘ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '512', 'name' => 'Mirpur Model Thana', 'bn_name' => 'মিরপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '513', 'name' => 'Mohammadpur Thana', 'bn_name' => 'মুহাম্মাদপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '514', 'name' => 'Motijheel Thana', 'bn_name' => 'মতিঝিল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '515', 'name' => 'New Market Thana', 'bn_name' => 'নিউ মার্কেট থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '516', 'name' => 'Pallabi Thana', 'bn_name' => 'পল্লবি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '517', 'name' => 'Paltan Thana', 'bn_name' => 'পল্টন থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '518', 'name' => 'Panthapath Thana', 'bn_name' => 'পান্থপথ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '519', 'name' => 'Ramna Thana', 'bn_name' => 'রমনা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '520', 'name' => 'Rampura Thana', 'bn_name' => 'রামপুরা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '521', 'name' => 'Sabujbagh Thana', 'bn_name' => 'সবুজবাঘ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '522', 'name' => 'Shah Ali Thana', 'bn_name' => 'সাহ্‌ আলী থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '523', 'name' => 'Shahbag Thana', 'bn_name' => 'শাহ্‌বাগ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '524', 'name' => 'Sher-e-Bangla Nagar', 'bn_name' => 'শেরে-ই-বাংলা নগর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '525', 'name' => 'Shyampur Thana', 'bn_name' => 'শ্যামপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '526', 'name' => 'Sutrapur Thana', 'bn_name' => 'সুত্রাপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '527', 'name' => 'Tejgaon Industrial Area Thana', 'bn_name' => 'তেজগাঁও ইন্ডাস্ট্রিয়াল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '528', 'name' => 'Tejgaon Thana', 'bn_name' => 'তেজগাঁও থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '529', 'name' => 'Turag Thana', 'bn_name' => 'তুরাগ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '530', 'name' => 'Uttar Khan Thana', 'bn_name' => 'উত্তর খান থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '531', 'name' => 'Uttara West Thana', 'bn_name' => 'উত্তরা পশ্চিম থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '532', 'name' => 'Vatara Thana', 'bn_name' => 'ভাটারা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '533', 'name' => 'Wari Thana', 'bn_name' => 'ওয়ারি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '534', 'name' => 'Uttara East Thana', 'bn_name' => 'উত্তরা পূর্ব থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '535', 'name' => 'Dakshinkhan Thana', 'bn_name' => 'দক্ষিনখান থানা', 'url' => 'debidwar.comilla.gov.bd'],


            ['upazila_id' => '536', 'name' => 'Akbarshah Thana', 'bn_name' => 'আকবরশাহ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '537', 'name' => 'Bakoliya Thana', 'bn_name' => 'বাকোলিয়া থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '538', 'name' => 'Bandar Thana', 'bn_name' => 'বন্দর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '539', 'name' => 'Bayazid Thana', 'bn_name' => 'বায়জিদ থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '540', 'name' => 'Bhujpur Thana', 'bn_name' => 'ভুজপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '541', 'name' => 'Chandgaon Thana', 'bn_name' => 'চন্দগন থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '542', 'name' => 'Chaowkbazar Thana', 'bn_name' => 'চকবাজার থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '543', 'name' => 'Chittagong Kotwali Thana', 'bn_name' => 'চিটাগাং থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '544', 'name' => 'Double Mooring Thana', 'bn_name' => 'ডাবল মর্নিং থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '545', 'name' => 'EPZ Thana Thana', 'bn_name' => 'ইপিজেড থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '546', 'name' => 'Halishahar Thana', 'bn_name' => 'হালিশাহার থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '547', 'name' => 'Karnaphuli Thana', 'bn_name' => 'কর্ণফুলি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '548', 'name' => 'Khulshi Thana', 'bn_name' => 'খুলসি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '549', 'name' => 'Kotwali Thana (Chittagong]', 'bn_name' => 'কতোয়াখালি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '550', 'name' => 'Pahartali Thana', 'bn_name' => 'পাহারতলি থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '551', 'name' => 'Panchlaish Thana', 'bn_name' => 'পাঞ্চলাইস থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '552', 'name' => 'Patenga Thana', 'bn_name' => 'পতেংগা থানা', 'url' => 'debidwar.comilla.gov.bd'],

            ['upazila_id' => '553', 'name' => 'Gulshan Thana', 'bn_name' => 'গুলশান থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '554', 'name' => 'Banani Thana', 'bn_name' => 'বনানী থানা', 'url' => 'debidwar.comilla.gov.bd'],

            ['upazila_id' => '555', 'name' => 'Sadar Thana', 'bn_name' => 'সদর/জয়দেবপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '556', 'name' => 'Bason Thana', 'bn_name' => 'বাসন থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '557', 'name' => 'Konabari Thana', 'bn_name' => 'কোনাবাড়ী থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '558', 'name' => 'Kashimpur Thana', 'bn_name' => 'কাশিমপুর থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '559', 'name' => 'Gacha Thana', 'bn_name' => 'গাছা থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '560', 'name' => 'Pubail Thana', 'bn_name' => 'পূবাইল থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '561', 'name' => 'Tongi West Thana', 'bn_name' => 'টঙ্গী পশ্চিম থানা', 'url' => 'debidwar.comilla.gov.bd'],
            ['upazila_id' => '562', 'name' => 'Tongi East Thana', 'bn_name' => 'টঙ্গী পূর্ব থানা', 'url' => 'debidwar.comilla.gov.bd'],

            ['upazila_id' => '563', 'name' => 'Labanchara',  'bn_name' => 'লবনচরা',   'url' => null],
            ['upazila_id' => '564', 'name' => 'Horintana',   'bn_name' => 'হরিনটানা',   'url' => null],
            ['upazila_id' => '565', 'name' => 'Khalishpur',  'bn_name' => 'খালিশপুর',   'url' => null],
            ['upazila_id' => '566', 'name' => 'Boyra',       'bn_name' => 'বয়রা',      'url' => null],
            ['upazila_id' => '567', 'name' => 'Sonadanga',   'bn_name' => 'সোনাডাঙা',  'url' => null],
            ['upazila_id' => '568', 'name' => 'Khulna Sadar', 'bn_name' => 'খুলনা সদর', 'url' => null],
            ['upazila_id' => '569', 'name' => 'Khan Jahan Ali', 'bn_name' => 'খানজাহান আলী', 'url' => null],
            ['upazila_id' => '570', 'name' => 'Daulatpur-k', 'bn_name' => 'দৌলতপুর', 'url' => null],
            ['upazila_id' => '571', 'name' => 'Jatrabari Thana', 'bn_name' => 'যাত্রাবাড়ী থানা', 'url' => null],
            ['upazila_id' => '572', 'name' => 'Kaliganj Upazila', 'bn_name' => 'কালীগঞ্জ উপজেলা', 'url' => null],
        ];



        $upazila = Upazila::all();
        foreach ($upazila as $item) {
            foreach ($thanas as $thana) {
                if ($item->name == $thana['name']) {
                    $thana['upazila_id'] = $item->id;
                    if (DB::table('thanas')->where('name', $thana['name'])->count() < 1) {
                        DB::table('thanas')->insert($thana);
                    }
                }
            }
        }

        
    }
}
