@extends('layout.app')
@section('content')

    <div class="mt-2 card">
        <div class="card-body">
            @if (isset($print_url) && !empty($print_url))
                <a href="{{ route($print_url) }}" target="_blank"><i class="fa fa-print"></i></a>
            @endif

            <input type="text" id="customer_search" name="customer_search" class="float-right">

            <br>

            <div id="processing">
                <div>Processing.....</div>
            </div>



            <div id="customer_list_body">
                {{-- Total: {{ $list->total() }} --}}
                <div class="table-responsive" style="height:70vh">
                    <table id="dataTable1" class="table table-head-fixed text-nowrap" style="width:1600px">
                        <thead>
                            <tr>
                                <th scope="col" class="no-wrap">
                                    ID
                                </th>
                                <th scope="col" class="no-wrap">
                                    User name
                                </th>


                                <th scope="col" class="no-wrap">
                                    Status
                                </th>
                                <th scope="col" class="no-wrap">
                                    Expire
                                </th>

                                <th scope="col" class="no-wrap">
                                    Bill Info
                                </th>


                                <th scope="col" class="no-wrap">
                                    Package
                                </th>

                                <th scope="col" class="no-wrap">
                                    POP
                                </th>

                                <th>
                                    Name
                                </th>

                                <th scope="col" style="width:350px">
                                    User Info
                                </th>

                                <th scope="col" class="no-wrap">
                                    Created Date
                                </th>
                                <th scope="col" class="noprin">

                                </th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach ($list as $r)
                                {{-- {{dd($r)}} --}}
                                <tr @if ($r->clients_status == 'deactive') class="deactive" @endif>
                                    <td class="text-center">
                                        <a class="btn btn-info btn-block btn-xs"
                                            href="{{ route('getPaymentHistory', $r->client_id) }}">@php(printf('CID%04d', $r->client_id))</a>

                                        <a href="{{ route('getCustomerLogHistory', $r->userid) }}"
                                            class="noprint btn btn-primary btn-xs btn-block">Log</a>

                                    </td>
                                    <td class="no-wrap">
                                        {{ $r->userid }}
                                        <br>
                                        {{ $r->password }}
                                        <br>
                                        @if (isset($online) && in_array($r->userid, $online))
                                            <span class="btn btn-success btn-xs">Online</span>
                                        @else
                                            <span class="btn btn-danger btn-xs">Ofline</span>
                                        @endif
                                    </td>



                                    @if ($r->clients_status == 'expired')
                                        <td style="background:red" class="deactive">
                                            <x-Custom.Status status="{{ $r->clients_status }}" />
                                        </td>

                                    @elseif($r->clients_status == 'deactive')
                                        <td style="background:red">
                                            <x-Custom.Status status="{{ $r->clients_status }}" />
                                        </td>
                                    @elseif($r->clients_status == 'active')
                                        <td style="background:rgb(0, 119, 255)">
                                            <x-Custom.Status status="{{ $r->clients_status }}" />
                                        </td>
                                    @elseif($r->clients_status == 'disable')
                                        <td style="background:rgb(243, 187, 4)">
                                            <x-Custom.Status status="{{ $r->clients_status }}" />
                                        </td>
                                    @elseif($r->client_approval == 'pending')
                                        <td>
                                            {{ $r->client_approval }}
                                        </td>
                                    @else
                                        <td>
                                            <x-Custom.Status status="{{ $r->clients_status }}" />
                                        </td>
                                    @endif

                                    {{-- @if ($r->client_approval == 'pending')
                            @else
                                <x-Custom.Status status="{{ $r->clients_status }}" />
                            @endif --}}


                                    @if ($r->clients_status == 'expired')
                                        <td style="background:red" class="whitespace-nowrap">
                                            {{ date('d-M-Y', strtotime($r->expire_date)) }}
                                        </td>
                                    @else

                                        <td style="background: #a8f8b9" class="whitespace-nowrap">
                                            {{ date('d-M-Y', strtotime($r->expire_date)) }}
                                        </td>
                                    @endif
                                    <td> 
                                        <p style="font-size:14px;">
                                        B Cycle: {{ $r->billing_cycle }} <br>
                                    B Amount: @role('Sub Reseller') @if ($r->subreseller == 'yes') {{ $r->sub_package_rate }}  @else {{ $r->package_rate }} @endif @else
                                    {{ $r->package_rate }} @endrole <br>
                                    OTC : {{ $r->otc }}</p>
                                </td>


                                <td class="no-wrap">

                                    @role('Sub Reseller')
                                        @if ($r->subreseller == 'yes')
                                            {{ $r->sub_package_name }}

                                        @else
                                            {{ $r->package_name }}
                                        @endif
                                    @else

                                        {{ $r->package_name }}

                                    @endrole

                                </td>

                                <td class="no-wrap">
                                    {{ $r->popname ?? '' }}
                                </td>

                                <td>
                                    <p style="font-size:14px;">
                                    Name: {{ $r->clients_name ?? '' }}, <br>
                                    C No: {{ $r->contact_no ?? '' }}</p>
                                </td>



                                <td style="width:350px;">
                                    <p style="font-size:14px;">
                                        Flat No: {{ $r->flat_no ?? '' }} ,
                                        Building Name: {{ $r->building_name ?? '' }} ,<br>
                                        Road No: {{ $r->road_no ?? '' }} ,<br>
                                        Block/Sector: {{ $r->block_sector ?? '' }} ,
                                        Area : {{ $r->area ?? '' }} </p>
                                </td>

                                <td class="whitespace-nowrap">
                                    {{ date('d-M-Y', strtotime($r->created_at)) }}
                                </td>

                                <td class="text-center noprint" style="width:160px;">
                                    <div class="dropdown">
                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">


                                            <a href="{{ route('clients.show', $r->client_id) }}"
                                                class="dropdown-item">Details</a>

                                            @can('mac-customer_edit')
                                                <a href="{{ route('clients.edit', $r->client_id) }}"
                                                    class="dropdown-item">Edit</a>
                                            @endcan

                                            <div class="mb-1"></div>

                                            {{-- @if ($r->client_approval != 'pending' && $r->clients_status != 'deactive')
                                @can('customer-deactivated')
                                <x-Custom.Actionform href="{{ route('deactive',$r->id) }}" formClass="dactive"
                            btnClass="block btn-blue" submitValue="Dactive"
                            inputName="user_approve" inputId="{{$r->id}}" />
                            @endcan
                            @endif --}}




                                            @if ($r->client_approval == 'pending')

                                                @can('new-customer-approve')

                                                    {{-- <x-Custom.Actionform href="{{ route('clinetApprove', $r->id) }}" formClass="approve"
                                                btnClass="btn btn-success inline-block btn-xs" submitValue="Approve"
                                                inputName="user_approve" inputId="{{ $r->id }}"/> --}}

                                                    <form method="POST" action="{{ route('clinetApprove', $r->id) }}">
                                                        @method('post')
                                                        @csrf
                                                        <input type="hidden" name="user_approve"
                                                            value="{{ $r->id }}">
                                                        <button
                                                            onclick="return confirm('Are you sure you want to Approved this user ?');"
                                                            type="submit" class="dropdown-item">Approve</button>
                                                    </form>

                                                @endcan


                                            @endif

                                            @if ($r->clients_status == 'disable')
                                                @can('id-enable')
                                                    <a href="{{ route('idEnable', $r->client_id) }}"
                                                        onclick="return confirm('Are you sure you want to Enable the ID?');"
                                                        class="dropdown-item">Enable</a>

                                                @endcan
                                            @endif

                                            @if ($r->clients_status == 'active')
                                                @can('id-disable')
                                                    <a href="{{ route('idDisable', $r->client_id) }}"
                                                        onclick="return confirm('Are you sure you want to Disable the ID?');"
                                                        class="confirmDisable dropdown-item">Disable</a>

                                                @endcan
                                            @endif


                                            {{-- @can('mac_customer_destroy') --}}
                                            @can('mac-customer_destroy')

                                                <form method="POST"
                                                    action="{{ route('clients.destroy', $r->client_id) }}">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button
                                                        onclick="return confirm('Are you sure you want to Delete this user ?');"
                                                        type="submit" class="dropdown-item">Delete</button>
                                                </form>
                                            @endcan
                                            {{-- @endcan --}}




                                            @can('customer-recharge')

                                                @if ($r->clients_status == 'active')



                                                    {{-- <x-Custom.Actionform href="{{ route('recharge',$r->id) }}" formClass="approve"
                            btnClass="block bg-yellow-400 text-white" submitValue="Recharge 1 Month" inputName="recharge"
                            inputId="{{$r->id}}" /> --}}

                                                    {{-- <x-Custom.Actionform href="{{ route('deactive',$r->id) }}" formClass="approve"
                            btnClass="block bg-red-600 text-white" submitValue="Deactive" inputName="id"
                            inputId="{{$r->id}}" /> --}}

                                                @endif



                                                @if ($r->clients_status == 'expired')
                                                    {{-- <x-Custom.Actionform href="{{ route('recharge',$r->id) }}" formClass="approve"
                            btnClass="block bg-yellow-400 text-white" submitValue="Recharge 1 Month" inputName="recharge"
                            inputId="{{$r->id}}" /> --}}
                                                @endif

                                            @endcan

                                            {{-- </x-Custom.dropDownMenu> --}}

                                            {{-- @elseif($r->clients_status == 'deactive')

                            <x-Custom.Actionform href="{{ route('clinetApprove',$r->id) }}" formClass="approve"
                            btnClass="bg-gray-300 text-black" submitValue="Reactive"
                            inputName="user_approve" inputId="{{$r->id}}" />

                            @endif --}}

                                        </div>
                                    </div>

                                </td>
                            </tr>

                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    <div class="card-footer">
        {{-- {{ $list->onEachSide(2)->links() }} --}}

        {{-- {{ $list->links() }} --}}


        {{-- @endif --}}
    </div>
</div>

<style>
    div#processing {
        display: none;
    }

    div#processing div {
        background: rgba(0, 0, 0, .5);
        position: fixed;
        width: 100vw;
        height: 100vh;
        color: #fff;
        text-align: center;
        vertical-align: middle;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    @media print {
        a {
            text-decoration: none !important;
            color: #222 !important;
        }

        th {
            font-size: 10px !important;
            padding: 2px !important;
            text-align: center;
        }

        tr {
            font-size: 10px !important;
            margin: 2px !important;
            padding: 2px !important;
        }

        td {
            font-size: 10px !important;
            margin: 2px !important;
            padding: 2px !important;
        }

        table {
            width: 100%;
        }

        .shadow {
            box-shadow: none;
        }

        tr th:last-child {
            display: none !important;
        }

        tr td:last-child {
            display: none !important;
        }

    }

</style>

@endsection

@section('ajax')

<script>
    $('#customer_search').on('keyup', function() {
        let name = $(this).val();
        $('#processing').show();

        if (name.length >= 2 || name.length == 0) {
            $.ajax({
                type: 'get',
                url: '{{ route('customer_search') }}',
                data: {
                    search: name
                },
                success: function(result) {

                    $('#customer_list_body').html(result);
                    $('#processing').hide();
                    //checkExpire();
                }
            });
        }


    });
</script>

@endsection
