<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="<?php echo e(asset('loginAsset/fonts/icomoon/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('loginAsset/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('loginAsset/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <title>YetFix Radius | Customer Register</title>
</head>

<body class="authentication-page">
    <div class="container-fluid">
        <div class="row">
            <div class=" col-sm-12 col-md-4  d-flex flex-column justify-content-center text-light"
                style=" z-index:1; background: #ffffff; min-height:100vh;">

                <div class="text-center  mb-4 mt-1 loginsection">

                    <?php if(session('error_message')): ?>
                        <div class="text-white bg-danger p-2 borderd rounded alert" role="alert">
                            <?php echo e(session('error_message')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(session('success_message')): ?>
                        <div class="text-white bg-success p-2 borderd rounded alert" role="alert" style="">
                            <?php echo e(session('success_message')); ?>

                        </div>
                    <?php endif; ?>
                </div>

                <form method="POST" action="<?php echo e(route('client-register.store')); ?>" class="w-100 rounded   mx-auto">
                    <?php echo csrf_field(); ?>

                    <h1 class="login-head " style="color:#000000;">Customer Register</h1>

                    <div class="form-group position-relative">
                        <label class="form-label sr-only" for="name">Name</label>
                        <i class="fa-solid fa-user icon-placeholder text-dark"></i>

                        <input type="text" name="name" class="form-control custom-input" placeholder="Name"
                            required autocomplete="off" />
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group position-relative">
                        <label class="form-label sr-only" for="email">Email</label>
                        <i class="fa-solid fa-envelope icon-placeholder text-dark"></i>

                        <input type="email" name="email" class="form-control custom-input" placeholder="email"
                            required autocomplete="off" />
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group position-relative mt-4 ">
                        <label class="form-label sr-only" for="phone">Contact</label>
                        <i class="fa-solid fa-phone icon-placeholder text-dark"></i>

                        <input type="text" name="phone" class="form-control custom-input" placeholder="Mobile No"
                            required />
                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group position-relative mt-4">
                        <label class="form-label sr-only" for="connectivity">Type</label>
                        <select name="connectivity" class="select2 form-control" required>
                            <option value="">Select Type</option>
                            <option value="Home">Home</option>
                            <option value="Corporate">Corporate</option>
                        </select>
                        <?php $__errorArgs = ['connectivity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group position-relative mt-4 ">
                        <label class="form-label sr-only" for="package">Package</label>
                        <select name="package" class="select2 form-control" required>
                            <option value="">Select Package</option>
                            <option value="5MBPS">5 MBPS</option>
                            <option value="7MBPS">7 MBPS</option>
                            <option value="8MBPS">8 MBPS</option>
                            <option value="10MBPS">10 MBPS</option>
                            <option value="15MBPS">15 MBPS</option>
                            <option value="20MBPS">20 MBPS</option>
                            <option value="25MBPS">25 MBPS</option>
                            <option value="30MBPS">30 MBPS</option>

                            
                        </select>
                        <?php $__errorArgs = ['package'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group position-relative mt-4 ">
                        <label class="form-label sr-only" for="address">Address</label>
                        <i class="fa-solid fa-address-card icon-placeholder text-dark"></i>

                        <textarea name="address" class="form-control custom-input" placeholder="Address" required></textarea>
                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group position-relative mt-4 ">
                        <label class="form-label sr-only" for="message">Message</label>
                        <i class="fa-solid fa-address-card icon-placeholder text-dark"></i>

                        <textarea name="message" class="form-control custom-input" placeholder="Message"></textarea>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="text-center pt-1 mb-5 pb-1">
                        <button type="submit"
                            class="btn btn-purple btn-block gradient-custom-2 mb-3">Register For New Connection Request
                            </button>

                    </div>
                </form>

                <div style="max-width:1200px;margin:0 auto;" class="mt-5">
                    <div class="text-center p-4 text-dark">
                        Copyright © 2020-<?php echo e(date('Y')); ?> YetFix Limited. | <a
                            class="text-center fw-bold text-dark" href="<?php echo e(route('privacyPolicy')); ?>"
                            target="_blank">Privacy
                            Policy</a>
                    </div>
                </div>
            </div>

            <div class="d-none d-sm-none d-md-block  col-md-8 h-100 pr-0 pl-0 position-relative"
                style="overflow: hidden;min-height:100vh;">
                <?php if(siteinfo()->landing_image): ?>
                    <img src="<?php echo e(asset('storage/company/' . siteinfo()->landing_image)); ?>"
                        alt="yetfix authentication way" class="img-fluid poster">
                <?php else: ?>
                    <img src="<?php echo e(asset('auth-image/yetfixposter.png')); ?>" alt="yetfix authentication way"
                        class="img-fluid poster">
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>

</html>
<style>
    @import  url('https://fonts.googleapis.com/css2?family=Nunito+Sans:opsz,wght@6..12,400;6..12,500;6..12,600;6..12,700;6..12,800&display=swap');

    .authentication-page {
        margin: 0;
        padding: 0;
        height: 100vh;
        font-family: 'Nunito Sans', sans-serif;
    }

    .btn-purple {
        background: rgb(35, 10, 118, 0.7);
        color: #FFFF;
    }

    .btn-purple:hover {
        background: rgb(35, 10, 118, 0.9);
        color: #FFFF;
    }

    label {
        letter-spacing: 0.05em;
    }

    .form-control:focus {

        box-shadow: 0 0 10px rgba(255, 153, 0, 0.5);
        color: #000000;
    }

    @media(max-width: 767px) {
        .poster {
            height: 100%;
            width: 100%;
            position: relative;

        }
    }

    @media(min-width: 767px) {
        .poster {
            height: 100vh;
            position: relative;
            width: 100%;

        }
    }

    .form-control::placeholder {
        letter-spacing: 0.05em;
        font-size: 16px;
        color: #000000;
        text-align: center;

    }

    .custom-input {
        background: inherit;
        text-align: center;
        color: #000000;
    }

    /* Override autofill background color */
    .custom-input:not(:placeholder-shown) {
        background-color: inherit !important;
    }

    .login-head {
        letter-spacing: 0.05em;
        text-align: center;
        margin-bottom: 36px;
        font-size: 16px;

    }

    @media  only screen and (min-width:1367px) and (max-width:1920px) {
        .loginsection {
            margin-top: 3px !important;
            margin-botttom: 3px !important;
        }

        .logo {
            width: 105px;
            height: 105px;
            border-radius: 9%;
        }

        .mobile-mb-0 {
            margin-bottom: 0 !important;
        }

        .login-head {
            font-size: 22px;
        }
    }

    .icon-placeholder {
        position: absolute;
        bottom: 10px;
        left: 15px;
    }

    @media(max-width:412px) {
        .icon-placeholder {
            bottom: 10px;
            left: 8px;

        }
    }

    input:-webkit-autofill,
    input:-webkit-autofill:hover,
    input:-webkit-autofill:focus,
    input:-webkit-autofill:active {
        -webkit-box-shadow: 0 0 0 30px #f0f2f7 inset !important;
        -webkit-text-fill-color: #000000 !important;
    }

    @media  only screen and (min-width:1200px) and (max-width:1366px) {
        .logo {
            width: 80px;
            height: auto;
        }
    }

    @media  only screen and (min-width:1367px) and (max-width:1920px) {
        .logo {
            width: 105px;
            height: 105px;
        }
    }
</style>
<?php /**PATH /var/www/html/friendsdigital/radius-circle/resources/views/clientRegister/register.blade.php ENDPATH**/ ?>