<?php

namespace Database\Seeders;

use App\Models\FormSetting;
use Illuminate\Database\Seeder;

class FormSettingSeeder extends Seeder
{
    public function run()
    {
        $fields = [

            ['id' => '1',   'name' => 'Profile Picture',            'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '2',   'name' => 'Customer Agrement',          'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '3',   'name' => 'Form Picture',               'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '4',   'name' => 'Building Photo',             'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '5',   'name' => 'Client Flat Door Picture',   'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '6',   'name' => 'Ignore Mikrotik Check',      'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '7',   'name' => 'Username',                   'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '8',   'name' => 'Password',                   'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '9',   'name' => 'POP',                        'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '10',  'name' => 'Billing Cycle',              'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '11',  'name' => 'Package',                    'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '12',  'name' => 'Exp Date',                   'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '13',  'name' => 'Ethernet Port',              'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '14',  'name' => 'Static IP',                  'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '15',  'name' => 'MAC',                        'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '16',  'name' => 'Permanent Discount',         'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '17',  'name' => 'Bandwidth Limit',            'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '18',  'name' => 'Distribution Point',         'status' => 'inactive',     'group_name' => 'Service Information'],
            ['id' => '19',  'name' => 'Connection Type',            'status' => 'inactive',     'group_name' => 'Service Information'],

            ['id' => '20',   'name' => 'Name',              'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '21',   'name' => 'Birth Date',        'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '22',   'name' => 'Fathers Name',      'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '23',   'name' => 'Mothers Name',      'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '24',   'name' => 'NID',               'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '25',   'name' => 'Passport',          'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '26',   'name' => 'Contact',           'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '27',   'name' => 'Other Contact',     'status' => 'inactive',     'group_name' => 'Basic Information'],
            ['id' => '28',   'name' => 'Email',             'status' => 'inactive',     'group_name' => 'Basic Information'],

            ['id' => '29',   'name' => 'Division',          'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '30',   'name' => 'District',          'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '31',   'name' => 'Upazila',           'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '32',   'name' => 'Area/UP',           'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '33',   'name' => 'Block/Post',        'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '34',   'name' => 'Road/Village',      'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '35',   'name' => 'Road No/Ward No',   'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '36',   'name' => 'Building',          'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '37',   'name' => 'Building No',       'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '38',   'name' => 'Flat/Level No',     'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '39',   'name' => 'Box',               'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '40',   'name' => 'Latitude',          'status' => 'inactive',     'group_name' => 'Address'],
            ['id' => '41',   'name' => 'Longitude',         'status' => 'inactive',     'group_name' => 'Address'],

            ['id' => '42',   'name' => 'House Owner Name',  'status' => 'inactive',     'group_name' => 'Building Owner Contact'],
            ['id' => '43',   'name' => 'Owner Contact',     'status' => 'inactive',     'group_name' => 'Building Owner Contact'],

            ['id' => '44',   'name' => 'Cable type',                'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '45',   'name' => 'From',                      'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '46',   'name' => 'To',                        'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '47',   'name' => 'From(2nd)',                 'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '48',   'name' => 'To(2nd)',                   'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '49',   'name' => 'Total Cable(Meter)',        'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '50',   'name' => 'Cable ID',                  'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '51',   'name' => 'Cable(CAT-5/CAT-6)',        'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '52',   'name' => 'Cable(CAT-5/CAT-6) Meter',  'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '53',   'name' => 'Marketed By',               'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '54',   'name' => 'Add Marketer',              'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '55',   'name' => 'OTC',                       'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '56',   'name' => 'ONU MAC/Pon No/Serial No',  'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '57',   'name' => 'OLT No',                    'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '58',   'name' => 'OLT Card Slot No',          'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '59',   'name' => 'PON Module Port No',        'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '60',   'name' => 'Source Name',               'status' => 'inactive',     'group_name' => 'Connection Information'],
            ['id' => '61',   'name' => 'Remarks',                   'status' => 'inactive',     'group_name' => 'Connection Information'],


        ];

        foreach ($fields as $item) {

            unset($item['id']);

            if (FormSetting::where('name', $item['name'])->count() < 1) {

                FormSetting::create([
                    'name' => $item['name'],
                    'status' => $item['status'] ?? 'inactive',
                    'group_name' => $item['group_name'] ?? null,
                ]);
            }
        }
    }
}
