<x-addCustomer.universal>
    <div class="w-100 text-center">
        <h3 class=" text-light">Service Information</h3>
    </div>
    <div class="row mt-3">

        <div class="form-group col-sm-3">

            <label for="userid" class="block ">PPPoE User Name*</label>

            <input type="text" name="userid" id="userid" value="{{ old('userid') }}" class="form-control" required
                placeholder="User Name">
            <div id="useridWarning"></div>
            @error('userid')
                <div class="alert alert-danger "> {{ $message }} </div>
            @enderror
        </div>

        <div class="form-group col-sm-3">
            <label for="password" class="block text-sm font-medium text-gray-700">
                PPPoE Password*
            </label>

            <input type="text" name="password" id="password" value="{{ old('password') }}" required
                class="form-control " placeholder="Password">
            @error('password')
                <div class="alert alert-danger mt-1">
                    {{ $message }}
                </div>
            @enderror
        </div>


        <div class="form-group col-sm-3">
            <label for="pop_id" class="block ">
                Pop/Zone Name*
            </label>

            <select name="pop_id" id="pop_id" class="select2 form-control" required>
                <option value="">Select Pop</option>

                <option class="p-5" value="1">
                    1</option>
                <option class="p-5" value="1">
                    2</option>
                <option class="p-5" value="1">
                    3</option>


            </select>

            @error('pop_id')
                <div class="alert alert-danger mt-1">
                    {{ $message }}
                </div>
            @enderror
        </div>


        <div class="form-group col-sm-3">
            <label for="billing_cycle" class="block ">
                Billing Cycle*
            </label>
            <select name="billing_cycle" id="billing_cycle" class="form-control select2" required>

                <option value="{{ today()->addDay(30)->format('d') }}">
                    {{ today()->addDay(30)->format('d') }}</option>

            </select>

            @error('billing_cycle')
                <div class="alert alert-danger mt-1">{{ $message }}</div>
            @enderror

        </div>

        <div class="form-group col-sm-3">
            <label for="billing_cycle" class="block ">
                Billing Cycle*
            </label>
            <select name="billing_cycle" id="billing_cycle" class="form-control select2" required>
                <option value="">Select Billing Cycle</option>

                <option value="1"></option>
                <option value="2"></option>
                <option value="3"></option>

            </select>

            @error('billing_cycle')
                <div class="alert alert-danger mt-1">{{ $message }}</div>
            @enderror

        </div>


        <div class="form-group col-sm-3">
            <label for="package_id" class="block text-sm font-medium text-gray-700">
                Package Name*
            </label>

            <select name="package_id" id="package_id" class="form-control select2" required>
                <option value="">Select Pop First</option>
            </select>

            @error('package_id')
                <div class="alert alert-danger mt-1">
                    {{ $message }}
                </div>
            @enderror
        </div>

        <div class="form-group col-sm-3">
            <div class="row">
                <div class="col-md-8">
                    <label for="password" class="block pt-2">
                        Expired Date
                    </label>
                    <div id="cost_message"></div>
                </div>

                <div class="col-md-4" id="bill_payment_status" style="display: none">
                    <label for="">Select Payment Status</label>


                    <label for="paid"><input type="radio" id="paid" name="bill_amount_paid" value="1"
                            required checked> Bill Amount Paid</label>

                    <label for="not_paid">
                        <input type="radio" id="not_paid" name="bill_amount_paid" value="0" required checked>
                        Bill Amount Not Paid</label>

                </div>
            </div>

        </div>

        <div class="form-group col-sm-3">
            <label for="package_id" class="block text-sm font-medium text-gray-700">
                Ethernet Port
            </label>

            <select name="port" id="port" class="form-control select2">
                <option value="">Select Ethernet Port</option>

            </select>

            @error('port')
                <div class="alert alert-danger mt-1">
                    {{ $message }}
                </div>
            @enderror
        </div>

        <div class="form-group col-sm-3">
            <label for="client_name" class="block ">
                Static IP <input type="checkbox" id="isStaticIpOk">
            </label>
            @if (!checkAPI())
                <input style="display: none" type="text" name="static_ip" id="static_ip"
                    value="{{ old('static_ip') }}" class="form-control " placeholder="Static IP">
                @error('static_ip')
                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                @enderror
            @else
                @if (checkSettings('static-ip-check') == 'enable')
                    <select class="form-control" name="static_ip" id="static_ip" style="display: none">

                    </select>
                @else
                    <input style="display: none" type="text" name="static_ip" id="static_ip"
                        value="{{ old('static_ip') }}" class="form-control " placeholder="Static IP">
                    @error('static_ip')
                        <div class="alert alert-danger mt-1">{{ $message }}</div>
                    @enderror
                @endif
            @endif
        </div>


        <div class="form-group col-sm-3">
            <label for="mac" class="block ">
                Enable MAC
            </label>

            <input type="text" name="mac" id="mac" value="{{ old('mac') }}" class="form-control "
                placeholder="Enable Mac">
            @error('mac')
                <div class="alert alert-danger mt-1">{{ $message }}</div>
            @enderror

        </div>

        @if (checkSettings('radius_customer_bandwidth_limit') == 'enable')
            @can('apply-bandwidth-limit')
                <div class="form-group col-sm-3" id="">
                    <label for="bandwidth_limit" class="block">
                        Bandwidth Limit(MB) - Ignore <input name="apply_bandwidth_limit" type="checkbox">
                    </label>
                    <input type="number" name="bandwidth_limit" id="bandwidth_limit" value=""
                        class="form-control " placeholder="Bandwidth Limit">
                    @error('bandwidth_limit')
                        <div class="alert alert-danger mt-1">{{ $message }}</div>
                    @enderror
                </div>
            @endcan
        @endif



    </div>
</x-addCustomer.universal>
