@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="col-md-12">
                <div class="badge badge-info float-right m-1" style="text-align: ">Total Row: {{ $dueOtc->count() }}</div>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="text-center">ID</th>
                            <th scope="col" class="text-center">Date</th>
                            <th scope="col" class="text-center">Username</th>
                            <th scope="col" class="text-center">Name</th>
                            <th scope="col"class="text-center">Contact</th>
                            <th scope="col" class="text-center">OTC</th>
                            <th scope="col" class="text-center">Due OTC</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">

                        @php $total = 0; @endphp
                        @php $totalOtc = 0; @endphp

                        @foreach ($dueOtc as $r)
                            <tr>
                                <td class="text-center">{{ $r->clients->id ?? '' }}</td>
                                <td class="text-center">{{ date('d-M-Y h:i:s A', strtotime($r->created_at)) }}</td>
                                <td class="text-center">{{ $r->clients->userid ?? '' }}</td>
                                <td class="text-center">{{ $r->clientsinfo->clients_name ?? '' }}</td>
                                <td class="text-center">{{ $r->clientsinfo->contact_no ?? '' }}</td>

                                <td class="text-right">
                                    @php $totalOtc += $r->bill_amount @endphp
                                    {{ $r->bill_amount }}
                                </td>

                                <td class="text-right">
                                    @php $total += $r->clientsinfo->otc_due @endphp
                                    {{ $r->clientsinfo->otc_due }}
                                </td>
                            </tr>
                        @endforeach
                        <tr>
                            <td colspan="5" class="text-right">Total: </td>
                            <td class="text-right">{{ number_format($totalOtc, 2, '.', '') }}</td>
                            <td class="text-right">{{ number_format($total, 2, '.', '') }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
