<?php

namespace App\Jobs;

use App\Http\Controllers\CustomerInvoiceController;
use App\Models\Client;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class SendMailForMonthlyBillJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    

    public function __construct()
    {        
    }

    public function handle()
    {

        $clients = Client::with('clientsinfo', 'packages:id,package_name,package_rate', 'subpack:id,name,rate', 'pop:id,popname,bill_generate,subreseller', 'customerAccount', 'pop.reseller')
            ->selectRaw('id,pop_id,billing_cycle,package_id,userid,password,ip_address,expire_date,payment_dadeline,created_by,client_approval,created_at,clients_status,sub_package_id,customer_id,marketed_by,deleted_at,pop_id')
            ->where('client_approval', 'approved')
            ->whereHas('pops', function ($q) {
                $q->where('bill_generate', 'yes');
            })->get();        

        foreach ($clients as $client) {
            (new CustomerInvoiceController)->batchSendInvoice($client);
        }
    }
}
