<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFiberMap extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fiber_map', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            $table->foreignId("cable_id");
            $table->foreignId("tube_id");
            $table->integer("fiber_number");

            $table->string("type")->default("fiber");

            $table->foreignId("parent_fiber_id")->nullable();
            $table->foreignId("child_fiber_id")->nullable();


            $table->string("parent_component_type")->nullable();
            $table->foreignId("parent_component_id")->nullable();

            $table->string("child_component_type")->nullable();
            $table->foreignId("child_component_id")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fiber_map');
    }
}
