@extends('layout.app')

@section('content')
    <div class="card">
        <div class=" card-body">

            <form action="#" id="searchForm"  method="POST">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" id="from_date" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>

                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" id="to_date"  name="to_date" value="{{ $end->format('m/d/y') }}" class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">

                            </div>


                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Select Manager</label>

                            <select name="reseller_id" v-model="reseller_id" class="form-control select2" id="reseller_id">
                                <option value="">All Manager</option>
                                @foreach (userResellers() as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Select Pop</label>

                            <select name="pop_id" v-model="reseller_id" class="form-control select2" id="pop_id">
                                <option value="">All Pop</option>
                            </select>
                        </div>
                    </div>




                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button class="btn btn-primary" type="submit" id="searchBtn"><i class="fa fa-search"></i>
                                Search</button>

                        </div>
                    </div>

                </div>
            </form>


                <div class="table-responsive">
                    <div>
                        <button id="downloadBtn" class="btn btn-primary">Download In Excele</button>
                        <button id="downloadPdfBtn" class="btn btn-primary">Download In pdf</button>
                        {{-- <button id="printBtn" class="btn btn-primary">Print</button> --}}
                    </div>
                    <div class="print-content" id="result">
                        @include('report.dueAmountCheckByMonth.result')

                    </div>
                </div>

        </div>
    </div>

    <style>

        @media print {
          body * {
              visibility: hidden;
          }

          .no-page-break {
              page-break-inside: avoid !important;
          }

          .print-content, .print-content * {
              visibility: visible;
          }

          .print-content {
              position: absolute;
              left: 10px;
              top: 0;
          }

          .print-content table {
              width: 100%;
              border-collapse: collapse;
              font-size: 16pt;
          }

          .print-content th,
          .print-content tr,
          .print-content td {
              padding: 8px;
              font-size: 14pt !important;
              font-weight: bold;
          }

          .print-content th {
              background-color: #f2f2f2; /* Optionally set a background color for table headers */
          }

          .print-content td {
              border: 1px solid #ddd; /* Optionally add borders to table cells */
          }

          .no-print {
              display: none;
          }
      }
      </style>
@endsection



@section('ajax')

<script src="{{ asset('/') }}js/xlsx/xlsx.full.min.js"></script>
<script src="{{ asset('/') }}js/html2pdf/html2pdf.bundle.min.js"></script>
<script>


    document.getElementById('downloadBtn').addEventListener('click', function() {
        // Function to create and download Excel file
        exportToExcel();
    });

    function exportToExcel() {
        const table = document.getElementById('tableId');
        const wb = XLSX.utils.table_to_book(table, { sheet: 'Stock Data' });
        XLSX.writeFile(wb, 'due_customers.xlsx');
    }

    document.getElementById('downloadPdfBtn').addEventListener('click', function() {
        // Function to create and download PDF file
        exportToPdf();
    });

    function exportToPdf() {

        const element = document.getElementById('tableId');

            html2pdf(element, {
                filename: 'due_customers.pdf',
                jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' },
                pagebreak: { mode: 'avoid-all', before: '.pagebreakclass' }
            });
    }

    // document.getElementById('printBtn').addEventListener('click', function() {
    //     // Function to initiate the print process
    //     printTable();
    // });

    function printTable() {
        window.print();
    }

    $(document).ready(function() {



        $('#reseller_id').on('change', function(e) {
            e.preventDefault();
            $('body').append('<div class="hidden" id="loading">Loading.....</div>');
            $.ajax({
                type: 'get',
                url: '{{ route('getResellerPopList') }}',
                data: {
                    id: $(this).val()
                },
                success: function(result) {
                    $('#pop_id').html(result);
                    $('#loading').remove();
                }
            });
        });

        $('#searchBtn').on('click', function(e) {
                e.preventDefault();

                // $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('dueAmountCheckByMonthSearch') }}',
                    data: $('#searchForm').serialize(),

                    success: function(result) {
                        $('#result').html(result);

                        $('#loading').remove();
                    }
                });
            });
    });

</script>
@endsection
