@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <h4 class="text-center">View Bank Account Information</h4>
                    <hr>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th scope="col">sl.</th>
                                    <th scope="col">Account Name</th>
                                    <th scope="col">Account No</th>
                                    <th scope="col">Bank Name</th>
                                    <th scope="col">Branch Name</th>
                                    <th scope="col">Opening Balance</th>
                                    <th scope="col">Balance</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($bankings as $banking)
                                    <tr>
                                        <th>{{ $loop->index + 1 }}</th>
                                        <td>{{ $banking->account_name }}</td>
                                        <td>{{ $banking->account_no }}</td>
                                        <td>{{ $banking->bank_name }}</td>
                                        <td>{{ $banking->branch_name }}</td>
                                        <td>{{ $banking->opening_balance  }}</td>
                                        <td>{{ $banking->balance  }}</td>
                                        <td>
                                            <div class="btn-group" role="group" aria-label="Basic example">
                                                @if ($banking->action == 0)
                                                    <a href="{{ route('banking.approve', $banking->id) }}" class="btn btn-warning btn-sm">Disapproved</a>
                                                @else
                                                    <button type="button" class="btn btn-success btn-sm">Approved</button>
                                                @endif

                                                <a href="{{ route('banking.edit', $banking->id) }}" class="btn btn-info btn-sm">Edit</a>
                                                <form action="{{ route('banking.destroy', $banking->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" onclick="return confirm('Are you sure you want to delete this item?')" class="btn btn-danger btn-sm">Delete</button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        {{ $bankings->links() }}
                    </div>

                </div>
            </div>

        </div>
    </div>
@endsection

@push('js')
@endpush
