@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">

            <div class="card-header">
                <h3 class="card-title" style="color:#115548;">Employee List</h3>
                <div class="card-tools">
                    <a href="{{ route('employees.create') }}"><button class="btn btn-sm btn-primary"><i
                                class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp;Add Employee</button></a>
                </div>
            </div>

            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered table-striped">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                ID
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Employee Name
                            </th>

                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                User ID
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                designation
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                join date
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                manager id
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Mobile(Office)
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Admin User
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">

                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">

                        @foreach ($employees as $r)
                            <tr>
                                <td class="whitespace-nowrap">
                                    {{ $r->id }}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ $r->name }}
                                </td>

                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->user_id }}
                                </td>

                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->current_designation }}
                                </td>
                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->join_date }}
                                </td>

                                <td class="whitespace-nowrap">
                                    {{ $r->manager_id }}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ $r->mobile_office }}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ $r->admin->name ?? '' }}
                                </td>
                                <td class="whitespace-nowrap text-right text-sm font-medium">

                                    <form action="{{ route('employees.destroy', $r->id) }}" method="POST">
                                        @method('DELETE')
                                        @csrf
                                        <a href="{{ route('employees.edit', $r->id) }}" class="btn btn-primary">Edit</a>
                                        {{-- <button class="btn btn-danger">Delete</button> --}}
                                    </form>

                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
            <div class="p-5">
                {{ $employees->links() }}
            </div>
        </div>
    </div>
@endsection
