import { Form } from 'react-bootstrap';

const MapPort = ({ port, onChangeHandler, index }) => {
  return (
    <tr>
      <td>
        <Form.Control value={port.port_number} disabled />
      </td>
      <td>
        {' '}
        <Form.Control
          value={port.label}
          onChange={(e) => onChangeHandler(e, index)}
          name='label'
        />
      </td>
      <td>
        <Form.Select
          value={port.type}
          onChange={(e) => onChangeHandler(e, index)}
          name='type'
        >
          <option value='1g'>1G</option>
          <option value='10g'>10G</option>
          <option value='40g'>40G</option>
          <option value='100g'>100G</option>
          <option value='pon'>PON</option>
          <option value='xpon'>XPON</option>
          <option value='other'>OTHER</option>
        </Form.Select>
      </td>
      <td>
        <Form.Select
          value={port.port_stream}
          onChange={(e) => onChangeHandler(e, index)}
          name='port_stream'
        >
          <option value='incoming'>Incoming</option>
          <option value='outgoing'>Outgoing</option>
        </Form.Select>
      </td>
    </tr>
  );
};

export default MapPort;
