@extends('layout.app')


@section('content')
    <div class="card">
        <div class=" card-body">
            <form action="{{ route('user.store') }}" method="POST">

                @csrf
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="name">
                            Name*
                        </label>
                        <input value="{{ old('name') }}" class="form-control" name="name" id="name" type="text" required autocomplete="off">
                        @error('name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="email">
                            E-Mail Address*
                        </label>
                        <input value="{{ old('email') }}" class="form-control" name="email" id="email" type="email" required autocomplete="off">
                        @error('email')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="password">
                            Password*
                        </label>
                        <input class="form-control" name="password" id="password" type="password" required>
                        @error('password')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="password_confirmation">
                            Confirm Password*
                        </label>
                        <input class="form-control" name="password_confirmation" id="password_confirmation"
                            type="password" required>
                        @error('password_confirmation')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">

                        <label for="company">
                            Company Name
                        </label>
                        <input value="{{ old('company') }}" class="form-control" name="company" id="company"
                            type="text" >
                        @error('company')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    @can('assign-permission')
                        <div class="form-group col-md-4">

                            <label class="block text-gray-700 text-sm font-bold mb-2" for="user_accounting_status">
                                User Accounting*
                            </label>

                            <select name="user_accounting_status" id="user_accounting_status" class="form-control select2">
                                <option value="no">No</option>
                                <option value="yes">Yes</option>
                            </select>
                            @error('message')
                                <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                    @endcan
                    <div class="form-group col-md-4">

                        <label for="company">
                            Mobile Number
                        </label>
                        <input value="{{ old('mobile_number') }}" class="form-control" name="mobile_number" id="mobile_number"
                            type="text" autocomplete="off" placeholder="01733344466">
                        @error('mobile_number')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-md-12">

                        <label for="message">
                            Message
                        </label>

                        <input value="{{ old('message') }}" class="form-control" name="message" id="message"
                            type="text">
                        @error('message')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                </div>

                <div class="row">
                    <div class="form-group col-md-4">
                        <label class="block text-gray-700 text-sm font-bold mb-2" for="user_accounting_status">
                            Assign Role
                        </label>
                        <select name="assign_role[]" id="assign_role" class="form-control select2" multiple>
                            @foreach ($roles as $role)
                                <option value="{{ $role->id }}">{{ $role->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-3 d-none" id="assign_reseller_div">
                        <label class="block text-gray-700 text-sm font-bold mb-2" for="user_accounting_status">
                            Assign Reseller
                        </label>
                        <select name="assign_reseller[]" id="assign_reseller" class="form-control select2" multiple>
                            @foreach ($resellers as $reseller)
                                <option value="{{ $reseller->id }}">{{ $reseller->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-3 d-none" id="assign_pop_div">
                        <label class="block text-gray-700 text-sm font-bold mb-2" for="user_accounting_status">
                            Assign Pop
                        </label>
                        <select name="assign_pop[]" id="assign_pop" class="form-control select2" multiple>
                        </select>
                    </div>
                    @if (checkSettings('reseller-client-dynamic-recharge') == 'enable')
                        <div class="form-group col-md-2 d-none" id="minimum_recharge">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="user_accounting_status">
                                Client Recharge Days(Minimum)
                            </label>
                            <input type="number" class="form-control" name="minimum_recharge_day" placeholder="Insert Day">
                        </div>
                    @endif
                </div>


                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right mt-2">
                        Save
                    </button>
                </div>

            </form>
        </div>
    </div>
@endsection
@section('ajax')
    <script>
        $(document).ready(function() {

            $('#assign_role').change(function() {
                var role = $(this).val();
                var check_reseller = role.find(element => element == 8);
                var check_reseller_admin = role.find(element => element == 12);
                var check_sub_reseller = role.find(element => element == 11);

                if (check_reseller || check_reseller_admin || check_sub_reseller) {
                    $('#assign_reseller_div').removeClass('d-none');
                    $('#minimum_recharge').removeClass('d-none');
                    if (check_sub_reseller) {
                        $('#assign_pop_div').removeClass('d-none');
                    }else{
                        $('#assign_pop_div').addClass('d-none');
                    }
                } else {
                    $('#assign_reseller_div').addClass('d-none');
                    $('#assign_pop_div').addClass('d-none');
                    $('#minimum_recharge').addClass('d-none');
                    $('#assign_reseller').val(null).trigger('change');
                    $('#assign_pop').val(null).trigger('change');
                }
            });

            $("#assign_reseller").change(function() {
                var role = $('#assign_role').val();

                var check_sub_reseller = role.find(element => element == 11);

                if (check_sub_reseller) {
                    $('#assign_pop_div').removeClass('d-none');
                    var reseller_ids = $(this).val();
                    if(reseller_ids.length > 0){
                        $.ajax({
                            url: "{{ route('get-pop') }}",
                            type: "get",
                            data: {
                                reseller_ids: reseller_ids,
                            },
                            success: function(data) {
                                $('#assign_pop').empty();
                                data.forEach(element => {
                                    $('#assign_pop').append('<option value="' + element.id + '">' + element.popname + '</option>');
                                });
                            }
                        });
                    }else{
                        $('#assign_pop').val(null).trigger('change');
                        $('#assign_pop').empty();
                    }
                }else{
                    $('#assign_pop_div').addClass('d-none');
                    $('#assign_pop').val(null).trigger('change');
                }
            });
        });
    </script>
@endsection
