@extends('layout.app')


@section('content')
    <div class="card">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif


        <div class="card-body">
            <form action="{{route('payment-method.update',$payment_method)}}" method="POST" >
                @method('put')
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="{{$payment_method->name}}" autocomplete="off" required placeholder="Name">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Api Key</label>
                            <input type="text" class="form-control" id="api_key" name="api_key" value="{{$payment_method->api_key}}" autocomplete="off" required placeholder="Name">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Status</label>
                            <select class="form-control" name="status">
                                <option value="Active" @if ($payment_method->status == 'Active') selected @endif>Active</option>
                                <option value="Inactive" @if ($payment_method->status == 'Inactive') selected @endif>Inactive</option>

                            </select>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary float-right">
                    Save
                </button>

            </form>
        </div>
    </div>


@endsection

