<?php

namespace App\Models;

use Doctrine\DBAL\Types\Type;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillGenerate extends Model
{
    use HasFactory;

    protected $guarded = ['id'];


    public function clients()
    {
        return $this->belongsTo(Client::class, 'client_id', 'id')->withTrashed();
    }

    public function clientsinfo()
    {
        return $this->belongsTo(Clientsinfo::class, 'client_id', 'client_id');
    }

    public function customerAccount()
    {
        return $this->belongsTo(CustomerAccount::class, 'client_id', 'client_id');
    }
}
