@extends('layout.app')

@section('content')

    @cannot('specific_management_services')
        <div class="card">
            <div class="card-body">
                <form action="{{ route('allClientDownloadExcel') }}" method="POST" id="search">
                    @csrf

                    <div class="row">
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Manager Name
                                </label>
                                <select name="reseller" id="reseller" class="form-control select2 form-control-sm">
                                    <option value="all">ALL Manager</option>
                                    @foreach (userResellers() as $r)
                                        <option value="{{ $r->id }}">{{ $r->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    POP Name
                                </label>
                                <select name="pop" id="pop" class="form-control select2 form-control-sm" required>
                                    <option value="all"> ALL POP</option>

                                </select>
                            </div>
                        </div>

                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Select Area
                                </label>
                                {{-- <input class="form-control form-control-sm" name="area" type="text" placeholder=""> --}}
                                <select name="area" id="poparea" class="form-control select2 form-control-sm">

                                </select>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Billing Cycle
                                </label>
                                <select name="billing_cycle" id="billing_cycle" class="select2 form-control form-control-sm">
                                    <option value="all">ALL Billing Cycle</option>
                                    @foreach (explode(',', $confday) as $conf)
                                        <option value="{{ $conf }}">{{ $conf }}</option>
                                    @endforeach


                                    {{-- @for ($i = 1; $i <= 31; $i++)
                            <option value="{{$i}}">{{$i}}</option>
                        @endfor --}}
                                </select>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    User State
                                </label>
                                <select name="user_state" class="form-control form-control-sm">
                                    <option value="">ALL Customer Status</option>
                                    <option value="active">Active</option>
                                    <option value="disable">Disable</option>
                                    <option value="deactive">Deactive</option>
                                    <option value="expired">Expired</option>

                                </select>
                            </div>
                        </div>

                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Cable Type
                                </label>
                                <select name="cable_type" id="cable_type" class="form-control select2 form-control-sm">
                                    <option value="">Select Cable Type</option>
                                    <option value="cat5">Cat 5</option>
                                    <option value="cat6">Cat 6</option>
                                    <option value="fiber_optic">Fiber Optic</option>
                                </select>

                            </div>
                        </div>
                        @can('search-by-package-name')
                            <div class="col-md-2 col-sm-3 col-xs-6">
                                <div class="form-group">
                                    <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                        Select Packages
                                    </label>
                                    <select name="mother_package" class="select2 form-control  form-control-sm">
                                        <option value="">Select Package</option>
                                        @foreach ($packages as $package)
                                            <option value="{{ $package->id }}">{{ $package->package_name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>
                        @endcan
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Search By CID
                                </label>
                                <input class="form-control form-control-sm" name="user_id" type="text" placeholder="CID">
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Search By Username
                                </label>
                                <input class="form-control form-control-sm" name="value" type="text"
                                    placeholder="Username">
                            </div>
                        </div>
                        @if (checkSettings('customer_code') == 'enable')
                            <div class="col-md-2 col-sm-3 col-xs-6">
                                <div class="form-group">
                                    <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="code">
                                        Search By Code</label>
                                    <input class="form-control form-control-sm" name="code" type="text"
                                        placeholder="Code">
                                </div>
                            </div>
                        @endif
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="name">Search By
                                    Name</label>
                                <input class="form-control form-control-sm" name="name" type="text" placeholder="Name">
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Search By Contact
                                </label>
                                <input class="form-control form-control-sm" name="contact" type="text"
                                    placeholder="01234567891">
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Search By Box
                                </label>
                                <input class="form-control form-control-sm" name="box" type="text" placeholder="">
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Search By Expire Date From
                                </label>
                                <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                    <input type="text" name="expire_date_from"
                                        class="form-control form-control-sm datetimepicker-input input-group-append"
                                        data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Search By Expire Date To
                                </label>
                                <div class="input-group date" id="searchTo" data-target-input="nearest">
                                    <input type="text" name="expire_date_to"
                                        class="form-control form-control-sm datetimepicker-input input-group-append"
                                        data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="finance">
                                    Accounts Status
                                </label>
                                <select name="finance" class="select2 form-control  form-control-sm">
                                    <option value="">Select One</option>
                                    <option value="withDue">With Due</option>
                                    <option value="withoutDue">Without Due</option>
                                </select>
                            </div>
                        </div>
                        @can('vip-client-search')
                            <div class="col-md-2 col-sm-3 col-xs-6">
                                <div class="form-group">
                                    <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="experity_check">VIP
                                        Customer</label>
                                    <select name="experity_check" class="select2 form-control form-control-sm">
                                        <option value="">Select One</option>
                                        <option value="vip">VIP</option>
                                        <option value="non_vip">Non VIP</option>
                                    </select>
                                </div>
                            </div>
                        @endcan

                        <div class="col-md-2 col-sm-3 col-xs-6">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    Static IP
                                </label>
                                <input class="form-control form-control-sm" name="static_ip" type="text" placeholder="">
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6 mt-4">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    All Static IP User
                                </label>
                                <input class="" name="check_ip" type="checkbox" placeholder="">
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-3 col-xs-6 mt-4">
                            <div class="form-group">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="remote_access">
                                    All Remote Access User
                                </label>
                                <input class="" name="remote_access" type="checkbox" placeholder="">
                            </div>
                        </div>
                        @if (globalPermission('client-usage-search'))
                            <div class="col-md-2 col-sm-3 col-xs-6">
                                <div class="form-group">
                                    <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="usage">
                                        Search By Usage
                                    </label>
                                    <input class="form-control form-control-sm" name="usage" type="text"
                                        placeholder="Usage in GB">
                                </div>
                            </div>
                        @endif

                        {{-- <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="area">
                                Search By Area
                            </label>
                            <input class="form-control form-control-sm" name="area" type="text" placeholder="">
                        </div>
                    </div> --}}




                    </div>
                    <div class="form-group float-right">
                        <input type="hidden" name="changeType" value="packageChange">

                        <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                class="fa fa-search"></i> Search</button>
                        <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        @can('allClientDownloadExcel')
                            <button type="submit" class="noprint btn btn-primary">
                                <i class="fa fa-download"></i> Download Client
                            </button>
                        @endcan
                    </div>

                </form>

            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <div id="result">
                    {{-- list will show in this box --}}
                </div>
            </div>
        </div>
    @endcannot







@endsection




@section('ajax')
    <script>
        $(window).on('hashchange', function() {
            if (window.location.hash) {
                var page = window.location.hash.replace('#', '');
                if (page == Number.NaN || page <= 0) {
                    return false;
                } else {
                    getPosts(page);
                }
            }
        });
        $(document).ready(function() {
            $(document).on('click', '.pagination a', function(e) {
                getPosts($(this).attr('href').split('page=')[1]);
                e.preventDefault();
            });
        });

        function getPosts(page) {
            $.ajax({
                url: 'clientSearchReport?page=' + page,
                dataType: 'html',
            }).done(function(data) {
                $('#result').html(data);
                location.hash = page;
            }).fail(function() {
                alert('Could not be loaded.');
            });
        }
    </script>


    <script type="text/javascript">
        function status(id, status) {
            if (confirm("Are you sure to change status?")) {
                url = "{{ url('/admin/') }}" + "/" + status + "/" + id;
                window.location.href = url;
            }

        }




        $(function() {

            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">ALL POP</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();

                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('clientSearchReport') }}',
                    data: $('#search').serialize(),
                    dataType: "html",
                    success: function(result) {
                        $('#result').html(result);
                        $('#dataTable').DataTable({
                            'destroy': true,
                        });
                        $('#loading').remove();
                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#loading').remove();

                    }
                });

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerWiseArea') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#poparea').html(result);
                        $('#loading').remove();

                    }
                });
            });



            $('#pop').on('change', function(e) {
                // console.log('come here');
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getPopWiseAreaList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        // console.log(result);
                        $('#poparea').html(result);
                        $('#loading').remove();

                    }
                });

            });

            // $('#poparea').on('change', function(e) {
            //     console.log('come here');
            //     e.preventDefault();
            //     $('body').append('<div class="hidden" id="loading">Loading.....</div>');
            //     $('#pop').html('<option value="all">ALL POP</option>');
            //     $('#reseller').html('<option value="all">ALL Reseller</option>');
            // });



        });

        /*auto deactive date change start*/
        // const autoDeactiveDateApply = function(cid) {
        //     const cidOfClient = document.getElementById(`autoDeactiveId-${cid}`);
        //     const autoDeactiveDate = cidOfClient.getAttribute('data-autodeactive');
        //     const deactiveModalPropertiesCid = document.getElementById("deactive_client_id");
        //     const deactiveModalPropertiesAutoDate = document.getElementById("deactiveDate");

        //     if (autoDeactiveDate !== '01-Jan-1970') {
        //         deactiveModalPropertiesAutoDate.setAttribute("value", autoDeactiveDate);
        //     }
        //     deactiveModalPropertiesCid.setAttribute("value", cid);

        // }
        /*auto deactive date chnage end*/
        $(document).on('click', '.changeTemporaryExtend', function() {
            var id = $(this).attr('data-id');
            var extendedDay = $(this).attr('data-tmpExtend');
            $('#extend').val(extendedDay);
            $('#client_id').val(id);
        });
    </script>
@endsection
