@extends('layout.app')
@section('content')
    <form action="{{ route('sms-gateway.update', $gateway->id) }}" method="POST">
        @method('put')
        @csrf
        <div class="card">
            <div class="card-body">
                <div class="row">
                <div class="form-group col-md-4">
                    <label for="username" class="block text-sm font-medium text-gray-700">
                        Name
                    </label>
                    <input type="text" name="username" id="username" value="{{ $gateway->username }}"
                        class="form-control " placeholder="Name" autocomplete="off" required>
                    @error('username')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="apikey" class="block text-sm font-medium text-gray-700">
                        API key
                    </label>
                    <input type="text" name="apikey" id="apikey" class="form-control" placeholder="API Key"
                        value="{{ $gateway->apikey }}" autocomplete="off" required>
                    @error('apikey')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="sender" class="block text-sm font-medium text-gray-700">
                        Sender
                    </label>
                    <input type="text" name="sender" id="sender" class="form-control" placeholder="Sender"
                        value="{{ $gateway->sender }}" autocomplete="off" required>
                    @error('sender')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-12">
                    <label for="url" class="block text-sm font-medium text-gray-700">
                        URL
                    </label>
                    <input type="text" name="url" id="url" class="form-control"
                        placeholder="https://sms.solutionsclan.com/api/sms/send?apiKey={apikey}&contactNumbers={contactNumber}&senderId={senderNumber}&textBody={messageBody}"
                        value="{{ $gateway->url }}" autocomplete="off" required>
                    @error('url')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="balance_url" class="block text-sm font-medium text-gray-700">
                        Balance URL
                    </label>
                    <input type="text" name="balance_url" id="balance_url" class="form-control" placeholder="Balance url"
                        value="{{ $gateway->balance_url }}" autocomplete="off" required>
                    @error('balance_url')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="status" class="block text-sm font-medium text-gray-700">
                        Status
                    </label>
                    <select name="status" id="status" class="form-control select2" required>
                        <option value="">Select One</option>
                        <option value="enable" {{ $gateway->status == 'enable' ? 'selected' : '' }}>Enable</option>
                        <option value="disable" {{ $gateway->status == 'disable' ? 'selected' : '' }}>Disable</option>
                    </select>

                    @error('status')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>

            </div>
        </div>


    </form>
@endsection
