  <div class="card">
      <div class="card-body">
          <a href="{{ route('tokenExport') }}" class="btn btn-sm btn-info">Download CSV</a>
          <div class="col-md-2">Total: {{ $r->count() }}</div>
          <div class="table-responsive">
              <table id="dataTable" class="table table-bordered">
                  <thead>
                      <tr>
                          <th scope="col" style="min-width: 220px"> Token
                          </th>
                          <th scope="col" class="col">
                              C.ID
                          </th>
                          <th scope="col" class="col">Username</th>
                          <th scope="col" class="col">Creator</th>
                          <th scope="col" class="col">
                              Package
                          </th>
                          <th scope="col" class="col">
                              Reseller
                          </th>
                          <th scope="col" class="col">
                              POP
                          </th>
                          <th scope="col" class="col" style="min-width: 180px">
                              Date
                          </th>
                          <th scope="col" class="col" style="min-width: 110px">
                              Code
                          </th>
                          <th scope="col" class="col">
                              Description</th>
                          <th scope="col" class="col">Source</th>
                          <th scope="col" class="col">Reporter</th>
                          <th scope="col" class="col">
                              Assigned
                          </th>
                          <th scope="col" class="col" style="min-width: 110px">
                              Status
                          </th>
                          <th scope="col" class="col" style="min-width: 110px">
                              Remarks/Close Reason
                          </th>
                          <th scope="col" class="col">
                              Closer
                          </th>
                          <th scope="col" class="col">
                              R.Contact
                          </th>
                          <th>
                              Remote
                          </th>
                          <th>
                              Auto Reboot
                          </th>
                      </tr>
                  </thead>
                  <tbody>
                      {{-- @dd($r) --}}
                      @foreach ($r as $item)
                          <tr>
                              <td class="d-none token_id_of_table">{{ $item->id }}</td>
                              <td style="padding-left: 2px;padding-right: 2px;max-width:150px">
                                  <span class="badge badge-success"> T.ID : </span> {{ $item->token }} <br>
                                  <span class="badge badge-info"> C.T : </span>
                                  {{ date('d-M-Y g:i: a ', strtotime($item->created_at)) }} <br>
                                  @if ($item->assign_time)
                                      <span class="badge badge-warning"> A.T : </span>
                                      {{ date('d-M-Y g:i: a ', strtotime($item->assign_time)) }} <br>
                                      @if ($item->close_time)
                                          <span class="badge badge-danger"> C.T : </span>
                                          {{ date('d-M-Y g:i: a ', strtotime($item->close_time)) }} <br>
                                      @else
                                          {{ $item->close_time ? 'Closed' . dateTimeDifferent(now(), $item->assign_time) : 'Token Assigned ' . dateTimeDifferent(now(), $item->assign_time) . ' ago Not Closed' }}
                                          <br>
                                      @endif
                                  @else
                                      {{ $item->assign_time ? 'Assigned' . dateTimeDifferent(now(), $item->created_at) : 'Token Created ' . dateTimeDifferent(now(), $item->created_at) . ' ago Not assigned' }}
                                      <br>
                                  @endif
                                  <span class="badge badge-dark add_note" role="button" data-toggle="modal"
                                      data-target="#addNoteModel"> Show Note</span> <br>
                              </td>
                              <td>{{ $item->clientId }}</td>
                              <td>{{ $item->userid }}</td>
                              <td>
                                  {{ $item->createBy }}
                                  @if ($item->createByClient ?? '')
                                      <span class="badge badge-danger">{{ $item->createByClient ?? '' }}</span>
                                  @endif
                              </td>
                              <td>
                                  {{ $item->package_name }}
                              </td>
                              <td>
                                  {{ $item->reseller }}
                              </td>
                              <td>
                                  {{ $item->popname }}
                              </td>
                              <td>
                                  {{ date('d-M-Y g:i: a ', strtotime($item->created_at)) }}
                              </td>
                              <td>
                                  {{ $item->code }}
                              </td>
                              <td>
                                  {{ $item->description }}</td>
                              <td>
                                  @if ($item->token_source == 'CRM')
                                      <span class="btn btn-info btn-xs">{{ $item->token_source }}</span>
                                  @else
                                      {{ $item->token_source }}
                                  @endif
                              </td>
                              <td>
                                  {{ $item->reportedBy }}
                              </td>
                              <td>
                                  {{ $item->employee }}
                              </td>
                              <td>
                                  @if ($item->status == 'Active')
                                      {{ 'Open' }}
                                  @else
                                      {{ 'Closed' }}
                                      @if ($item->close_time)
                                          <br> Token close time :
                                          {{ dateTimeDifferent($item->close_time, $item->created_at) }}
                                      @endif
                                  @endif

                              </td>
                              <td>
                                  {{ $item->remarks }} <br> <span class="badge badge-info">P Loss:</span>
                                  {{ $item->ping_loss }} <br> <span class="badge badge-info">O Power:</span>
                                  {{ $item->optical_power }}
                              </td>
                              <td>
                                  {{-- {{ $item->closer->name ?? '' }} --}}
                                  {{ $item->closedBy }}
                              </td>
                              <td>
                                  {{ $item->reporterContact }}
                              </td>
                              <td>
                                  @if ($item->remote == 1)
                                      <span class="badge badge-success">Yes</span>
                                  @else
                                      <span class="badge badge-danger">No</span>
                                  @endif
                              </td>
                              <td>
                                  @if ($item->autoreboot == 1)
                                      <span class="badge badge-success">Yes</span>
                                  @else
                                      <span class="badge badge-danger">No</span>
                                  @endif
                              </td>
                          </tr>
                      @endforeach
                  </tbody>
              </table>
          </div>

          {{-- <div class="p-5">
                        {{ $list->links() }}
        </div> --}}
      </div>
      <div class="modal fade" id="addNoteModel" tabindex="-1" role="dialog" aria-labelledby="closeTokenModel"
          aria-hidden="true">
          <div class="modal-dialog modal-xl" role="document">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title" id="exampleModalLabel">Add Note</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body">
                      <div class="table-responsive" style="height: 300px">
                          <table id="token_note_table" class="table table-bordered">
                              <thead class="bg-dark">
                                  <tr>
                                      <th style="max-width: 100px">Id</th>
                                      <th style="max-width: 100px">Note For</th>
                                      <th style="max-width: 100px">Created Time</th>
                                      <th>Remark</th>
                                      <th>Created By</th>
                                      @can('token-note-delete')
                                          <th style="max-width: 100px">Action</th>
                                      @endcan
                                  </tr>
                              </thead>
                              <tbody>

                              </tbody>
                          </table>
                      </div>

                  </div>
                  <div class="modal-footer">
                  </div>
              </div>
          </div>
      </div>
  </div>
