<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CompanyInfoSeeder extends Seeder
{

    public function run()
    {
        $seederCheck = DB::table('company_information')->count();
        if ($seederCheck <= 0) {

            $data = [
                ["type" => "expire_time", "value" => "0:0:00"],
                ["type" => "deactive_after", "value" => "0"],
                ["type" => "billing_type", "value" => "monthly"],
                ["type" => "expire_sms_send_time", "value" => "11:30"],
                [
                    "type" => "customer_panel_api",
                    "value" => [
                        "customer_panel_url" => "client-list.yetfix.com",
                        "customer_panel_secret" => null
                    ]
                ]
            ];

            DB::table('company_information')->insert([
                'name' => 'Company Name',
                'email' => 'admin@company.com',
                'img_url' => '',
                'mobile' => '0123456789',
                'address' => 'Dhaka',
                'mikrotik_conection_type' => 'api',
                'sync_time_in_secconds' => 300,
                'max_extended_day' => 30,
                'settings' => json_encode($data)

            ]);
        }
    }
}
