@extends('layout.app')

@section('content')
    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="subPackagesTable" class="table table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col">
                                        ID
                                    </th>
                                    <th scope="col">
                                        Package Name
                                    </th>
                                    {{-- @if (in_array('show-sub-package-rate', $permissions))
                                        <th scope="col">
                                            Package Rate
                                        </th>
                                    @endif --}}

                                    @canany(['show-sub-package-rate', 'specific_management_services'])

                                        <th scope="col">
                                            Package Rate
                                        </th>
                                    @endcan
                                    @canany(['show-sub-package-rate', 'specific_management_services'])
                                        @if (checkSettings('ResellerClientOnlineRecharge') == 'enable' && checkSettings('setClientPaymentAmountToClient') != 'enable' )
                                            <th scope="col">
                                                Client payment amount
                                            </th>
                                        @endif
                                    @endcan

                                    @if (in_array('show-mother-package', $permissions))
                                        <th scope="col">
                                            Manager Name
                                        </th>
                                    @endif
                                    @if (in_array('show-mother-package', $permissions))
                                        <th scope="col">
                                            Mother Package
                                        </th>
                                    @endif

                                    @if (in_array('show-motherpackage-rate', $permissions))
                                        <th scope="col">
                                            Mother Package Rate
                                        </th>
                                    @endif
                                    @if (in_array('sub-pack-commission', $permissions))
                                        <th scope="col">
                                            Commission
                                        </th>
                                    @endif
                                    <th scope="col">

                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <tr>
                                    <td colspan="100%" class="text-center">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </div>
                                        <p class="mt-2">Loading sub packages...</p>
                                    </td>
                                </tr>
                            </tbody>

                        </table>
                    </div>

                    <div class="p-5">
                        {{-- {{ $sub_packages->links() }} --}}
                    </div>
                </div>
            </div>
        </div>
    </div>


    {{-- <x-Custom.modal modalTitle="Reseller Recharge">
    <x-Custom.inputGroup inputName="amount" labelName="Amount" labelIcon="" placeholder="0" inputType="number" required="required"/>
    <x-Custom.formUpdateBtn value="Recharge" class="float-right bg-blue-300 mt-2"/>
  </x-Custom.modal> --}}
@endsection


@section('ajax')
    <script type="text/javascript">
        (function() {
            'use strict';

            function initDataTable() {
                var $table = $('#subPackagesTable');

                if (!$table.length) {
                    console.error('Table #subPackagesTable not found');
                    return;
                }

                // Destroy existing DataTable instance if it exists
                if ($.fn.DataTable && $.fn.DataTable.isDataTable($table)) {
                    try {
                        $table.DataTable().destroy();
                    } catch(e) {
                        console.log('Error destroying table:', e);
                    }
                }

                // Clear tbody
                $table.find('tbody').empty();

                var columns = @json($columns);

                try {
                    $table.DataTable({
                        processing: true,
                        serverSide: false,
                        ajax: {
                            url: "{{ route('sub-packages.ajax') }}",
                            type: "GET",
                            dataSrc: "data",
                            error: function(xhr, error, code) {
                                console.log('AJAX Error:', error, code);
                                if (xhr.responseText) {
                                    console.log('Response:', xhr.responseText);
                                }
                            }
                        },
                        columns: columns,
                        order: [[0, 'asc']],
                        pageLength: 25,
                        language: {
                            processing: "<div class='spinner-border text-primary' role='status'><span class='sr-only'>Loading...</span></div> Loading sub packages...",
                            emptyTable: "No sub packages found"
                        },
                        drawCallback: function(settings) {
                            // Re-initialize delete confirmation after table redraw
                            $table.find('form.delete-subpackage-form').off('submit').on('submit', function(e) {
                                if (!confirm('Do you really want to Delete?')) {
                                    e.preventDefault();
                                    return false;
                                }
                                return true;
                            });
                        }
                    });
                } catch(e) {
                    console.error('Error initializing DataTable:', e);
                }
            }

            // Initialize when document is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', initDataTable);
            } else {
                // DOM is already ready
                $(document).ready(initDataTable);
            }
        })();
    </script>
@endsection
