<?php
namespace App\Http\Controllers;

use App\Models\Client;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;

class MultipleCustomerPaymentController extends Controller
{
    public function multipleCustomerPayment(Request $request)
    {

        if (empty($request->ids) || count($request->ids) <= 0) {
            Toastr::error("Please Select Customer");
            return redirect()->back();
        }

        if (!$request->collectedBy) {
            Toastr::error("Please Select Employee");
            return redirect()->back();
        }

        $date = new DateTime();
        $thisMonthName = $date->format('F');
        $created_at = Carbon::parse($date)->format('Y-m-d');

        $allErrorMessage = [];
        foreach ($request->ids as $clientId) {
            $client = Client::with('pop', 'packages', 'customerAccount')->find($clientId);
            $billGenerate = $client->pop->bill_generate == 'yes';

            if ($billGenerate) {
                if (getBillingType() === 'day_to_day') {
                    $amount = $client->packages->package_rate;
                } else {
                    $amount = $client->customerAccount->dueAmount > 0 ? $client->customerAccount->dueAmount : 0;
                }

                if ($amount > 0) {
                    $newRequest = new Request();
                    $newRequest->merge([
                        "client_id"           => $clientId,
                        "id"                  => $clientId,
                        "month"               => $thisMonthName,
                        "created_at"          => $created_at,
                        "description"         => $request->paymentDescription,
                        "collected_by"        => $request->collectedBy,
                        "payment_type"        => "5",
                        "discount"            => null,
                        "amount"              => $amount,
                        "money_receipt_number"=> null,
                        "sms"                 => $request->smsSend,
                        "bill_amount"         => $amount,
                        "bank_account_id"     => $request->bank_account_id ?? null,
                    ]);



                    $paymentController = new PaymentController();
                    $response = $paymentController->paymentprocess($newRequest);
                    $responseContent = $response->getContent();
                    $decodedResponse = json_decode($responseContent, true);

                    // Check for error in response
                    if ($decodedResponse['status'] == "error") {
                        $error = [
                            'id' => $clientId,
                            'message' => $decodedResponse['message'],
                        ];
                        $allErrorMessage[] = $error;
                        break;
                    }
                }
            }
        }

        return response()->json([
            'errors' => $allErrorMessage, // Return errors if any
        ]);
    }
}
