@extends('layout.app')
@section('content')

<div class="flex flex-col mt-2">
    <div class=" bg-white p-2 rounded-lg">
        <form action="{{ route('token.update',$token->id) }}" method="POST" name="editForm">
            @method('PUT')
            @csrf
            <div class="border-2 mb-2">

                <div class="bg-blue-100 block pt-4 p-5">
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label class="block text-sm font-medium text-gray-700">Token Category <span
                                    class="required">*</span></label>
                            <select class="form-control bSelect" name="tokenCategory">
                                <option value="">Select Token Category</option>
                                @forelse ($tokenCategory as $item)
                                <option value="{{ $item->id }}">{{ $item->tokenCategory }}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>
                    <br>
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label class="block text-sm font-medium text-gray-700">Token Code <span
                                    class="required">*</span></label>
                            <select class="form-control bSelect" name="tokenCode">
                                <option value="">Select Token Code</option>
                                @forelse ($tokenCode as $item)
                                <option value="{{ $item->id }}">{{ $item->tokenCode }}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>
                    <br>
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label for="name" class="block text-sm font-medium text-gray-700">
                                Description*
                            </label>
                            <div class="mt-1 flex rounded-md shadow-sm">

                                <input type="text" name="description" id="name" value="{{ $token->description }}"
                                    class="flex-1 block w-full rounded-none rounded-r-md sm:text-sm border-gray-300 "
                                    placeholder="Description" autocomplete="off">
                            </div>
                            @error('description')
                            <div class="text-red-500 mt-2 text-sm">
                                {{$message}}</div>
                            @enderror
                        </div>
                    </div>
                    <br>
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label for="name" class="block text-sm font-medium text-gray-700">
                                Reported By*
                            </label>
                            <div class="mt-1 flex rounded-md shadow-sm">

                                <input type="text" name="reportedBy" id="name" value="{{ $token->reportedBy }}"
                                    class="flex-1 block w-full rounded-none rounded-r-md sm:text-sm border-gray-300 "
                                    placeholder="Reported By" autocomplete="off">
                            </div>
                            @error('reportedBy')
                            <div class="text-red-500 mt-2 text-sm">
                                {{$message}}</div>
                            @enderror
                        </div>
                    </div>
                    <br>
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label for="name" class="block text-sm font-medium text-gray-700">
                                Reporter Contact No*
                            </label>
                            <div class="mt-1 flex rounded-md shadow-sm">

                                <input type="text" name="reporterContact" id="name" value="{{ $token->reporterContact }}"
                                    class="flex-1 block w-full rounded-none rounded-r-md sm:text-sm border-gray-300 "
                                    placeholder="Reporter Contact No" autocomplete="off">
                            </div>
                            @error('reporterContact')
                            <div class="text-red-500 mt-2 text-sm">
                                {{$message}}</div>
                            @enderror
                        </div>
                    </div>
                    <br>
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label class="block text-sm font-medium text-gray-700">Assign Token  <span
                                    class="required">*</span></label>
                            <select class="form-control bSelect" name="assignToken">
                                <option value="">Select Employee</option>
                                @forelse ($employees as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>
                    <br>
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label class="control-label"> Status</label>
                            <select class="form-control bSelect" v-model="status" name="status">
                                <option value="">Select Status</option>
                                <option value="Active">Active</option>
                                <option value="Inactive">Inactive</option>
                            </select>
                        </div>
                    </div>
                    <br>
                    <br>
                    <div class="grid md:grid-cols-2 gap-2">
                        <div class="grid grid-cols-3">
                            <label class="control-label">Remarks</label>
                            <textarea class="form-control" name="remarks" rows="1"
                                placeholder="Enter Remarks">{{ $token->remarks }}</textarea>
                        </div>
                    </div>
                    <br>
                    <div class="grid grid-cols-2 p-2">
                        <div>
                            <div class="flex justify-end">
                                <button class="inline-block px-6 py-2 text-white bg-blue-600 float-right mr-2 mb-2"
                                    type="submit"><i class="fa fa-save"></i> Update
                                </button>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    </div>
</div>


<script>
    document.forms['editForm'].elements['tokenCategory'].value='{{ $token->tokenCategory }}'
    document.forms['editForm'].elements['tokenCode'].value='{{ $token->tokenCode }}'
    document.forms['editForm'].elements['assignToken'].value='{{ $token->assignToken }}'
    document.forms['editForm'].elements['status'].value='{{ $token->status }}'
</script>

@endsection