@extends('layout.app')

@section('content')

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;"><i class="fa fa-search"></i> Select Criteria
                            </h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            {{-- <div class="row"> --}}
                            <form action="" id="search">
                                <div class="row">
                                    {{-- <div class="ml-3 row"> --}}
                                    {{-- <div class="col-sm-4">
                                            From Date
                                            <input type="date" name="from_date" class="form-control "
                                                placeholder="YYYY-MM-DD" required="">
                                        </div> --}}
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                                From Date
                                            </label>
                                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                                <input type="text" name="from_date" value="{{$start->format('m/d/y')}}"
                                                    class="form-control datetimepicker-input input-group-append"
                                                    data-toggle="datetimepicker" data-target="#searchFrom"
                                                    autocomplete="off">

                                            </div>
                                        </div>
                                    </div>
                                    {{-- <div class="col-sm-4">
                                            To Date
                                            <input type="date" name="to_date" class="form-control "
                                                placeholder="YYYY-MM-DD" required="">
                                        </div> --}}
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                                To Date
                                            </label>
                                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                                <input type="text" name="to_date" value="{{$end->format('m/d/y')}}"
                                                    class="form-control datetimepicker-input input-group-append"
                                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                    {{-- <div class="col-sm-2">
                                            <button @click="search" type="submit" id="searchBtn"
                                                class="btn btn-info byn-block form-control ">
                                                Search
                                            </button>
                                        </div> --}}
                                    <div class="col-md-12">
                                        <div class="form-group float-right mt-2">
                                            {{-- <button @click="search" type="submit" id="searchBtn"
                                                class="btn btn-info byn-block form-control ">
                                                Search
                                            </button> --}}
                                            <button @click="search" class="btn btn-primary" type="submit"
                                                    id="searchBtn"><i class="fa fa-search"></i> Search</button>
                                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                                        </div>
                                    </div>

                                    {{-- <div class="col-sm-2">
                                            <button class="btn btn-warning byn-block form-control mt-4" type="reset"
                                                id="reset">Reset
                                            </button>
                                        </div> --}}
                                    {{-- </div> --}}
                                </div>
                            </form>
                            {{-- </div> --}}
                            <br>
                            <div class="col-md-12" id="result">
                                <div class="col-sm-12">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="card p-2">
                                                <div class="table-responsive">

                                                    <table class="table" style="width:100%">
                                                        <thead style="width:100%">

                                                            <tr class="bg-dark">
                                                                <th >Income Details</th>
                                                                <th style="text-align: right">Amount</th>

                                                            </tr>

                                                        </thead>

                                                        <tbody>
                                                            <tr>
                                                                <td>Openig balance</td>
                                                                <td style="text-align: right">{{number_format($previous_income, 2, '.', '')}}</td>
                                                            </tr>
                                                            @php
                                                                $income_sum =0;
                                                            @endphp
                                                            @foreach ($incomes as $key=>$item)
                                                                @php
                                                                    $income_sum += $item->sum('amount');
                                                                @endphp
                                                                @if ($item->sum('amount') > 0)

                                                                    <tr>
                                                                        <td>{{$income_head_with_sash[$key]}}</td>
                                                                        <td style="text-align: right">{{number_format($item->sum('amount'), 2, '.', '')}}</td>
                                                                    </tr>
                                                                @endif
                                                            @endforeach
                                                            <tr>

                                                                <td class="text-left"><strong>Total Income</strong></td>
                                                                <td class="text-right"> <strong>{{number_format($income_sum + $previous_income, 2, '.', '')}} TK</strong></td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>




                                        <div class="col-sm-6">
                                            <div class="card p-2">
                                                <div class="table-responsive">

                                                    <table class="table" style="width:100%">
                                                        <thead style="width:100%">

                                                            <tr class="bg-dark">
                                                                <th >Expense Details</th>

                                                                <th class="text-right">Amount</th>


                                                            </tr>
                                                        </thead>

                                                        <tbody>
                                                            <tbody>
                                                                <tr>
                                                                    <td>Openig balance</td>
                                                                    <td style="text-align: right">{{number_format($previous_expense, 2, '.', '')}}</td>
                                                                </tr>
                                                                @php
                                                                    $expense_sum =0;
                                                                @endphp
                                                                @foreach ($expenses as $key=>$item)
                                                                    @php
                                                                        $expense_sum += $item->sum('amount');
                                                                    @endphp
                                                                    @if ($item->sum('amount') > 0)

                                                                        <tr>
                                                                            <td>{{$expense_head_with_sash[$key]}}</td>
                                                                            <td style="text-align: right">{{number_format($item->sum('amount'), 2, '.', '')}}</td>
                                                                        </tr>
                                                                    @endif
                                                                @endforeach
                                                                <tr>

                                                                    <td class="text-left"><strong>Total Expense</strong></td>
                                                                    <td class="text-right"> <strong>{{number_format($expense_sum + $previous_expense, 2, '.', '')}} TK</strong></td>
                                                                </tr>
                                                            </tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-sm-12">
                                        <div class="card p-2">
                                            <div class="table-responsive">

                                                <table class="table" style="width:100%">
                                                    <thead style="width:100%">
                                                        <tr style="text-align: right" >
                                                            <td class="bg-info"></td>
                                                            <td class="bg-info">Total Income: {{number_format($income_sum + $previous_income, 2, '.', '')}} TK</td>
                                                            <td class="bg-info">Total Expense: {{number_format($expense_sum + $previous_expense, 2, '.', '')}} TK</td>
                                                            <td class="bg-info">Current Amount: {{ number_format(($previous_income - $previous_expense + $income_sum - $expense_sum), 2, '.', '')}} Tk</td>
                                                        </tr>
                                                        <tr style="text-align: right" >
                                                            <td class="bg-secondary"></td>
                                                            <td class="bg-secondary">Total Income: ({{$start->format('m/d/y')}} - {{$end->format('m/d/y')}}) {{number_format($income_sum , 2, '.', '')}} TK</td>
                                                            <td class="bg-secondary">Total Expense: ({{$start->format('m/d/y')}} - {{$end->format('m/d/y')}}) {{number_format($expense_sum , 2, '.', '')}} TK</td>
                                                            <td class="bg-secondary">Current Amount: ({{$start->format('m/d/y')}} - {{$end->format('m/d/y')}}) {{ number_format(($income_sum - $expense_sum), 2, '.', '')}} Tk</td>
                                                        </tr>

                                                    </thead>

                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('js')

@endsection
@push('script')
    <!-- page script -->

@endpush

@section('ajax')
    <script type="text/javascript">
        //console.log('error');
        $(document).ready(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });

            // $.get("{{ route('accountStatementSearch') }}", function(data) {
            //     $('#result').html(data);
            // });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('accountStatementSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        console.log(result);
                        $('#result').html(result);
                    }
                });
            });
            //alert(result);
            $('#details').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('accountStatementSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                    }
                });
            });


        });
    </script>

@endsection
