@extends('layout.app')
@section('content')
    <h1>{{ $nas->id }}. {{ $nas->shortname }} ({{ $nas->nasname }})</h1>
    <table class="table">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Name</th>
                <th scope="col">Password</th>
                <th scope="col">Profile</th>
                <th scope="col">Caller ID</th>
                <th scope="col">Disabled</th>
                <th scope="col">Last Logged Out</th>
                <th scope="col">Last Disconnect Reason</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($secrets as $secret)
                @if ($secret['service'] == 'pptp')
                    @continue
                @endif
                <tr class="{{ $secret['disabled'] == 'true' ? 'table-warning' : '' }}">
                    <th scope="row">{{ $secret['.id'] }}</th>
                    <td>{{ $secret['name'] }}</td>
                    <td>{{ $secret['password'] }}</td>
                    <td>{{ $secret['profile'] }}</td>
                    <td>{{ $secret['caller-id'] }}</td>
                    <td>{{ $secret['disabled'] }}</td>
                    <td>{{ $secret['last-logged-out'] }}</td>
                    @if (isset($secret['last-disconnect-reason']))
                        <td>{{ $secret['last-disconnect-reason'] }}</td>
                    @endif
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
