<?php

namespace App\Jobs;

use App\Http\Controllers\ResellerBillPaymentController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ResellerClientBillPaymentSyncJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $client_id;
    public function __construct($client_id)
    {
        $this->client_id = $client_id;
    }
   

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        (new ResellerBillPaymentController())->resellerClientPaymentSync($this->client_id);
    }
}
