<?php

namespace App\Http\Controllers;

use App\Models\Item;
use App\Models\Unit;
use Illuminate\Support\Str;
use App\Models\ItemCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ItemController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:inventory_index|inventory_create',['only' => ['index']]);
        $this->middleware('permission:inventory_create',['only' => ['create']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Item::get();
        return view('item.index',[
            'page_title' => 'Item  List',
            'list' => $list,
            'url' => route('item.create'),
            'add_button' => 'true',
            'class' => 'btn btn-primary',
            'value' => 'Add New Item '
             ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = ItemCategory::all();
        $units = Unit::all();
        return view('item.create',[
            'page_title'=> 'Add New Item',
            'units'        => $units,
            'categories'        => $categories
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:items',
            'category_id' => 'required',
            'unit_id' => 'required',
            'short_name' => 'nullable',
            'remarks' => 'nullable',
            'alert_quantity' => 'required',
        ]);

        $item = new Item();
        $item->fill($request->all());

        $item->creator_user_id = Auth::id();
        $item->save();

        $item->slug =  $item->id.'/'.Str::slug($request->name);
        $item->code = $item->id;
        $item->save();

        $request->session()->flash('success_message', 'Item Added successfull');
        return redirect()->route('item.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function show(Item $item)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function edit(Item $item)
    {
        $categories = ItemCategory::all();
        $units = Unit::all();
        return view('item.update',[
            'list' => $item,
            'page_title' => 'Update Item Information',
            'units'        => $units,
            'categories'        => $categories
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Item $item)
    {
        // dd($request->all());
        $this->validate($request, [
            'name' => 'required|unique:items,name,' . $item->id,
            'category_id' => 'required',
            'unit_id' => 'required',
            'short_name' => 'nullable',
            'remarks' => 'nullable',
            'alert_quantity' => 'required',
        ]);
        $item->fill($request->all());
        $item->updator_user_id = Auth::id();
        $item->save();

        if($request->show_crm){
            $item->show_crm = $request->show_crm;
            $item->save();
        }
        $request->session()->flash('success_message', 'Item Updated successfull');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function destroy(Item $item)
    {
        //
    }
}
