@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">

            <button class="btn btn-primary" onclick="window.print()"><i class="fa fa-print"></i>Print</button>

            <div class="mt-3">
                <a class="" href="{{ url()->previous() }}"> <i class="fa fa-arrow-left"></i> Back</a>

                <div class="mt-2">
                    <h5>Requisition Information</h5>
                    <table id="dataTable" class="table table-bordered">
                        <tr>
                            <th colspan="6" class="text-center">Requisition No#{{ $requisition->requisition_number }}
                            </th>
                        </tr>
                    </table>
                    <h5>Items</h5>
                    <table id="dataTable" class="table table-bordered">
                        <tr>
                            <th>Item</th>
                            <th>Category</th>
                            <th>Unit</th>
                            <th>Quantity</th>
                        </tr>
                        @foreach ($requisition->items as $row)
                            <tr>
                                <td>{{ $row->item->name ?? '' }}</td>
                                <td>{{ $row->item->category->name ?? '' }}</td>
                                <td>{{ $row->item->unit->name ?? '' }}</td>
                                <td>{{ $row->quantity ?? '' }}</td>
                            </tr>
                        @endforeach
                        <tr>
                            <th>Remarks</th>
                            <td colspan="5">{{ $requisition->remark ?? '' }}</td>
                        </tr>
                    </table>
                </div>
                @if ($requisition->requisitionApprove)
                    <div class=" ">
                        <h5>Requisition Approve Information</h5>
                        <table id="dataTable" class="table table-bordered">
                            <tr>
                                <th colspan="6" class="text-center">Requisition Approve
                                    No#{{ $requisition->requisitionApprove->requisition_approve_number ?? '' }}</th>
                            </tr>
                        </table>
                        <h5>Items</h5>
                        <table id="dataTable" class="table table-bordered">
                            <tr>
                                <th>Item</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th>Quantity</th>
                            </tr>
                            @php
                                $a_items = $requisition->requisitionApprove->items ?? '';
                            @endphp
                            @foreach ($a_items as $row)
                                <tr>
                                    <td>{{ $row->item->name ?? '' }}</td>
                                    <td>{{ $row->item->category->name ?? '' }}</td>
                                    <td>{{ $row->item->unit->name ?? '' }}</td>
                                    <td>{{ $row->quantity ?? '' }}</td>
                                </tr>
                            @endforeach
                            <tr>
                                <th>Remarks</th>
                                <td colspan="5">{{ $requisition->requisitionApprove->remark ?? '' }}</td>
                            </tr>
                        </table>
                    </div>
                @endif
            </div>
        </div>
    </div>



@endsection
