<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class ModifyBandPurchasesTableWithCurrentThoght extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('band_purchases', function (Blueprint $table) {
            // if (Schema::hasColumn('band_purchases', 'bill_no')) {
            //     $table->renameColumn('bill_no', 'invoice_no');
            // }

            if (Schema::hasColumn('band_purchases', 'service_id')) {
                $table->dropColumn('service_id');
            }

            if (Schema::hasColumn('band_purchases', 'quantity')) {
                $table->dropColumn('quantity');
            }

            if (Schema::hasColumn('band_purchases', 'rate')) {
                $table->dropColumn('rate');
            }

            if (Schema::hasColumn('band_purchases', 'vat')) {
                $table->dropColumn('vat');
            }

            if (Schema::hasColumn('band_purchases', 'from_date')) {
                $table->dropColumn('from_date');
            }

            if (Schema::hasColumn('band_purchases', 'to_date')) {
                $table->dropColumn('to_date');
            }

            if (Schema::hasColumn('band_purchases', 'bill_no')) {
                $table->dropColumn('bill_no');
            }

            // $table->text('document')->nullable();
            $table->decimal('total_price', 10, 2)->nullable();
            $table->decimal('paid', 10, 2)->nullable();
            $table->string('invoice_no', 10, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('band_purchases', function (Blueprint $table) {
          

            if (!Schema::hasColumn('band_purchases', 'service_id')) {
                $table->foreignId('service_id')->constrained();
            }

            if (!Schema::hasColumn('band_purchases', 'quantity')) {
                $table->text('quantity');
            }

            if (!Schema::hasColumn('band_purchases', 'rate')) {
                $table->decimal('rate', 10, 2);
            }

            if (!Schema::hasColumn('band_purchases', 'vat')) {
                $table->decimal('vat', 10, 2);
            }

            if (!Schema::hasColumn('band_purchases', 'from_date')) {
                $table->dateTime('from_date');
            }

            if (!Schema::hasColumn('band_purchases', 'to_date')) {
                $table->dateTime('to_date');
            }
            if (!Schema::hasColumn('band_purchases', 'bill_no')) {
                $table->string('bill_no');
            }

            $table->dropColumn(['total_price', 'paid','invoice_no']);
        });
    }
}
