@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('resellers.update', $reseller->id) }}" method="POST" enctype="multipart/form-data"
                id="resellerForm">
                @method('PUT')
                @csrf
                <div class="row" style="@cannot('reseller_edit')display:none @endcannot">
                    <div class="form-group col-md-4">


                        <label for="name">
                            Manager Name*
                        </label>
                        <input type="text" name="name" id="name" value="{{ $reseller->name }}"
                            class="form-control" required placeholder="Manager Name" autocomplete="off">

                        @error('name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="reseller_type" class="block text-sm font-medium text-gray-700">
                            Manager Type*
                        </label>
                        <select name="reseller_type" id="reseller_type" class="select2 form-control" required>
                            <option value="">Select Type</option>
                            <option value="other" {{ $reseller->reseller_type == 'other' ? 'selected' : '' }}>
                                Other</option>
                            <option value="own" {{ $reseller->reseller_type == 'own' ? 'selected' : '' }}>
                                Own</option>

                        </select>
                    </div>

                    <div class="form-group col-md-4">

                        <label for="contact" class="block text-sm font-medium text-gray-700">
                            Contact*
                        </label>


                        <input type="text" name="contact" id="contact" class="form-control" placeholder="Contact"
                            value="{{ $reseller->contact }}" autocomplete="off" required>

                        @error('contact')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="address">
                            Address*
                        </label>

                        <input type="text" name="address" id="address" class="form-control" placeholder="Address"
                            value="{{ $reseller->address }}" autocomplete="off" required>
                        @error('address')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="remark">
                            Remark
                        </label>
                        <input type="text" name="remark" id="remark" class="form-control" placeholder="remark"
                            value="{{ $reseller->remark }}" autocomplete="off">

                        @error('remark')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    @if (checkSettings('manager_status') == 'enable')
                        <div class="form-group col-md-4">
                            <label for="status">
                                Status
                            </label>
                            <select name="status" id="status" class="form-control">
                                <option value="active" {{ $reseller->status == 'active' ? 'selected' : '' }}>Active
                                </option>
                                <option value="inactive" {{ $reseller->status == 'inactive' ? 'selected' : '' }}>Inactive
                                </option>
                            </select>
                            @error('status')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    @endif
                    <div class="d-none col-md-4">
                        <div class="col-span-3 sm:col-span-2">
                            <label for="billable" class="block text-sm font-medium text-gray-700">
                                Billable
                            </label>
                            <div class="mt-1 flex rounded-md shadow-sm">

                                <select name="billable" id="billable">
                                    <option value="yes" @if ($reseller->billable === 'yes') selected @endif>YES</option>
                                    <option value="no" @if ($reseller->billable === 'no') selected @endif>No</option>
                                </select>
                            </div>
                            @error('billable')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    @if (checkSettings('reseller-image') == 'enable')
                        @can('reseller-image-upload')
                            <div class="form-group col-md-4">

                                @if (checkSettings('store_image_to_s3') == 'enable')
                                    <img width="auto" height="100" src="{{ $reseller->img_url }}" alt="No Image">
                                @else
                                    <img width="auto" height="100"
                                        src="{{ asset('storage/reseller/' . $reseller->img_url) }}" alt="No Image">
                                @endif

                                <label for="name" class="block text-sm font-medium text-gray-700">
                                    Upload File
                                </label>
                                <input type="file" name="img_url" value="{{ old('img_url') }}" class="form-control"
                                    placeholder="image" autocomplete="off" accept="image/*">
                                @error('img_url')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        @endcan
                    @endif
                    @if (checkSettings('manager-commission-percentage') === 'enable')
                        @can('update-manager-commission')
                            <div class="form-group col-md-4">
                                <label for="remark" class="block text-sm font-medium text-gray-700">
                                    Manager Miscellaneous Expense
                                </label>
                                <div class=" flex rounded-md shadow-sm">

                                    <input type="number" step=".01" name="commission_percentage"
                                        id="commission_percentage" class="form-control"
                                        placeholder="Commission in percentage" value="{{ $reseller->commission_percentage }}"
                                        autocomplete="off">
                                </div>
                                @error('commission_percentage')
                                    <div class="alert alert-dangers">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        @endcan
                    @endif

                    @if (checkSettings('manager_bank_info') === 'enable')
                        <div class="form-group col-md-4">
                            <label for="bank_name" class="block text-sm font-medium text-gray-700">
                                Bank Name
                            </label>
                            <div class=" flex rounded-md shadow-sm">
                                <input type="text" name="bank_name" id="bank_name" class="form-control"
                                    placeholder="Bank Name" value="{{ $reseller->bank_name }}" autocomplete="off">
                            </div>
                            @error('bank_name')
                                <div class="alert alert-dangers">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="branch_name" class="block text-sm font-medium text-gray-700">
                                Branch Name
                            </label>
                            <div class=" flex rounded-md shadow-sm">
                                <input type="text" name="branch_name" id="branch_name" class="form-control"
                                    placeholder="Branch Name" value="{{ $reseller->branch_name }}" autocomplete="off">
                            </div>
                            @error('branch_name')
                                <div class="alert alert-dangers">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="routing_number" class="block text-sm font-medium text-gray-700">
                                Routing Number
                            </label>
                            <div class=" flex rounded-md shadow-sm">
                                <input type="text" name="routing_number" id="routing_number" class="form-control"
                                    placeholder="Routing Number" value="{{ $reseller->routing_number }}"
                                    autocomplete="off">
                            </div>
                            @error('routing_number')
                                <div class="alert alert-dangers">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="bank_account_no" class="block text-sm font-medium text-gray-700">
                                Bank Account No
                            </label>
                            <div class=" flex rounded-md shadow-sm">
                                <input type="text" name="bank_account_no" id="bank_account_no" class="form-control"
                                    placeholder="Bank Account No" value="{{ $reseller->bank_account_no }}"
                                    autocomplete="off">
                            </div>
                            @error('bank_account_no')
                                <div class="alert alert-dangers">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="account_name" class="block text-sm font-medium text-gray-700">
                                Account Name
                            </label>
                            <div class=" flex rounded-md shadow-sm">
                                <input type="text" name="account_name" id="account_name" class="form-control"
                                    placeholder="Account Name" value="{{ $reseller->account_name }}" autocomplete="off">
                            </div>
                            @error('account_name')
                                <div class="alert alert-dangers">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    @endif

                </div>

                @if (checkSettings('reseller-online-recharge') == 'enable')
                    <hr class="d-block">
                    <div class="form-group col-md-4" style="@cannot('manager-accounts-edit')display: none @endcannot">
                        <label for="payment_charges">Gateway Charges%</label>

                        <table class="table">
                            <tr>
                                <td>Bkash</td>
                                <td>
                                    <input type="number" step="any" name="bkash_charges" id="bkash_charges"
                                        class="form-control" placeholder="Bkash Charges"
                                        value="{{ $payment->bkash_charges ?? 0 }}" autocomplete="off">
                                </td>
                            </tr>
                            <tr>
                                <td>Nagad</td>
                                <td>
                                    <input type="number" step="any" name="nagad_charges" id="nagad_charges"
                                        class="form-control" placeholder="Nagad Charges"
                                        value="{{ $payment->nagad_charges ?? 0 }}" autocomplete="off">
                                </td>
                            </tr>
                            <tr>
                                <td>Upay</td>
                                <td>
                                    <input type="number" step="any" name="upay_charges" id="upay_charges"
                                        class="form-control" placeholder="Upay Charges"
                                        value="{{ $payment->upay_charges ?? 0 }}" autocomplete="off">
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif

                <div class="form-group">
                    <button class="btn btn-primary float-right" type="submit"> Update</button>
                </div>



            </form>

        </div>
    </div>
@endsection
@section('ajax')
    <script>
        $(document).ready(function() {
            console.log('loaded');

            $('#resellerForm').on('submit', function(e) {
                e.preventDefault();

                var formData = new FormData(this);
                let resellerType = $('#reseller_type').val();

                // Validate commission if type is own
                if (
                    resellerType === 'own' &&
                    {{ auth()->user()->can('update-manager-commission') ? 'true' : 'false' }} &&
                    {{ checkSettings('manager-commission-percentage') === 'enable' ? 'true' : 'false' }}
                ) {
                    let commission = $('#commission_percentage').val();
                    if (!commission || commission <= 0) {
                        $('#commission_percentage').focus();
                        toastr.error('For Own type, Manager Miscellaneous Expense must be greater than 0.');
                        return;
                    }
                }

                // ✅ Use native submit() to avoid re-triggering the jQuery handler
                this.submit = HTMLFormElement.prototype.submit;
                this.submit();
            });

        });
    </script>
@endsection
