import { Col, Row, Table } from 'react-bootstrap';
import MapPort from './MapPort';

const MapPorts = ({ device, setDevice }) => {
  const onChangeHandler = (e, index) => {
    const { name, value } = e.target;
    const ports = [...device.ports];
    ports[index][name] = value;
    setDevice({ ...device, ports });
  };
  return (
    <Row>
      <Col lg={6}>
        {device.ports.length > 0 ? (
          <Table striped bordered hover>
            <thead>
              <tr>
                <th>Port Number</th>
                <th>Port Label</th>
                <th>Port Type</th>
                <th>Port Stream</th>
              </tr>
            </thead>
            <tbody>
              {device.ports.map((port, index) => (
                <MapPort
                  key={port.port_number}
                  port={port}
                  onChangeHandler={onChangeHandler}
                  index={index}
                />
              ))}
            </tbody>
          </Table>
        ) : (
          'No Ports To Map'
        )}
      </Col>
    </Row>
  );
};

export default MapPorts;
