@extends('layout.app')

@section('content')
    <div class="card">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="card-body">
            <form action="{{ route('client-source.update', $source->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text"
                                   class="form-control"
                                   id="name"
                                   name="name"
                                   value="{{ $source->name }}"
                                   autocomplete="off"
                                   required
                                   placeholder="Source name">
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary float-right">
                    Update
                </button>
            </form>
        </div>
    </div>
@endsection

