<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">

            <form action="" id="search">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                
                                <input type="text" name="from_date" value=""
                                    class="form-control form-control-sm datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                
                                <input type="text" name="to_date" value=""
                                    class="form-control form-control-sm datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="type">
                                Type
                            </label>
                            <div class="input-group date" id="type">
                                <select name="type" id="type" class="form-control form-control-sm">
                                    <option value="">Select One</option>
                                    <option value="">All</option>
                                    <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type); ?>"><?php echo e($type); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="contact">
                                Contact No
                            </label>
                            <div class="input-group date" id="contact">
                                <input type="text" name="contact" id="contact" value=""
                                    class="form-control form-control-sm " placeholder="Phone No" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2">

                        <div class="form-group float-right mt-4">
                            <button @click="search" class="btn btn-primary btn-sm" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>

                            <a href="<?php echo e(route('smsLog')); ?>" class="btn btn-info btn-sm">Reset</a>
                        </div>
                    </div>
                </div>
            </form>


            <div class="table-responsive" id="result">
                <div class="float-left">
                    <?php echo e($smsLog->links()); ?>

                </div>
                <table id="" class="display table table-bordered table-striped table-sm">
                    <thead class="bg-gray">
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Contact</th>
                            <th scope="col" style="max-width: 300px" >Message</th>
                            <th scope="col" >Type</th>
                            <th scope="col" style="max-width: 200px">Delivery Message</th>
                            
                            <th scope="col">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $smsLog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                            <tr>
                                <td><?php echo e($item->id); ?></td>
                                <td><?php echo e($item->contact); ?></td>
                                <td style="max-width: 300px"><?php echo e($item->message); ?></td>
                                <td><?php echo e($item->type); ?></td>

                                <td style="max-width: 200px;">
                                    <div class="" style="overflow-y: auto; max-height: 70px;">
                                        <?php echo $item->delivery_message; ?>

                                    </div>
                                </td>
                                
                                <td><?php echo e($item->created_at); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($smsLog->links()); ?>

            </div>
        </div>
        <div class="card-footer">

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('ajax'); ?>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });

        $(document).ready(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('smsLogSearchResult')); ?>',
                    data: $('#search').serialize(),
                    // alert(result);
                    success: function(result) {
                        console.log(result);
                        $('#result').html(result);

                        $('#processing').remove();
                        $('#dataTable').DataTable({
                            'destroy': true,
                        });
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/narayanpuronline/radius-circle/resources/views/sms/smsLog.blade.php ENDPATH**/ ?>