<?php $__env->startSection('content'); ?>
    <div class="card">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-recharge')): ?>
            <div class="card-body">
                <button type="button" class="btn btn-primary float-right poprecharge" data-toggle="modal"
                    data-target="#pop-recharge">
                    Pop Recharge
                </button>
            </div>
        <?php endif; ?>
        <div class="card-body">
            <div class="table-responsive pt-2 " id="result">
                <table id="dataTable" class="display table table-bordered " style="width: 100% !important">
                    <thead style="background:#78716c;color:#FFFFFF;">
                        <tr class="text-center">
                            <th scope="col">Id</th>
                            <th scope="col"> POP Name </th>
                            <?php if(checkSettings('pop-online-recharge') == 'enable'): ?>
                                <th></th>
                            <?php endif; ?>
                            <th scope="col"> Manager Name </th>
                            <th scope="col"> POP Location </th>
                            <?php if(auth()->check() && auth()->user()->hasAnyRole('Admin|Support Executive')): ?>
                                <th scope="col">NAS Server IP </th>
                            <?php endif; ?>
                            <th scope="col"> POP Contact </th>
                            <th scope="col"> Sub-Manager </th>
                            <?php if(auth()->check() && auth()->user()->hasRole('Admin|Support Executive')): ?>
                                <th scope="col">Bill Generate </th>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['show-pop-balance', 'specific_management_services'])): ?>
                                <th scope="col">Balance </th>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-disable')): ?>
                                <th scope="col">Pop Status</th>
                            <?php endif; ?>
                            <th scope="col"> Action </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php ($checkAPI = checkAPI()); ?>
                        <?php $__currentLoopData = $pop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($r->id); ?>

                                </td>
                                <td>
                                    <?php echo e($r->popname); ?>

                                </td>

                                <?php if(checkSettings('pop-online-recharge') == 'enable'): ?>
                                    
                                    <td>
                                        <?php if($r->enable_online_recharge): ?>
                                            <a href="<?php echo e(route('onlinePopRecharge', $r->id)); ?>" class="btn btn-danger">Online
                                                Recharge</a>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>

                                <td>
                                    <?php echo e($r->reseller->name ?? ''); ?>

                                </td>

                                <td>
                                    <?php echo e($r->pop_location); ?>

                                </td>
                                <?php if(auth()->check() && auth()->user()->hasAnyRole('Admin|Support Executive')): ?>
                                    <td>
                                        <?php echo e($r->nas->nasname ?? ''); ?>

                                    </td>
                                <?php endif; ?>

                                <td>
                                    <?php echo e($r->pop_contact); ?>

                                </td>
                                <td>
                                    <?php echo e($r->subreseller); ?>

                                </td>

                                
                                <?php if(auth()->check() && auth()->user()->hasRole('Admin')): ?>
                                    <td>
                                        <?php echo e($r->bill_generate); ?>

                                    </td>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['show-pop-balance', 'specific_management_services'])): ?>
                                    <td class="font-weight-bold border p-1 text-center ">
                                        <?php if($r->subreseller == 'yes'): ?>
                                            <?php echo e($r->balance->first()->amount ?? ''); ?>

                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>


                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-disable')): ?>
                                    <td>
                                        <div class="pop_disable_wrapper">
                                            <?php if($r->pop_disable == 'no'): ?>
                                                
                                                <span class="badge badge-primary">Active</span>
                                            <?php endif; ?>

                                            <?php if($r->pop_disable == 'yes'): ?>
                                                
                                                <span class="badge badge-danger">Inactive</span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                <?php endif; ?>


                                <td class="whitespace-nowrap text-right text-sm font-medium">
                                    <div class="dropdown">
                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="btn-primary dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sub-reseller-view-commission')): ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('view-sub-reseller-commission', $r->id)); ?>">View Commission
                                                    History
                                                </a>
                                            <?php endif; ?>
                                            <?php if($r->subreseller == 'yes'): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-recharge')): ?>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('subResellerRecharge', $r->id)); ?>">Recharge</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['sub-package-permission', 'specific_management_services'])): ?>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('sub_package_permission', $r->id)); ?>">Sub Package
                                                        Permission</a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if(Auth()->user()->can('pop_edit') || Auth()->user()->can('pop-accounts-edit')): ?>
                                                <a class="dropdown-item" href="<?php echo e(route('pop.edit', $r->id)); ?>">Edit</a>
                                            <?php endif; ?>




                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('specific_management_services')): ?>
                                                <?php if($checkAPI): ?>
                                                    <form action="<?php echo e(route('syncPopWithMikrotik')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="pop_id" value="<?php echo e($r->id); ?>">
                                                        <button type="submit" class="dropdown-item">Sync with Mikrotik</button>
                                                    </form>
                                                <?php else: ?>
                                                    <form action="<?php echo e(route('syncPopForRadius')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="pop_id" value="<?php echo e($r->id); ?>">
                                                        <button type="submit" class="dropdown-item">Sync for radius</button>
                                                    </form>
                                                <?php endif; ?>
                                            <?php endif; ?>


                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-deactive')): ?>
                                                <a class="dropdown-item" href="<?php echo e(route('pop-deactive', $r->id)); ?>">Deactive
                                                    All Customer</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-close')): ?>
                                                <a class="dropdown-item" href="<?php echo e(route('pop-close', $r->id)); ?>">Close All
                                                    Customer</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-pop-log-history')): ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('editLog-history', ['id' => $r->id, 'type' => 'POP'])); ?>">History</a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-disable')): ?>
                                                <?php if($r->pop_disable == 'no'): ?>
                                                    <button data-id="<?php echo e($r->id); ?>"
                                                        class="pop_disable btn dropdown-item">Disable POP</button>
                                                <?php endif; ?>

                                                <?php if($r->pop_disable == 'yes'): ?>
                                                    <button data-id="<?php echo e($r->id); ?>"
                                                        class="pop_enable btn dropdown-item">Enable Pop</button>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-online-client-from-pop-manager')): ?>
                                                <?php if(!checkAPI()): ?>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('delete-online-pop-clients', ['id' => $r->id, 'type' => 'Pop'])); ?>">Delete
                                                        from online</a>
                                                <?php endif; ?>
                                            <?php endif; ?>


                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="pop-recharge">
        <div class="modal-dialog">
            <form action="<?php echo e(route('subRsellerRechargeUpdate')); ?>" method="POST" class="recharge-form">
                <?php echo csrf_field(); ?>
                <?php echo method_field('post'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Pop Recharge</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center" id="modalAlert"></div>

                        <div class="row">

                            <div class="col-md-4">Recharge To</div>

                            <div class="col-md-8 mb-2">
                                <select class="form-control select2" name="type_id" id="">
                                    <option value="">Select Pop</option>
                                    <?php $__currentLoopData = $pop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($r->subreseller == 'yes'): ?>
                                            <option value="<?php echo e($r->id); ?>"><?php echo e($r->popname); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>



                            <div class="col-md-4">Recharge Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" name="amount" class="form-control">
                            </div>

                            <div class="col-md-4">Remark</div>
                            <div class="col-md-8 mb-2">
                                <input type="text" name="remark" id="remark" class="form-control">

                            </div>

                            <input type="hidden" value="pop" name="type">


                        </div>


                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary recharge-submit" type="submit" id="modalSave"><i
                                class="fa fa-spin fa-spinner spinner"></i> Recharge</button>
                    </div>

                </div>
                <!-- /.modal-content -->
            </form>
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php $__env->stopSection(); ?>

<?php if(!auth()->check() || ! auth()->user()->hasRole('Reseller')): ?>
    <?php $__env->startSection('ajax'); ?>
        <script>
            $(function() {

                $('#newDataTable').DataTable({
                    responsive: true,
                    "bProcessing": true,
                    "iDisplayLength": 100,
                    'order': [
                        [1, "asc"]
                    ]
                });

                $('.recharge-form').on('submit', function() {
                    $('.spinner').show();
                    $('.recharge-submit').attr('disabled', 'true');

                });

                $(document).on('click', '.pop_disable', function() {
                    if (confirm('Are you sure, you want to disable the pop??')) {


                        let id = $(this).data('id');
                        let section = $(this).closest('.pop_disable_wrapper');
                        startProcessing();
                        $.ajax({
                            type: 'post',
                            url: '<?php echo e(route('pop_disable')); ?>',
                            data: {
                                'id': id
                            },
                            success: function(data) {

                                stopProcessing();

                                if (data == 1) {
                                    section.html('<button data-id="' + id +
                                        '" class="pop_enable btn btn-success btn-xs">Enable Pop</button>'
                                    );
                                    toastr.success('Pop Disable Success!!');
                                }

                                if (data == 0) {
                                    toastr.error('Something is worng');
                                }
                            }
                        });

                    }
                });

                $(document).on('click', '.pop_enable', function() {
                    if (confirm('Are you sure, you want to Enable the pop??')) {
                        let id = $(this).data('id');
                        let section = $(this).closest('.pop_disable_wrapper');
                        startProcessing();
                        $.ajax({
                            type: 'post',
                            url: '<?php echo e(route('pop_enable')); ?>',
                            data: {
                                'id': id
                            },

                            success: function(data) {

                                stopProcessing();
                                if (data == 1) {

                                    section.html('<button data-id="' + id +
                                        '" class="pop_disable btn btn-danger btn-xs">Disable Pop</button>'
                                    );
                                    toastr.success('Pop Enable Success!!');
                                }

                                if (data == 0) {
                                    toastr.error('Something is worng');
                                }
                            }
                        });
                    }


                });

                var modalopen = "<?php echo e(session('modalopen')); ?>";

                if (modalopen == "true") {
                    $('.poprecharge').trigger('click');
                }

            });
        </script>
    <?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/netlink/radius-circle/resources/views/pop/index.blade.php ENDPATH**/ ?>