<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <!-- /.card-header -->
                <div class="card-body">
                    <p class="float-left">Total Manager: <?php echo e($resellersCount); ?></p>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reseller-recharge')): ?>
                        <button type="button" class="poprecharge btn btn-primary float-right" data-toggle="modal"
                            data-target="#reseller-recharge">
                            Manager Recharge
                        </button>
                    <?php endif; ?>
                </div>
                <?php if(checkSettings('reseller-can-recharge-from-commission') == 'enable'): ?>
                    
                    <div class="card-body">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('can_recharge_from_manager_commission')): ?>
                            <button type="button" class="btn btn-primary" data-toggle="modal"
                                data-target="#modal-fund-transfer">
                                Commission Transfer To Balance
                            </button>
                        <?php endif; ?>
                    </div>
                    
                <?php endif; ?>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataTable" class="display table">
                            <thead class="bg-gray-50">
                                <tr>

                                    <th scope="col">
                                        ID
                                    </th>
                                    <th scope="col">
                                        Manager Name
                                    </th>
                                    <th>

                                    </th>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['reseller_type', 'specific_management_services'])): ?>
                                        <th scope="col">
                                            Reseller Type
                                        </th>
                                    <?php endif; ?>


                                    <th scope="col">
                                        Address
                                    </th>
                                    <th scope="col">
                                        Contact No
                                    </th>



                                    <th scope="col">
                                        Balance
                                    </th>
                                    <?php if(checkSettings('reseller-recharge-paid-option') == 'enable'): ?>
                                        <th scope="col">
                                            Total Due
                                        </th>
                                    <?php endif; ?>

                                    <?php if(auth()->check() && auth()->user()->hasRole('Admin')): ?>
                                        <th scope="col">
                                            Remark
                                        </th>
                                    <?php endif; ?>
                                    <?php if(checkSettings('manager_status') == 'enable'): ?>
                                        <th scope="col">
                                            Status
                                        </th>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager_unique_code')): ?>
                                        <th scope="col">
                                            Unique Code
                                        </th>
                                    <?php endif; ?>

                                    <th scope="col">

                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">

                                <?php $__currentLoopData = $resellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <tr>
                                        <td class="whitespace-nowrap">
                                            <?php echo e($r->id); ?>

                                        </td>
                                        <td class="whitespace-nowrap">
                                            <?php echo e($r->name); ?>

                                        </td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('specific_management_services')): ?>
                                                <?php if(checkSettings('reseller-online-recharge') == 'enable'): ?>
                                                    <?php if($r->enable_online_recharge): ?>
                                                        <a href="<?php echo e(route('onlineManagerRecharge', $r->id)); ?>"
                                                            class="btn btn-danger">Online Recharge</a>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['reseller_type', 'specific_management_services'])): ?>
                                            <td class="whitespace-nowrap">
                                                <?php echo e($r->reseller_type); ?>

                                            </td>
                                        <?php endif; ?>

                                        <td class="whitespace-nowrap text-sm text-gray-500">
                                            <?php echo e($r->address); ?>

                                        </td>

                                        <td class="whitespace-nowrap">
                                            <?php echo e($r->contact); ?>

                                        </td>

                                        <td class="whitespace-nowrap text-sm text-gray-500">

                                            <?php echo e($r->balance[0]['amount'] ?? 0); ?>


                                        </td>

                                        <?php if(checkSettings('reseller-recharge-paid-option') == 'enable'): ?>
                                            <td class="whitespace-nowrap text-sm text-gray-500">

                                                <?php $__currentLoopData = $due; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($d->reseller_id == $r->id): ?>
                                                        <?php echo e($d->tamount - $d->tpaid); ?>

                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                                



                                            </td>
                                        <?php endif; ?>

                                        <?php if(auth()->check() && auth()->user()->hasAllRoles('Admin')): ?>
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                <?php echo e($r->remark ?? ''); ?>

                                            </td>
                                        <?php endif; ?>

                                        <?php if(checkSettings('manager_status') == 'enable'): ?>
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                <?php echo e($r->status == 'active' ? 'Active' : 'Inactive'); ?>

                                            </td>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager_unique_code')): ?>
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                <?php echo e($r->manager_unique_code ?? ''); ?>

                                            </td>
                                        <?php endif; ?>

                                        <td class="whitespace-nowrap text-right text-sm font-medium">
                                            <div class="dropdown">
                                                <button class="btn btn-primary dropdown-toggle" type="button"
                                                    id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                    aria-expanded="false">
                                                    Action
                                                </button>
                                                <div class="btn-primary dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-commission')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('view-reseller-commission', $r->id)); ?>">View
                                                            Commission History</a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reseller-recharge')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('reseller.recharge', $r->id)); ?>">Recharge</a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['package-permission', 'specific_management_services'])): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('reseller.permission', $r->id)); ?>">Package
                                                            Permission</a>
                                                    <?php endif; ?>
                                                    <?php if(Auth()->user()->can('reseller_edit') || Auth()->user()->can('manager-accounts-edit')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('resellers.edit', $r->id)); ?>">Edit</a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-reseller-history')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('editLog-history', ['id' => $r->id, 'type' => 'Manager'])); ?>">History</a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reseller-sms-getway')): ?>
                                                        <?php if($r->reseller_type == 'other' || globalPermission('customResellerSmsGatewaySetup')): ?>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('reseller-sms-gateway', $r->id)); ?>">Sms
                                                                Gateway</a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                    <?php if(checkSettings('ResellerClientOnlineRecharge') == 'enable' && Auth()->user()->id == 1): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('paymentGetwayCredential', $r->id)); ?>">Payment
                                                            Getway</a>
                                                    <?php endif; ?>

                                                    <?php if($r->reseller_type == 'other' || globalPermission('customResellerSmsGatewaySetup')): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('reseller-sms-balance', $r->id)); ?>">Sms
                                                            Balance</a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-online-client-from-pop-manager')): ?>
                                                        <?php if(!checkAPI()): ?>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('delete-online-pop-clients', ['id' => $r->id, 'type' => 'Reseller'])); ?>">Delete
                                                                from online</a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>


                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <!-- More items... -->
                            </tbody>
                        </table>
                    </div>


                </div>


            </div>


            <!-- /.card-body -->
            <div class="card-footer clearfix">
                <?php echo e($resellers->links()); ?>

            </div>
        </div>
    </div>
    </div>

    <div class="modal fade" id="reseller-recharge">
        <div class="modal-dialog">
            <form action="<?php echo e(route('resellerRecharge.store')); ?>" method="POST" class="recharge-form">
                <?php echo csrf_field(); ?>
                <?php echo method_field('post'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Reseller Recharge</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center" id="modalAlert"></div>

                        <div class="row">

                            <div class="col-md-4">Recharge To</div>
                            <div class="col-md-8 mb-2">
                                <select class="form-control select2" name="reseller_id" id="">
                                    <option value="">Select Reseller</option>
                                    <?php $__currentLoopData = $resellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>



                            <div class="col-md-4">Recharge Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" name="amount" class="form-control">
                            </div>

                            <?php if(checkSettings('reseller-recharge-paid-option') == 'enable'): ?>
                                <div class="col-md-4">Paid Amount</div>
                                <div class="col-md-8 mb-2">
                                    <input type="number" name="paid_amount" class="form-control">
                                </div>
                            <?php endif; ?>

                            <div class="col-md-4">Remark*</div>
                            <div class="col-md-8 mb-2">
                                <input type="text" name="remark" id="remark" class="form-control" required>
                            </div>


                        </div>


                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary recharge-submit" type="submit" id="modalSave">Recharge</button>
                    </div>

                </div>
                <!-- /.modal-content -->
            </form>
        </div>
        <!-- /.modal-dialog -->
    </div>


    <div class="modal fade" id="modal-fund-transfer">
        <div class="modal-dialog">
            <form action="<?php echo e(route('commission-transfer')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('post'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Commission Transfer</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center" id="modalAlert"></div>
                        <div class="row">
                            <?php
                                $totalAmount = 0;
                            ?>
                            <div class="col-md-4">Commission Send To</div>
                            <div class="col-md-8 mb-2">
                                <select class="form-control select2" name="received_by" id="">
                                    <option value="">Select Reseller</option>
                                    <?php $__currentLoopData = $managers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $totalAmount = 0;
                                            foreach ($accounts as $ac) {
                                                if ($ac->reseller_id == $s->id) {
                                                    $totalAmount += $ac->ramount - $ac->pamount;
                                                }
                                            }
                                        ?>
                                        <?php if($totalAmount > 0): ?>
                                            <option value="<?php echo e($s->id); ?>">
                                                <?php echo e($s->name); ?> -- BDT <?php echo e($totalAmount); ?>

                                            </option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="hidden" name="transfer_type" value="fund_transfer">
                            </div>

                            <div class="col-md-4">Transfer Type</div>
                            <div class="col-md-8 mb-2">
                                <select name="txn_type" class="form-control select2">
                                    <option value="ManagerRecharge">Account Recharge</option>
                                </select>
                            </div>

                            <div class="col-md-4">Transfer Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" name="amount" value="" class="form-control">
                            </div>

                            <div class="col-md-4">Note</div>
                            <div class="col-md-8 mb-2">
                                <textarea name="note" id="note" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary" type="submit" id="modalSave">Transfer</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if(!auth()->check() || ! auth()->user()->hasRole('Reseller')): ?>
    <?php $__env->startSection('ajax'); ?>
        <script>
            $(function() {

                $('.recharge-form').on('submit', function() {
                    $('.recharge-submit').attr('disabled', 'true');
                });

                // Disable "Transfer" button after first submit to prevent double submission
                $('#modal-fund-transfer form').on('submit', function() {
                    $('#modal-fund-transfer button[type="submit"]').attr('disabled', 'true');
                });

                var modalopen = "<?php echo e(session('modalopen')); ?>";

                if (modalopen == "true") {
                    $('.poprecharge').trigger('click');
                }

            });
        </script>
    <?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/netlink/radius-circle/resources/views/reseller/index.blade.php ENDPATH**/ ?>