<?php

namespace App\Http\Controllers;

use App\Classes\Accounting\Accounting;
use App\Models\Client;
use App\Models\Pop;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Predis\Command\Argument\Server\To;

class ClientSessionController extends Controller
{
    public function deleteOnlinePopClients($id, $type)
    {
        if($type == 'Pop') {
            $clients = Client::where('pop_id', $id)->get();
        } elseif ($type == 'Reseller') {
            $pops = Pop::where('reseller_id', $id)->pluck('id');
            $clients = Client::whereIn('pop_id', $pops)->get();
        }

        foreach ($clients as $client) {
            $accounting = new Accounting();
            $accounting->setSingleUserOfflineToSoftware($client->userid);
        }

        Toastr::success('Removed from online list', 'Success');
        return redirect()->back();
    }


}
