@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="m-2">
                <a href="{{ route('all-customer-bill-generate') }}" class="btn btn-sm btn-primary" onclick="showAlert()">Generate Current Month Bill</a>
            </div>

            @php
                $currentYear = date('Y');
                $months = [
                    1 => 'January',
                    2 => 'February',
                    3 => 'March',
                    4 => 'April',
                    5 => 'May',
                    6 => 'June',
                    7 => 'July',
                    8 => 'August',
                    9 => 'September',
                    10 => 'October',
                    11 => 'November',
                    12 => 'December',
                ];
            @endphp

            <form method="POST" action="{{ route('generateMonthlyBill') }}">
                @csrf
                <div class="form-group">
                    <label for="year">Year</label>
                    <select name="year" id="year" class="form-control" required>
                        <option value="">Select Year</option>
                        @for ($year = $currentYear; $year >= $currentYear - 10; $year--)
                            <option value="{{ $year }}">{{ $year }}</option>
                        @endfor
                    </select>
                </div>
                <div class="form-group">
                    <label for="month">Month</label>
                    <select name="month" id="month" class="form-control" required>
                        <option value="">Select Month</option>
                        @foreach ($months as $monthNumber => $monthName)
                            <option value="{{ $monthNumber }}">{{ $monthName }}</option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Generate Bill</button>
            </form>

        </div>
    </div>


    <style>

    </style>
@endsection

@section('ajax')
<script>
    function showAlert() {
        alert("Are You Sure To Generate Current Month Bill?");
    }
    </script>
@endsection
