import { createRoot } from "react-dom/client";
import { store } from "./store/index";
import { Provider } from "react-redux";
import App from "./App";
import { MapContext } from "./context/MapContext";
import { EditableContextProvider } from "./context/EditablePolylineContext";
import { LocateCoordinateContextProvider } from "./context/LocateCoordinateContext";

if (document.getElementById("root")) {
    const domNode = document.getElementById("root");
    const root = createRoot(domNode);
    root.render(
        <Provider store={store}>
            <MapContext>
                <LocateCoordinateContextProvider>
                    <EditableContextProvider>
                        <App />
                    </EditableContextProvider>
                </LocateCoordinateContextProvider>
            </MapContext>
        </Provider>
    );
}
