<!DOCTYPE HTML>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title></title>
    <style type="text/css">
        table {
            page-break-inside: auto
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto
        }

        thead {
            display: table-header-group
        }

        tfoot {
            display: table-footer-group
        }
    </style>
</head>

<body onload="window.print()" onfocus="window.close()">

    @if (checkSettings('largeFontInBillsheet') == 'enable')
        <style>
            @media print {

                table,
                tr,
                thead th,
                td {
                    font-size: 10px !important;
                    padding: 2px !important;
                    border: 1px solid #010a02;
                    border-collapse: collapse;
                }
            }
        </style>
    @else
        <style>
            @media print {

                table,
                tr,
                thead th,
                td {
                    font-size: 9px !important;
                    padding: 2px !important;
                    border: 1px solid #010a02;
                    border-collapse: collapse;
                }
            }
        </style>
    @endif

    <style>
        @media print {

            #pop,
            button {
                visibility: hidden;
            }
        }

        .container {
            width: 940px;
            margin: 0 auto;
            padding: 10px;
        }

        .table {

            border-collapse: collapse;
            width: 100%;
            border: 1px solid #4CAF50;
        }

        h2 {
            text-align: center;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th,
        td {
            border: 1px solid #bbb;
            padding: 10px;
            text-align: left;
        }

        tr:hover {
            background-color: #e5e5e5
        }
    </style>

    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">
            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
                        <div class="flex justify-between noprint">

                            <div class="p-2 mb-5">
                                <button type="button" onclick="window.print()">Print
                                    <i class="fa fa-print"></i>
                                </button>
                            </div>
                            <div
                                style="display: flex; justify-content: center; align-items: center; text-align: center; height: 20px;">
                                @php
                                    $siteInfo = siteinfo();
                                @endphp
                                @if (!empty($siteInfo))
                                    <div style="">
                                        <img width="auto" height="20"
                                            src="{{ asset('storage/company/' . $siteInfo->img_url ?? '') }}"
                                            alt="{{ $siteInfo->name }}">
                                    </div>
                                    <div style="margin: 1%;">
                                        <h4 style="font-size: 1.5rem; text-transform: capitalize; letter-spacing: 1px;">
                                            {{ $siteInfo->name }}
                                        </h4>
                                    </div>
                                @endif
                            </div>

                            {{-- <div class="p-2 mb-5">
                                <select name="pop" id="pop" class="p-2 border rounded">
                                    <option value="">Select Pop/Zone</option>
                                    <option value="all">All Pop/Zone</option>

                                    @foreach ($poplist as $pop)

                                    <option value="{{$pop->id}}">{{ $pop->popname }}</option>
                                    @endforeach
                                </select>
                            </div> --}}
                        </div>
                        {{-- request()->type!='' && --}}
                        @if (request()->type != 'all')

                            @foreach ($poplist as $pop)
                                @if (request()->search == 'pop')
                                    @if ($pop->id == request()->type)
                                        <h2 class="text-center bold text-xl font-bold pb-5 mt-1 pop{{ $pop->id }}">
                                            View Customer Billing Information Of: {{ $pop->popname }} (
                                            {{ date('M-Y') }} )</h2>
                                    @endif
                                @endif
                            @endforeach

                            @foreach ($reseller as $r)
                                @if (request()->search == 'resellers')
                                    @if ($r->id == request()->type)
                                        <h2 class="text-center bold text-xl font-bold pb-5 mt-1 pop{{ $r->id }}">
                                            View Customer Billing Information Of: {{ $r->name }} (
                                            {{ date('M-Y') }} )</h2>
                                    @endif
                                @endif
                            @endforeach

                            @if (request()->search == 'area')
                                <h2 class="text-center bold text-xl font-bold pb-2 mt-1">View Customer
                                    Billing
                                    Information Of: {{ request()->type }} ( {{ date('M-Y') }} )</h2>
                            @endif

                            <hr>


                            <table class="table-auto min-w-full divide-y divide-gray-200 pt-2 pop{{ $pop->id }}">
                                <thead class="bg-gray-50 table-header-group">
                                    <tr>
                                        <th>ID</th>
                                        <th class="whitespace-nowrap">User name</th>
                                        <th>Name</th>
                                        <th>Contact</th>
                                        <th>Joining Date</th>
                                        <th>Address</th>
                                        <th>Zone/POP</th>
                                        <th>Package</th>
                                        <th>Type</th>
                                        <th>Bill Date</th>
                                        <th>Previous Due</th>
                                        <th>Due Amount</th>
                                        {{-- <th>Total Dues</th> --}}

                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @php($total = 0)
                                    @foreach ($list as $r)
                                        @php($r->dueAmount > 0 ? ($total += $r->dueAmount) : 0)

                                        @if ($due == 'yes' && $r->dueAmount > 0)
                                            <tr>

                                                <td>
                                                    @php(printf('CID%04d', $r->id))
                                                </td>
                                                <td>
                                                    {{ $r->userid }}
                                                </td>

                                                <td class="whitespace-nowrap">
                                                    {{ $r->clients_name ?? '' }}

                                                </td>


                                                <td>
                                                    {{ $r->contact_no ?? '' }}
                                                </td>

                                                <td>
                                                    {{ date('d-M-Y', strtotime($r->joinDate)) }}
                                                </td>
                                                <td>
                                                    @if (!empty($r->area))
                                                        <b>Area :</b> {{ $r->area ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->block_sector))
                                                        <b>Block/Sector :</b> {{ $r->block_sector ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->road_name))
                                                        <b>R Name :</b> {{ $r->road_name ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->road_no))
                                                        <b>R No :</b> {{ $r->road_no ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->building_name))
                                                        <b>B Name :</b> {{ $r->building_name ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->building_no))
                                                        <b>B No :</b> {{ $r->building_no ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->flat_no))
                                                        <b>F No :</b> {{ $r->flat_no ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->owner_name))
                                                        <b>H O :</b> {{ $r->owner_name ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->box))
                                                        <b>Box :</b> {{ $r->box ?? '' }}
                                                    @endif
                                                </td>

                                                <td>
                                                    {{ $r->popname }}
                                                </td>

                                                <td>
                                                    {{ $r->package_name }}
                                                </td>

                                                <td>
                                                    {{ $r->billing_type }}
                                                </td>

                                                <td class="whitespace-nowrap">
                                                    @if ($r->billing_type == 'new')
                                                        {{ date('d-M-Y', strtotime($r->created_at)) }}
                                                    @else
                                                        {{ date('d-M-Y', strtotime($r->due_date)) }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($r->dueAmount - $r->package_rate > 0)
                                                        {{ $r->dueAmount - $r->package_rate }}
                                                    @else
                                                        {{ 0 }}
                                                    @endif

                                                </td>
                                                <td class="text-right">
                                                    {{ $r->dueAmount }}
                                                </td>
                                                {{-- <td>
                                                {{ $r->dueAmount - $r->totalPaid }}
                                            </td> --}}

                                            </tr>
                                        @endif

                                        @if ($due == 'no' && $r->dueAmount == 0)
                                            <tr>

                                                <td>
                                                    @php(printf('CID%04d', $r->id))
                                                </td>
                                                <td>
                                                    {{ $r->userid }}
                                                </td>

                                                <td class="whitespace-nowrap">
                                                    {{ $r->clients_name ?? '' }}

                                                </td>


                                                <td>
                                                    {{ $r->contact_no ?? '' }}
                                                </td>

                                                <td>
                                                    {{ date('d-M-Y', strtotime($r->joinDate)) }}
                                                </td>
                                                <td>
                                                    @if (!empty($r->area))
                                                        <b>Area :</b> {{ $r->area ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->block_sector))
                                                        <b>Block/Sector :</b> {{ $r->block_sector ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->road_name))
                                                        <b>R Name :</b> {{ $r->road_name ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->road_no))
                                                        <b>R No :</b> {{ $r->road_no ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->building_name))
                                                        <b>B Name :</b> {{ $r->building_name ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->building_no))
                                                        <b>B No :</b> {{ $r->building_no ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->flat_no))
                                                        <b>F No :</b> {{ $r->flat_no ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->owner_name))
                                                        <b>H O :</b> {{ $r->owner_name ?? '' }}.
                                                    @endif
                                                    @if (!empty($r->box))
                                                        <b>Box :</b> {{ $r->box ?? '' }}
                                                    @endif
                                                </td>

                                                <td>
                                                    {{ $r->popname }}
                                                </td>

                                                <td>
                                                    {{ $r->package_name }}
                                                </td>

                                                <td>
                                                    {{ $r->billing_type }}
                                                </td>

                                                <td class="whitespace-nowrap">
                                                    @if ($r->billing_type == 'new')
                                                        {{ date('d-M-Y', strtotime($r->created_at)) }}
                                                    @else
                                                        {{ date('d-M-Y', strtotime($r->due_date)) }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($r->dueAmount - $r->package_rate > 0)
                                                        {{ $r->dueAmount - $r->package_rate }}
                                                    @else
                                                        {{ 0 }}
                                                    @endif

                                                </td>
                                                <td class="text-right">
                                                    {{ $r->dueAmount }}
                                                </td>
                                                {{-- <td>
                                            {{ $r->dueAmount - $r->totalPaid }}
                                            </td> --}}

                                            </tr>
                                        @endif
                                    @endforeach
                                    @if ($due == 'yes')
                                        <tr>
                                            <td colspan="11" class="text-right">Total Due Amount</td>
                                            <td class="text-right">BDT {{ $total }}</td>
                                        </tr>
                                    @endif
                                    <!-- More items... -->
                                </tbody>
                            </table>
                        @else
                            @foreach ($poplist as $pop)
                                <h2 class="text-center bold text-xl font-bold pb-5 mt-5 pop{{ $pop->id }}">View
                                    Customer Billing Information Of: {{ $pop->popname }} ( {{ date('M-Y') }} )
                                </h2>
                                <hr>


                                <table
                                    class="table-auto min-w-full divide-y divide-gray-200 pt-2 pop{{ $pop->id }}">
                                    <thead class="bg-gray-50 table-header-group">
                                        <tr>
                                            <th>ID</th>
                                            <th class="whitespace-nowrap">User name</th>
                                            <th>Name</th>
                                            <th>Contact</th>
                                            <th>Address</th>
                                            <th>Zone/POP</th>
                                            <th>Package</th>
                                            <th>Type</th>
                                            <th>Bill Date</th>
                                            <th>Previous Due</th>
                                            <th>Due Amount</th>
                                            {{-- <th>Total Dues</th> --}}

                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        @php($total = 0)
                                        @foreach ($list as $r)
                                            @if ($r->pop_id == $pop->id)
                                                {{-- {{dd($r)}} --}}
                                                {{-- @php($total += $r->dueAmount) --}}
                                                @php($r->dueAmount > 0 ? ($total += $r->dueAmount) : 0)
                                                {{-- {{dd($r)}} --}}
                                                @if ($due == 'yes' && $r->dueAmount > 0)
                                                    <tr>

                                                        <td>
                                                            @php(printf('CID%04d', $r->id))
                                                        </td>
                                                        <td>
                                                            {{ $r->userid }}
                                                        </td>

                                                        <td class="whitespace-nowrap">
                                                            {{ $r->clients_name ?? '' }}

                                                        </td>


                                                        <td>
                                                            {{ $r->contact_no ?? '' }}
                                                        </td>
                                                        <td>
                                                            @if (!empty($r->area))
                                                                <b>Area :</b> {{ $r->area ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->block_sector))
                                                                <b>Block/Sector :</b> {{ $r->block_sector ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->road_name))
                                                                <b>R Name :</b> {{ $r->road_name ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->road_no))
                                                                <b>R No :</b> {{ $r->road_no ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->building_name))
                                                                <b>B Name :</b> {{ $r->building_name ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->building_no))
                                                                <b>B No :</b> {{ $r->building_no ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->flat_no))
                                                                <b>F No :</b> {{ $r->flat_no ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->owner_name))
                                                                <b>H O :</b> {{ $r->owner_name ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->box))
                                                                <b>Box :</b> {{ $r->box ?? '' }}
                                                            @endif
                                                        </td>

                                                        <td>
                                                            {{ $r->popname }}
                                                        </td>

                                                        <td>
                                                            {{ $r->package_name }}
                                                        </td>

                                                        <td>
                                                            {{ $r->billing_type }}
                                                        </td>

                                                        <td class="whitespace-nowrap">
                                                            @if ($r->billing_type == 'new')
                                                                {{ date('d-M-Y', strtotime($r->created_at)) }}
                                                            @else
                                                                {{ date('d-M-Y', strtotime($r->due_date)) }}
                                                            @endif
                                                        </td>

                                                        <td>
                                                            @if ($r->dueAmount - $r->package_rate > 0)
                                                                {{ $r->dueAmount - $r->package_rate }}
                                                            @else
                                                                {{ 0 }}
                                                            @endif

                                                        </td>
                                                        <td class="text-right">
                                                            {{ $r->dueAmount }}
                                                        </td>
                                                        {{-- <td>
                                                        {{ $r->dueAmount - $r->totalPaid }}
                                                    </td> --}}

                                                    </tr>
                                                @endif

                                                @if ($due == 'no' && $r->dueAmount == 0)
                                                    <tr>

                                                        <td>
                                                            @php(printf('CID%04d', $r->id))
                                                        </td>
                                                        <td>
                                                            {{ $r->userid }}
                                                        </td>

                                                        <td class="whitespace-nowrap">
                                                            {{ $r->clients_name ?? '' }}

                                                        </td>


                                                        <td>
                                                            {{ $r->contact_no ?? '' }}
                                                        </td>
                                                        <td>
                                                            @if (!empty($r->area))
                                                                <b>Area :</b> {{ $r->area ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->block_sector))
                                                                <b>Block/Sector :</b> {{ $r->block_sector ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->road_name))
                                                                <b>R Name :</b> {{ $r->road_name ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->road_no))
                                                                <b>R No :</b> {{ $r->road_no ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->building_name))
                                                                <b>B Name :</b> {{ $r->building_name ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->building_no))
                                                                <b>B No :</b> {{ $r->building_no ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->flat_no))
                                                                <b>F No :</b> {{ $r->flat_no ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->owner_name))
                                                                <b>H O :</b> {{ $r->owner_name ?? '' }}.
                                                            @endif
                                                            @if (!empty($r->box))
                                                                <b>Box :</b> {{ $r->box ?? '' }}
                                                            @endif
                                                        </td>

                                                        <td>
                                                            {{ $r->popname }}
                                                        </td>

                                                        <td>
                                                            {{ $r->package_name }}
                                                        </td>

                                                        <td>
                                                            {{ $r->billing_type }}
                                                        </td>

                                                        <td class="whitespace-nowrap">
                                                            @if ($r->billing_type == 'new')
                                                                {{ date('d-M-Y', strtotime($r->created_at)) }}
                                                            @else
                                                                {{ date('d-M-Y', strtotime($r->due_date)) }}
                                                            @endif
                                                        </td>

                                                        <td>
                                                            @if ($r->dueAmount - $r->package_rate > 0)
                                                                {{ $r->dueAmount - $r->package_rate }}
                                                            @else
                                                                {{ 0 }}
                                                            @endif

                                                        </td>
                                                        <td class="text-right">
                                                            {{ $r->dueAmount }}
                                                        </td>
                                                        {{-- <td>
                                                        {{ $r->dueAmount - $r->totalPaid }}
                                                    </td> --}}

                                                    </tr>
                                                @endif
                                            @endif
                                        @endforeach
                                        @if ($due == 'yes')
                                            <tr>
                                                <td colspan="10" class="text-right">Total Due Amount</td>
                                                <td class="text-right">BDT {{ $total }}</td>
                                            </tr>
                                        @endif
                                        <!-- More items... -->
                                    </tbody>
                                </table>
                            @endforeach
                        @endif

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        window.onload = function() {
            window.print();
        }

        window.onfocus = function() {
            window.close();
        }
    </script>



</body>

</html>
