@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    {{-- @if (auth()->user()->hasrole('Admin')) --}}
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Select Manager Type</label>
                                <select name="reseller_type" id="reseller_type" class="select2 form-control">
                                    <option value="">All Manager </option>
                                    <option value="own">Own</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                    {{-- @endif --}}
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Select Manager </label>
                            <select name="reseller_id" id="reseller_id" class="select2 form-control">
                                <option value="">All Manager </option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>

                <div id="result"></div>

            </form>
        </div>
    </div>
@endsection

@section('ajax')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('#processing').show();
                $.ajax({
                    type: 'get',
                    url: '{{ route('resellerWiseTotalCostResult') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').hide();

                    }
                });
            });
            $('#reseller_id').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getSubPopOfReseller') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#loading').remove();

                    }
                });
            });
        });
    </script>

    <script>
        function export2csv() {
            const rows = document.querySelectorAll("table#tableId tr");
            const data = [];

            // Extract table data
            for (const row of rows) {
                const rowData = [];
                for (const column of row.querySelectorAll("th, td")) {
                    rowData.push(column.innerText.trim());
                }
                data.push(rowData);
            }

            // Create worksheet
            const ws = XLSX.utils.aoa_to_sheet(data);

            // Set column 3 (index 3, which is column D) as text format
            const range = XLSX.utils.decode_range(ws['!ref']);
            for (let R = range.s.r; R <= range.e.r; ++R) {
                const cellAddress = XLSX.utils.encode_cell({
                    r: R,
                    c: 3
                }); // Column 3
                if (ws[cellAddress]) {
                    ws[cellAddress].t = 's'; // 's' = string/text type
                    ws[cellAddress].z = '@'; // '@' = text format code
                }
            }

            // Optional: Set column width
            ws['!cols'] = ws['!cols'] || [];
            ws['!cols'][3] = {
                wch: 15
            }; // Set width for column 3

            // Create workbook and download
            const wb = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(wb, ws, "Data");
            XLSX.writeFile(wb, "data.xlsx");
        }
    </script>
@endsection
