<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SecondEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $message;
  public $channelID;

  public function __construct($channelID, $message)
  {
      $this->message = $message;
      $this->channelID =$channelID;
  }

  public function broadcastOn()
  {
    //   dd($this->channelID);
      return [$this->channelID];
  }

  public function broadcastAs()
  {
      return ('my-event');
  }
}
